/*
 * Decompiled with CFR 0.152.
 */
package com.turtlehoarder.cobblemonchallenge.common.validation.validators;

import com.cobblemon.mod.common.api.storage.party.PlayerPartyStore;
import com.cobblemon.mod.common.pokemon.Pokemon;
import com.turtlehoarder.cobblemonchallenge.common.validation.TeamValidator;
import java.util.function.BiFunction;
import java.util.function.Predicate;

public class TeamCounterValidator
implements TeamValidator {
    private final int maxCount;
    private final String id;
    private final Predicate<Pokemon> shouldCount;

    public TeamCounterValidator(BiFunction<String, Integer, Integer> intGetter, String id, Predicate<Pokemon> shouldCount) {
        this.maxCount = intGetter.apply("max" + id, Integer.MAX_VALUE);
        this.id = id;
        this.shouldCount = shouldCount;
    }

    @Override
    public String validate(PlayerPartyStore playerParty) {
        int count = 0;
        for (Pokemon pokemon : playerParty) {
            if (!this.shouldCount.test(pokemon)) continue;
            ++count;
        }
        if (count > this.maxCount) {
            return "Exceeded the maximum amount of " + this.id + " (" + count + "/" + this.maxCount + ")";
        }
        return null;
    }
}

