/*
 * Decompiled with CFR 0.152.
 */
package com.fanya.gamemc.minigames.simon;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_310;
import net.minecraft.class_3417;
import net.minecraft.class_6880;

public class SimonGame {
    private final Random random = new Random();
    private final List<Integer> sequence = new ArrayList<Integer>();
    private int nextToShowIndex = 0;
    private int playerInputIndex = 0;
    private long lastTickTime = 0L;
    private long elementShowDuration = 600L;
    private long interElementDelay = 250L;
    private long lastChangeTime = 0L;
    private boolean currentlyLit = false;
    private State state = State.IDLE;
    private final int initialLength;

    public SimonGame(int initialLength) {
        this.initialLength = Math.max(1, initialLength);
        this.reset();
    }

    public void reset() {
        this.sequence.clear();
        this.state = State.IDLE;
        this.playerInputIndex = 0;
        this.nextToShowIndex = 0;
        this.currentlyLit = false;
        for (int i = 0; i < this.initialLength; ++i) {
            this.sequence.add(this.random.nextInt(5));
        }
        this.prepareShowSequence();
    }

    private void prepareShowSequence() {
        this.state = State.SHOWING;
        this.nextToShowIndex = 0;
        this.playerInputIndex = 0;
        this.currentlyLit = false;
        this.lastChangeTime = System.currentTimeMillis();
    }

    public State getState() {
        return this.state;
    }

    public List<Integer> getSequence() {
        return this.sequence;
    }

    public int getCurrentlyShowingIndex() {
        if (this.state != State.SHOWING) {
            return -1;
        }
        return this.nextToShowIndex;
    }

    public void update() {
        long now = System.currentTimeMillis();
        if (this.lastTickTime == 0L) {
            this.lastTickTime = now;
        }
        long dt = now - this.lastTickTime;
        this.lastTickTime = now;
        if (this.state == State.SHOWING) {
            if (!this.currentlyLit) {
                if (now - this.lastChangeTime >= this.interElementDelay) {
                    this.currentlyLit = true;
                    this.lastChangeTime = now;
                    this.playNoteSound(this.sequence.get(this.nextToShowIndex));
                }
            } else if (now - this.lastChangeTime >= this.elementShowDuration) {
                this.currentlyLit = false;
                this.lastChangeTime = now;
                ++this.nextToShowIndex;
                if (this.nextToShowIndex >= this.sequence.size()) {
                    this.state = State.INPUT;
                    this.playerInputIndex = 0;
                }
            }
        }
    }

    public boolean clickButton(int buttonIndex) {
        if (this.state != State.INPUT) {
            return false;
        }
        this.playNoteSound(buttonIndex);
        int expected = this.sequence.get(this.playerInputIndex);
        if (expected != buttonIndex) {
            this.state = State.LOST;
            return true;
        }
        ++this.playerInputIndex;
        if (this.playerInputIndex >= this.sequence.size()) {
            this.sequence.add(this.random.nextInt(5));
            this.prepareShowSequence();
        }
        return true;
    }

    private void playNoteSound(int index) {
        class_310 client = class_310.method_1551();
        if (client == null) {
            return;
        }
        float pitch = 0.5f + (float)index * 0.15f;
        client.method_1483().method_4873((class_1113)class_1109.method_47978((class_6880)class_3417.field_15114, (float)pitch));
    }

    public int getSequenceLength() {
        return this.sequence.size();
    }

    public static enum State {
        SHOWING,
        INPUT,
        LOST,
        WON,
        IDLE;

    }
}

