/*
 * Decompiled with CFR 0.152.
 */
package com.fanya.gamemc.minigames.simon;

import com.fanya.gamemc.data.GameRecords;
import com.fanya.gamemc.minigames.simon.GuiNoteParticle;
import com.fanya.gamemc.minigames.simon.SimonGame;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.GpuTextureView;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_10799;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5244;

public class SimonGameScreen
extends class_437 {
    private static final class_2960 NOTE_BLOCK_TEXTURE = class_2960.method_60656((String)"textures/block/note_block.png");
    private final class_437 parent;
    private SimonGame game;
    private int bestScore;
    private int centerX;
    private int centerY;
    private int blockSize;
    private int spacing;
    private final List<GuiNoteParticle> guiParticles = new ArrayList<GuiNoteParticle>();
    private int lastShownStep = -1;

    public SimonGameScreen(class_437 parent) {
        super((class_2561)class_2561.method_43471((String)"game.simon.title"));
        this.parent = parent;
    }

    protected void method_25426() {
        super.method_25426();
        this.bestScore = GameRecords.getInstance().getBestScore("simon");
        if (this.game == null) {
            this.game = new SimonGame(3);
        }
        int buttonWidth = Math.min(90, this.field_22789 / 6);
        int buttonHeight = 16;
        int y = this.field_22790 - 28;
        int spacingButton = 8;
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_5244.field_24339, button -> {
            if (this.field_22787 != null) {
                this.field_22787.method_1507(this.parent);
            }
        }).method_46434(this.field_22789 / 2 - buttonWidth - spacingButton / 2, y, buttonWidth, buttonHeight).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"game.simon.button.newgame"), button -> this.game.reset()).method_46434(this.field_22789 / 2 + spacingButton / 2, y, buttonWidth, buttonHeight).method_46431());
        this.calculateLayout();
    }

    private void calculateLayout() {
        this.blockSize = Math.max(28, Math.min(64, this.field_22789 / 8));
        this.spacing = Math.max(6, this.blockSize / 6);
        int totalWidth = this.blockSize * 5 + this.spacing * 4;
        this.centerX = (this.field_22789 - totalWidth) / 2;
        this.centerY = Math.max(80, this.field_22790 / 2 - this.blockSize / 2);
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        this.guiParticles.removeIf(p -> !p.isAlive());
        for (GuiNoteParticle p2 : this.guiParticles) {
            p2.update();
        }
        super.method_57728(context, delta);
        context.method_25296(0, 0, this.field_22789, this.field_22790, -1342177280, -1073741824);
        if (this.game != null && this.game.getState() != SimonGame.State.LOST) {
            this.game.update();
        }
        int pad = 6;
        int panelWidth = this.blockSize * 5 + this.spacing * 4 + pad * 2;
        int panelHeight = this.blockSize + pad * 2;
        int panelX = this.centerX - pad;
        int panelY = this.centerY - pad;
        context.method_25296(panelX - 2, panelY - 2, panelX + panelWidth + 2, panelY + panelHeight + 2, -15037287, -15901338);
        context.method_25294(panelX, panelY, panelX + panelWidth, panelY + panelHeight, -16115169);
        for (int i = 0; i < 5; ++i) {
            int x = this.centerX + i * (this.blockSize + this.spacing);
            int y = this.centerY;
            this.drawNoteBlock(context, x, y, this.blockSize, i);
        }
        this.drawInfo(context);
        if (this.game != null && this.game.getState() == SimonGame.State.LOST) {
            this.drawGameOver(context);
        }
        this.method_25396().forEach(child -> {
            if (child instanceof class_4185) {
                class_4185 button = (class_4185)child;
                button.method_25394(context, mouseX, mouseY, delta);
            }
        });
        GpuTextureView gpuTexture = class_310.method_1551().method_1531().method_4619(GuiNoteParticle.NOTE_TEXTURE).method_71659();
        RenderSystem.setShaderTexture((int)0, (GpuTextureView)gpuTexture);
        for (GuiNoteParticle p3 : this.guiParticles) {
            float r = (float)(p3.color >> 16 & 0xFF) / 255.0f;
            float g = (float)(p3.color >> 8 & 0xFF) / 255.0f;
            float b = (float)(p3.color & 0xFF) / 255.0f;
            float a = p3.alpha;
            RenderSystem.setShaderTexture((int)0, (GpuTextureView)gpuTexture);
            int colorInt = (int)(a * 255.0f) << 24 | (int)(r * 255.0f) << 16 | (int)(g * 255.0f) << 8 | (int)(b * 255.0f);
            context.method_25291(class_10799.field_56883, GuiNoteParticle.NOTE_TEXTURE, (int)p3.x, (int)p3.y, 0.0f, 0.0f, 16, 16, 16, 16, colorInt);
        }
    }

    private void drawNoteBlock(class_332 context, int x, int y, int size, int index) {
        GpuTextureView gpuTexture = class_310.method_1551().method_1531().method_4619(NOTE_BLOCK_TEXTURE).method_71659();
        RenderSystem.setShaderTexture((int)0, (GpuTextureView)gpuTexture);
        context.method_25290(class_10799.field_56883, NOTE_BLOCK_TEXTURE, x, y, 0.0f, 0.0f, size, size, size, size);
        if (this.game != null && this.game.getState() == SimonGame.State.SHOWING) {
            int showing = this.game.getCurrentlyShowingIndex();
            if (showing >= 0 && showing < this.game.getSequence().size()) {
                int seqIdx = this.game.getSequence().get(showing);
                if (seqIdx == index && this.lastShownStep != showing) {
                    this.lastShownStep = showing;
                    int color = switch (index) {
                        case 0 -> -65536;
                        case 1 -> -16711936;
                        case 2 -> -16776961;
                        case 3 -> -256;
                        case 4 -> -65281;
                        default -> -1;
                    };
                    this.guiParticles.add(new GuiNoteParticle((float)x + (float)this.blockSize / 2.0f, y, color));
                }
            } else {
                this.lastShownStep = -1;
            }
        }
        int mx = (int)(this.field_22787.field_1729.method_1603() * (double)this.field_22789 / (double)this.field_22787.method_22683().method_4489());
        int my = (int)(this.field_22787.field_1729.method_1604() * (double)this.field_22790 / (double)this.field_22787.method_22683().method_4506());
        if (mx >= x && mx <= x + size && my >= y && my <= y + size) {
            context.method_25294(x, y, x + size, y + size, 0x33FFFFFF);
        }
        context.method_25294(x, y + size - 4, x + size, y + size - 3, -12303292);
    }

    private boolean isCurrentlyLit() {
        return this.game != null && this.game.getState() == SimonGame.State.SHOWING && this.game.getCurrentlyShowingIndex() >= 0;
    }

    private void drawInfo(class_332 context) {
        int panelY = 20;
        int centerX = this.field_22789 / 2;
        int panelWidth = 200;
        String titleStr = this.field_22793.method_27523(class_2561.method_43471((String)"game.simon.title").getString(), panelWidth);
        context.method_51439(this.field_22793, (class_2561)class_2561.method_43470((String)titleStr), centerX - this.field_22793.method_1727(titleStr) / 2, panelY, -16711681, true);
        String seqStr = this.field_22793.method_27523(class_2561.method_43469((String)"game.simon.sequence_length", (Object[])new Object[]{this.game != null ? this.game.getSequenceLength() : 0}).getString(), panelWidth);
        context.method_51439(this.field_22793, (class_2561)class_2561.method_43470((String)seqStr), centerX - this.field_22793.method_1727(seqStr) / 2, panelY + 15, -5592406, true);
        String bestStr = this.field_22793.method_27523(class_2561.method_43469((String)"game.simon.best_score", (Object[])new Object[]{this.bestScore}).getString(), panelWidth);
        context.method_51439(this.field_22793, (class_2561)class_2561.method_43470((String)bestStr), centerX - this.field_22793.method_1727(bestStr) / 2, panelY + 30, -5592406, true);
    }

    private void drawGameOver(class_332 context) {
        int boxW = 260;
        int boxH = 120;
        int bx = (this.field_22789 - boxW) / 2;
        int by = (this.field_22790 - boxH) / 2;
        context.method_25296(bx, by, bx + boxW, by + boxH, -794165248, -799735808);
        int centerX = bx + boxW / 2;
        int y = by + 18;
        context.method_27534(this.field_22793, (class_2561)class_2561.method_43471((String)"game.simon.lose"), centerX, y, -1);
        context.method_27534(this.field_22793, (class_2561)class_2561.method_43469((String)"game.simon.length", (Object[])new Object[]{this.game != null ? this.game.getSequenceLength() - 1 : 0}), centerX, y += 22, -256);
        context.method_27534(this.field_22793, (class_2561)class_2561.method_43471((String)"game.simon.restart_hint"), centerX, y += 22, -3355444);
    }

    public boolean method_25402(class_11909 click, boolean doubled) {
        if (this.game == null) {
            return super.method_25402(click, doubled);
        }
        if (click.method_74245() != 0) {
            return super.method_25402(click, doubled);
        }
        if (this.game.getState() == SimonGame.State.SHOWING) {
            return false;
        }
        int mx = (int)click.comp_4798();
        int my = (int)click.comp_4799();
        for (int i = 0; i < 5; ++i) {
            int score;
            int x = this.centerX + i * (this.blockSize + this.spacing);
            int y = this.centerY;
            if (mx < x || mx > x + this.blockSize || my < y || my > y + this.blockSize) continue;
            boolean handled = this.game.clickButton(i);
            int color = switch (i) {
                case 0 -> -65536;
                case 1 -> -16711936;
                case 2 -> -16776961;
                case 3 -> -256;
                case 4 -> -65281;
                default -> -1;
            };
            this.guiParticles.add(new GuiNoteParticle((float)x + (float)this.blockSize / 2.0f, y, color));
            if (this.game.getState() == SimonGame.State.LOST && (score = Math.max(0, this.game.getSequenceLength() - 1)) > this.bestScore) {
                this.bestScore = score;
                GameRecords.getInstance().setBestScore("simon", this.bestScore);
            }
            return handled || super.method_25402(click, doubled);
        }
        return super.method_25402(click, doubled);
    }

    public boolean method_25404(class_11908 keyInput) {
        if (keyInput.comp_4795() == 82) {
            if (this.game != null) {
                this.game.reset();
            }
            return true;
        }
        if (keyInput.comp_4795() == 256) {
            if (this.field_22787 != null) {
                this.field_22787.method_1507(this.parent);
            }
            return true;
        }
        return super.method_25404(keyInput);
    }

    public boolean method_25421() {
        return false;
    }
}

