/*
 * Decompiled with CFR 0.152.
 */
package com.fanya.gamemc.data;

import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Properties;

public class GameRecords {
    private static final String FILE_NAME = "arcade_records.txt";
    private static final Path SAVE_PATH = Paths.get(System.getProperty("user.home"), ".fanya_gamemc", "arcade_records.txt");
    private static GameRecords instance;
    private final Properties records = new Properties();

    private GameRecords() {
        this.load();
    }

    public static GameRecords getInstance() {
        if (instance == null) {
            instance = new GameRecords();
        }
        return instance;
    }

    public int getBestScore(String gameKey) {
        String val = this.records.getProperty(gameKey, "0");
        try {
            return Integer.parseInt(val);
        }
        catch (Exception e) {
            return 0;
        }
    }

    public void setBestScore(String gameKey, int score) {
        int prev = this.getBestScore(gameKey);
        if (score > prev) {
            this.records.setProperty(gameKey, String.valueOf(score));
            this.save();
        }
    }

    private void load() {
        block8: {
            try {
                if (!Files.exists(SAVE_PATH, new LinkOption[0])) break block8;
                try (InputStream in = Files.newInputStream(SAVE_PATH, new OpenOption[0]);){
                    this.records.load(in);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void save() {
        try {
            Files.createDirectories(SAVE_PATH.getParent(), new FileAttribute[0]);
            try (OutputStream out = Files.newOutputStream(SAVE_PATH, new OpenOption[0]);){
                this.records.store(out, "Arcade Minigame Best Scores");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

