/*
 * Decompiled with CFR 0.152.
 */
package com.fanya.gamemc.minigames._2048;

import com.fanya.gamemc.data.GameRecords;
import com.fanya.gamemc.minigames._2048.Game2048;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.GpuTextureView;
import net.minecraft.class_10799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;

public class Game2048Screen
extends class_437 {
    private static final class_2960[] BLOCK_TEXTURES = Game2048Screen.buildTextures();
    private final class_437 parent;
    private Game2048 game;
    private int bestScore;
    private int playX;
    private int playY;
    private int cellSize;
    private int spacing;
    private int playWidth;
    private int playHeight;
    private int panelX;
    private int tickCounter = 0;
    private final int dropInterval = 50;

    private static class_2960[] buildTextures() {
        class_2960[] ids = new class_2960[12];
        ids[1] = class_2960.method_60656((String)"textures/block/dirt.png");
        ids[2] = class_2960.method_60656((String)"textures/block/stone.png");
        ids[3] = class_2960.method_60656((String)"textures/block/iron_ore.png");
        ids[4] = class_2960.method_60656((String)"textures/block/gold_ore.png");
        ids[5] = class_2960.method_60656((String)"textures/block/emerald_ore.png");
        ids[6] = class_2960.method_60656((String)"textures/block/diamond_ore.png");
        ids[7] = class_2960.method_60656((String)"textures/block/redstone_ore.png");
        ids[8] = class_2960.method_60656((String)"textures/block/lapis_ore.png");
        ids[9] = class_2960.method_60656((String)"textures/block/ancient_debris.png");
        ids[10] = class_2960.method_60656((String)"textures/block/end_stone.png");
        ids[11] = class_2960.method_60656((String)"textures/block/beacon.png");
        return ids;
    }

    public Game2048Screen(class_437 parent) {
        super((class_2561)class_2561.method_43470((String)"2048 Blocks"));
        this.parent = parent;
    }

    protected void method_25426() {
        this.game = new Game2048();
        this.bestScore = GameRecords.getInstance().getBestScore("2048_blocks");
        this.cellSize = 23;
        this.spacing = 3;
        this.playWidth = this.game.getCols() * (this.cellSize + this.spacing) - this.spacing;
        this.playHeight = this.game.getRows() * (this.cellSize + this.spacing) - this.spacing;
        int btnWidth = 100;
        int btnHeight = 20;
        int spacingBtn = 10;
        int totalBtnWidth = btnWidth * 3 + spacingBtn * 2;
        int startX = (this.field_22789 - totalBtnWidth) / 2;
        int btnY = 3;
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"game.snake.info.back"), b -> {
            if (this.field_22787 != null) {
                this.field_22787.method_1507(this.parent);
            }
        }).method_46434(startX, btnY, btnWidth, btnHeight).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"game.snake.info.new_game"), b -> this.game.reset()).method_46434(startX + btnWidth + spacingBtn, btnY, btnWidth, btnHeight).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"game.snake.info.pause"), b -> {
            if (this.game != null) {
                this.game.togglePause();
            }
            b.method_25355((class_2561)(this.game.getState() == Game2048.State.PAUSED ? class_2561.method_43471((String)"game.snake.info.resume") : class_2561.method_43471((String)"game.snake.info.pause")));
        }).method_46434(startX + 2 * (btnWidth + spacingBtn), btnY, btnWidth, btnHeight).method_46431());
        this.playX = startX;
        this.playY = (this.field_22790 - this.playHeight) / 2;
        this.panelX = this.playX + this.playWidth + 20;
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        if (this.game.getState() == Game2048.State.RUNNING) {
            ++this.tickCounter;
            if (this.tickCounter >= 50) {
                this.tickCounter = 0;
                this.game.dropStep();
            }
        }
        context.method_25296(this.playX - 4, this.playY - 4, this.playX + this.playWidth + 4, this.playY + this.playHeight + 4, -13421773, -15658735);
        int[][] board = this.game.getBoard();
        for (int r = 0; r < this.game.getRows(); ++r) {
            for (int c = 0; c < this.game.getCols(); ++c) {
                int x = this.playX + c * (this.cellSize + this.spacing);
                int y = this.playY + r * (this.cellSize + this.spacing);
                context.method_25294(x, y, x + this.cellSize, y + this.cellSize, -16115169);
                int lvl = board[r][c];
                if (lvl == 0) continue;
                this.drawBlock(context, x, y, lvl);
            }
        }
        if (this.game.getState() == Game2048.State.RUNNING) {
            int x = this.playX + this.game.getCurrentX() * (this.cellSize + this.spacing);
            int y = this.playY + this.game.getCurrentY() * (this.cellSize + this.spacing);
            this.drawBlock(context, x, y, this.game.getCurrentLevel());
        }
        this.drawPanel(context);
        if (this.game.getState() == Game2048.State.GAMEOVER) {
            context.method_25294(this.playX, this.playY, this.playX + this.playWidth, this.playY + this.playHeight, -1426128896);
            context.method_27534(this.field_22793, (class_2561)class_2561.method_43471((String)"game.snake.info.game_over"), this.playX + this.playWidth / 2, this.playY + this.playHeight / 2 - 10, -1);
            context.method_27534(this.field_22793, (class_2561)class_2561.method_43469((String)"game.snake.info.score", (Object[])new Object[]{this.game.getScore()}), this.playX + this.playWidth / 2, this.playY + this.playHeight / 2 + 10, -256);
        }
        if (this.game.getState() == Game2048.State.PAUSED) {
            context.method_25294(this.playX, this.playY, this.playX + this.playWidth, this.playY + this.playHeight, -1442840576);
            context.method_27534(this.field_22793, (class_2561)class_2561.method_43471((String)"game.snake.info.paused"), this.playX + this.playWidth / 2, this.playY + this.playHeight / 2, -1);
        }
        if (this.game.getState() == Game2048.State.VICTORY) {
            context.method_25294(this.playX, this.playY, this.playX + this.playWidth, this.playY + this.playHeight, -1442775296);
            context.method_27534(this.field_22793, (class_2561)class_2561.method_43471((String)"game.snake.info.victory"), this.playX + this.playWidth / 2, this.playY + this.playHeight / 2 - 10, -1);
            context.method_27534(this.field_22793, (class_2561)class_2561.method_43469((String)"game.snake.info.score", (Object[])new Object[]{this.game.getScore()}), this.playX + this.playWidth / 2, this.playY + this.playHeight / 2 + 10, -256);
        }
        super.method_25394(context, mouseX, mouseY, delta);
    }

    private void drawBlock(class_332 context, int x, int y, int lvl) {
        class_2960 tex = BLOCK_TEXTURES[Math.min(lvl, 11)];
        GpuTextureView view = class_310.method_1551().method_1531().method_4619(tex).method_71659();
        RenderSystem.setShaderTexture((int)0, (GpuTextureView)view);
        context.method_25290(class_10799.field_56883, tex, x, y, 0.0f, 0.0f, this.cellSize, this.cellSize, this.cellSize, this.cellSize);
        int val = 1 << lvl;
        String s = String.valueOf(val);
        int w = this.field_22793.method_1727(s);
        context.method_51439(this.field_22793, (class_2561)class_2561.method_43470((String)s), x + (this.cellSize - w) / 2, y + (this.cellSize - 8) / 2, -1, true);
    }

    private void drawPanel(class_332 context) {
        int panelTop = this.playY - 6;
        int panelBottom = this.playY + this.playHeight + 6;
        context.method_25294(this.panelX - 10, panelTop, this.panelX + 190, panelBottom, -2013265920);
        int y = this.playY;
        context.method_51439(this.field_22793, (class_2561)class_2561.method_43471((String)"game.snake.info.title"), this.panelX, y, -16711681, false);
        context.method_51439(this.field_22793, (class_2561)class_2561.method_43469((String)"game.snake.info.score", (Object[])new Object[]{this.game.getScore()}), this.panelX, y += 20, -1, false);
        int best = GameRecords.getInstance().getBestScore("2048_blocks");
        context.method_51439(this.field_22793, (class_2561)class_2561.method_43469((String)"game.snake.info.best", (Object[])new Object[]{best}), this.panelX, y += 16, -1, false);
        context.method_51439(this.field_22793, (class_2561)class_2561.method_43471((String)"game.snake.info.controls"), this.panelX, y += 30, -5592406, false);
        context.method_51439(this.field_22793, (class_2561)class_2561.method_43471((String)"game.snake.info.left"), this.panelX, y += 14, -3355444, false);
        context.method_51439(this.field_22793, (class_2561)class_2561.method_43471((String)"game.snake.info.right"), this.panelX, y += 12, -3355444, false);
        context.method_51439(this.field_22793, (class_2561)class_2561.method_43471((String)"game.snake.info.down"), this.panelX, y += 12, -3355444, false);
        context.method_51439(this.field_22793, (class_2561)class_2561.method_43471((String)"game.snake.info.drop"), this.panelX, y += 12, -3355444, false);
        context.method_51439(this.field_22793, (class_2561)class_2561.method_43471((String)"game.snake.info.restart"), this.panelX, y += 12, -3355444, false);
    }

    private void drawGameOver(class_332 ctx) {
        int bx = this.playX + this.playWidth / 2 - 100;
        int by = this.playY + this.playHeight / 2 - 40;
        ctx.method_25296(bx, by, bx + 200, by + 80, -794165248, -799735808);
        ctx.method_27534(this.field_22793, (class_2561)class_2561.method_43470((String)"GAME OVER"), bx + 100, by + 16, -1);
        ctx.method_27534(this.field_22793, (class_2561)class_2561.method_43470((String)("Score: " + this.game.getScore())), bx + 100, by + 36, -256);
        ctx.method_27534(this.field_22793, (class_2561)class_2561.method_43470((String)"R - Restart"), bx + 100, by + 56, -3355444);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (this.game.getState() == Game2048.State.RUNNING || this.game.getState() == Game2048.State.PAUSED) {
            switch (keyCode) {
                case 65: 
                case 263: {
                    this.game.move(-1);
                    break;
                }
                case 68: 
                case 262: {
                    this.game.move(1);
                    break;
                }
                case 83: 
                case 264: {
                    this.game.dropStep();
                    break;
                }
                case 32: {
                    this.game.hardDrop();
                    break;
                }
                case 82: {
                    this.game.reset();
                    break;
                }
                case 80: {
                    this.game.togglePause();
                    break;
                }
                case 256: {
                    if (this.field_22787 == null) break;
                    this.field_22787.method_1507(this.parent);
                }
            }
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public boolean method_25421() {
        return false;
    }
}

