/*
 * Decompiled with CFR 0.152.
 */
package com.fanya.gamemc.minigames.snake;

import com.fanya.gamemc.minigames.snake.FoodConfig;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.Consumer;
import net.minecraft.class_2350;
import net.minecraft.class_2960;

public class SnakeGame {
    private int gridWidth;
    private int gridHeight;
    private final List<Position> snake;
    private class_2350 direction;
    private class_2350 nextDirection;
    private Position food;
    private class_2960 currentFoodTexture;
    private FoodConfig currentFoodConfig;
    private boolean gameOver;
    private int score;
    private final Random random;
    private long lastMoveTime;
    private static final long MOVE_DELAY = 120L;
    private boolean gameWon = false;
    private List<FoodConfig> foodConfigs = new ArrayList<FoodConfig>();
    private Consumer<FoodConfig> onFoodEaten = null;
    private static final class_2960[] DEFAULT_FOOD_TEXTURES = new class_2960[]{class_2960.method_60656((String)"textures/item/apple.png"), class_2960.method_60656((String)"textures/item/golden_apple.png"), class_2960.method_60656((String)"textures/item/carrot.png"), class_2960.method_60656((String)"textures/item/potato.png"), class_2960.method_60656((String)"textures/item/beetroot.png"), class_2960.method_60656((String)"textures/item/melon_slice.png"), class_2960.method_60656((String)"textures/item/bread.png"), class_2960.method_60656((String)"textures/item/cookie.png"), class_2960.method_60656((String)"textures/item/pumpkin_pie.png"), class_2960.method_60656((String)"textures/item/cooked_beef.png")};

    public SnakeGame(int gridWidth, int gridHeight) {
        this.gridWidth = Math.max(5, gridWidth);
        this.gridHeight = Math.max(5, gridHeight);
        this.snake = new ArrayList<Position>();
        this.random = new Random();
        this.initDefaultFoodConfigs();
        this.reset();
    }

    private void initDefaultFoodConfigs() {
        ArrayList<FoodConfig> list = new ArrayList<FoodConfig>();
        list.add(new FoodConfig(DEFAULT_FOOD_TEXTURES[0], 10, 20));
        list.add(new FoodConfig(DEFAULT_FOOD_TEXTURES[1], 25, 5));
        list.add(new FoodConfig(DEFAULT_FOOD_TEXTURES[2], 8, 15));
        list.add(new FoodConfig(DEFAULT_FOOD_TEXTURES[3], 7, 10));
        list.add(new FoodConfig(DEFAULT_FOOD_TEXTURES[4], 6, 8));
        list.add(new FoodConfig(DEFAULT_FOOD_TEXTURES[5], 9, 10));
        list.add(new FoodConfig(DEFAULT_FOOD_TEXTURES[6], 12, 6));
        list.add(new FoodConfig(DEFAULT_FOOD_TEXTURES[7], 4, 12));
        list.add(new FoodConfig(DEFAULT_FOOD_TEXTURES[8], 18, 4));
        list.add(new FoodConfig(DEFAULT_FOOD_TEXTURES[9], 20, 5));
        this.foodConfigs = list;
    }

    public void setFoodConfigs(List<FoodConfig> configs) {
        if (configs == null || configs.isEmpty()) {
            return;
        }
        this.foodConfigs = new ArrayList<FoodConfig>(configs);
    }

    public List<FoodConfig> getFoodConfigs() {
        return new ArrayList<FoodConfig>(this.foodConfigs);
    }

    public void setOnFoodEaten(Consumer<FoodConfig> callback) {
        this.onFoodEaten = callback;
    }

    public boolean isGameWon() {
        return this.gameWon;
    }

    public void reset() {
        this.snake.clear();
        int startX = this.gridWidth / 2;
        int startY = this.gridHeight / 2;
        this.snake.add(new Position(startX, startY));
        this.snake.add(new Position(startX - 1, startY));
        this.snake.add(new Position(startX - 2, startY));
        this.direction = class_2350.field_11034;
        this.nextDirection = class_2350.field_11034;
        this.gameOver = false;
        this.score = 0;
        this.lastMoveTime = System.currentTimeMillis();
        this.spawnFood();
    }

    public void update() {
        if (this.gameOver) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastMoveTime < 120L) {
            return;
        }
        this.lastMoveTime = currentTime;
        this.direction = this.nextDirection;
        Position head = this.snake.get(0);
        Position newHead = new Position(head.x, head.y);
        switch (this.direction) {
            case field_11043: {
                --newHead.y;
                break;
            }
            case field_11035: {
                ++newHead.y;
                break;
            }
            case field_11039: {
                --newHead.x;
                break;
            }
            case field_11034: {
                ++newHead.x;
            }
        }
        if (newHead.x < 0) {
            newHead.x = this.gridWidth - 1;
        }
        if (newHead.x >= this.gridWidth) {
            newHead.x = 0;
        }
        if (newHead.y < 0) {
            newHead.y = this.gridHeight - 1;
        }
        if (newHead.y >= this.gridHeight) {
            newHead.y = 0;
        }
        for (Position segment : this.snake) {
            if (segment.equals(newHead)) {
                this.gameOver = true;
                return;
            }
            if (this.snake.size() != this.gridWidth * this.gridHeight) continue;
            this.gameWon = true;
            this.gameOver = true;
        }
        this.snake.add(0, newHead);
        if (newHead.equals(this.food)) {
            this.score = this.currentFoodConfig != null ? (this.score += this.currentFoodConfig.getPoints()) : (this.score += 10);
            if (this.onFoodEaten != null) {
                try {
                    this.onFoodEaten.accept(this.currentFoodConfig);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.spawnFood();
        } else {
            this.snake.remove(this.snake.size() - 1);
        }
    }

    public void setDirection(class_2350 newDirection) {
        if (newDirection == class_2350.field_11043 && this.direction != class_2350.field_11035) {
            this.nextDirection = newDirection;
        } else if (newDirection == class_2350.field_11035 && this.direction != class_2350.field_11043) {
            this.nextDirection = newDirection;
        } else if (newDirection == class_2350.field_11039 && this.direction != class_2350.field_11034) {
            this.nextDirection = newDirection;
        } else if (newDirection == class_2350.field_11034 && this.direction != class_2350.field_11039) {
            this.nextDirection = newDirection;
        }
    }

    private void spawnFood() {
        FoodConfig fc;
        do {
            this.food = new Position(this.random.nextInt(this.gridWidth), this.random.nextInt(this.gridHeight));
        } while (this.snake.contains(this.food));
        if (this.foodConfigs == null || this.foodConfigs.isEmpty()) {
            this.currentFoodTexture = DEFAULT_FOOD_TEXTURES[this.random.nextInt(DEFAULT_FOOD_TEXTURES.length)];
            this.currentFoodConfig = null;
            return;
        }
        int totalWeight = 0;
        for (FoodConfig fc2 : this.foodConfigs) {
            totalWeight += fc2.getWeight();
        }
        if (totalWeight <= 0) {
            FoodConfig fc3;
            this.currentFoodConfig = fc3 = this.foodConfigs.get(this.random.nextInt(this.foodConfigs.size()));
            this.currentFoodTexture = fc3.getTexture();
            return;
        }
        int pick = this.random.nextInt(totalWeight);
        int acc = 0;
        for (FoodConfig fc4 : this.foodConfigs) {
            if (pick >= (acc += fc4.getWeight())) continue;
            this.currentFoodConfig = fc4;
            this.currentFoodTexture = fc4.getTexture();
            return;
        }
        this.currentFoodConfig = fc = this.foodConfigs.get(this.random.nextInt(this.foodConfigs.size()));
        this.currentFoodTexture = fc.getTexture();
    }

    public List<Position> getSnake() {
        return this.snake;
    }

    public Position getFood() {
        return this.food;
    }

    public class_2960 getCurrentFoodTexture() {
        return this.currentFoodTexture;
    }

    public boolean isGameOver() {
        return this.gameOver;
    }

    public int getScore() {
        return this.score;
    }

    public int getGridWidth() {
        return this.gridWidth;
    }

    public int getGridHeight() {
        return this.gridHeight;
    }

    public void setGridSize(int w, int h) {
        this.gridWidth = Math.max(5, w);
        this.gridHeight = Math.max(5, h);
    }

    public static class Position {
        public int x;
        public int y;

        public Position(int x, int y) {
            this.x = x;
            this.y = y;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Position)) {
                return false;
            }
            Position other = (Position)obj;
            return this.x == other.x && this.y == other.y;
        }

        public int hashCode() {
            return this.x * 1000 + this.y;
        }
    }
}

