/*
 * Decompiled with CFR 0.152.
 */
package com.fanya.gamemc.minigames.snake;

import com.fanya.gamemc.data.GameRecords;
import com.fanya.gamemc.minigames.snake.SnakeGame;
import com.fanya.gamemc.minigames.snake.SnakeSizeSelectScreen;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.GpuTextureView;
import java.util.Objects;
import net.minecraft.class_10799;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_2350;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3417;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_6880;

public class SnakeGameScreen
extends class_437 {
    private int bestScore;
    private final class_437 parent;
    private SnakeGame game;
    private int gridWidth;
    private int gridHeight;
    private static final int MIN_CELL_SIZE = 8;
    private static final int MAX_CELL_SIZE = 28;
    public static int selectedGridWidth = 25;
    public static int selectedGridHeight = 18;
    private static final class_2960 SLIME = class_2960.method_60656((String)"textures/block/slime_block.png");
    private static final class_2960 EMERALD = class_2960.method_60656((String)"textures/block/emerald_block.png");
    private int cellSize;
    private int gridOffsetX;
    private int gridOffsetY;

    public SnakeGameScreen(class_437 parent, int gridWidth, int gridHeight) {
        super((class_2561)class_2561.method_43471((String)"game.snake.title"));
        this.parent = parent;
        this.gridWidth = gridWidth;
        this.gridHeight = gridHeight;
    }

    protected void method_25426() {
        super.method_25426();
        this.bestScore = GameRecords.getInstance().getBestScore("snake");
        this.calculateGridSize();
        this.game = new SnakeGame(this.gridWidth, this.gridHeight);
        this.game.setOnFoodEaten(callback -> class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_47978((class_6880)class_3417.field_20614, (float)1.0f)));
        int buttonY = Math.max(this.field_22790 - 30, this.gridOffsetY + this.gridHeight * this.cellSize + 10);
        int buttonWidth = Math.min(90, this.field_22789 / 6);
        int buttonHeight = 16;
        int spacing = 8;
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_5244.field_24339, button -> this.field_22787.method_1507(this.parent)).method_46434(this.field_22789 / 2 - buttonWidth * 2 - spacing * 2, buttonY, buttonWidth, buttonHeight).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"game.snake.button.newgame"), button -> this.game.reset()).method_46434(this.field_22789 / 2 - buttonWidth / 2, buttonY, buttonWidth, buttonHeight).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"game.snake.button.select_size"), button -> this.field_22787.method_1507((class_437)new SnakeSizeSelectScreen(this.parent))).method_46434(this.field_22789 / 2 + buttonWidth + spacing * 2, buttonY, buttonWidth + 10, buttonHeight).method_46431());
    }

    private void recalcGridLayout() {
        this.calculateGridSize();
    }

    private void calculateGridSize() {
        int maxGridBottom;
        int gridW = this.getDisplayGridWidth();
        int gridH = this.getDisplayGridHeight();
        int reservedWidth = 160;
        int reservedHeight = 200;
        int availableWidth = Math.max(this.field_22789 - reservedWidth, 200);
        int availableHeight = Math.max(this.field_22790 - reservedHeight, 150);
        int cellWidthBased = availableWidth / gridW;
        int cellHeightBased = availableHeight / gridH;
        this.cellSize = Math.min(cellWidthBased, cellHeightBased);
        this.cellSize = Math.max(8, Math.min(28, this.cellSize));
        int totalGridWidth = gridW * this.cellSize;
        int totalGridHeight = gridH * this.cellSize;
        this.gridOffsetX = (this.field_22789 - totalGridWidth) / 2;
        this.gridOffsetY = (this.field_22790 - totalGridHeight) / 2;
        if (this.gridOffsetX < 15) {
            this.gridOffsetX = 15;
        }
        if (this.gridOffsetY < 40) {
            this.gridOffsetY = 40;
        }
        if (this.gridOffsetY + totalGridHeight > (maxGridBottom = this.field_22790 - 35)) {
            this.gridOffsetY = Math.max(40, maxGridBottom - totalGridHeight);
        }
    }

    private int getDisplayGridWidth() {
        return this.game != null ? this.game.getGridWidth() : selectedGridWidth;
    }

    private int getDisplayGridHeight() {
        return this.game != null ? this.game.getGridHeight() : selectedGridHeight;
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        super.method_57728(context, delta);
        context.method_25296(0, 0, this.field_22789, this.field_22790, -1342177280, -1073741824);
        int borderSize = Math.max(2, this.cellSize / 8);
        context.method_25296(this.gridOffsetX - borderSize, this.gridOffsetY - borderSize, this.gridOffsetX + this.getDisplayGridWidth() * this.cellSize + borderSize, this.gridOffsetY + this.getDisplayGridHeight() * this.cellSize + borderSize, -15037287, -15901338);
        context.method_25294(this.gridOffsetX, this.gridOffsetY, this.gridOffsetX + this.getDisplayGridWidth() * this.cellSize, this.gridOffsetY + this.getDisplayGridHeight() * this.cellSize, -16115169);
        this.drawGrid(context);
        if (this.game != null && !this.game.isGameOver()) {
            this.game.update();
        }
        this.drawGame(context);
        this.drawInfoPanel(context);
        if (this.game != null && this.game.isGameOver()) {
            if (this.game.getScore() > this.bestScore) {
                this.bestScore = this.game.getScore();
                GameRecords.getInstance().setBestScore("snake", this.bestScore);
            }
            this.drawGameOverScreen(context);
        }
        if (this.game != null && this.game.isGameWon()) {
            this.drawGameWonScreen(context);
        }
        this.method_25396().forEach(child -> {
            if (child instanceof class_4185) {
                class_4185 button = (class_4185)child;
                button.method_25394(context, mouseX, mouseY, delta);
            }
        });
    }

    private void drawGrid(class_332 context) {
        int gridColor = 0x20FFFFFF;
        int gridW = this.getDisplayGridWidth();
        int gridH = this.getDisplayGridHeight();
        for (int x = 0; x <= gridW; ++x) {
            context.method_25294(this.gridOffsetX + x * this.cellSize, this.gridOffsetY, this.gridOffsetX + x * this.cellSize + 1, this.gridOffsetY + gridH * this.cellSize, gridColor);
        }
        for (int y = 0; y <= gridH; ++y) {
            context.method_25294(this.gridOffsetX, this.gridOffsetY + y * this.cellSize, this.gridOffsetX + gridW * this.cellSize, this.gridOffsetY + y * this.cellSize + 1, gridColor);
        }
    }

    private void drawGame(class_332 context) {
        if (this.game == null) {
            return;
        }
        int padding = Math.max(1, this.cellSize / 10);
        SnakeGame.Position food = this.game.getFood();
        class_2960 foodTexture = this.game.getCurrentFoodTexture();
        if (food != null && foodTexture != null) {
            try {
                GpuTextureView foodGpuTexture = class_310.method_1551().method_1531().method_4619(foodTexture).method_71659();
                int foodSize = Math.max(1, this.cellSize - padding * 2);
                if (foodSize > 2) {
                    RenderSystem.setShaderTexture((int)0, (GpuTextureView)foodGpuTexture);
                    context.method_25290(class_10799.field_56883, foodTexture, this.gridOffsetX + food.x * this.cellSize + padding, this.gridOffsetY + food.y * this.cellSize + padding, 0.0f, 0.0f, foodSize, foodSize, foodSize, foodSize);
                }
            }
            catch (Exception foodGpuTexture) {
                // empty catch block
            }
        }
        for (int i = 0; i < this.game.getSnake().size(); ++i) {
            SnakeGame.Position segment = this.game.getSnake().get(i);
            class_2960 texture = i == 0 ? EMERALD : SLIME;
            GpuTextureView snakeGpuTexture = class_310.method_1551().method_1531().method_4619(texture).method_71659();
            int segmentPadding = Math.max(1, this.cellSize / 12);
            int segmentSize = Math.max(1, this.cellSize - segmentPadding * 2);
            if (segmentSize <= 2) continue;
            RenderSystem.setShaderTexture((int)0, (GpuTextureView)snakeGpuTexture);
            context.method_25290(class_10799.field_56883, texture, this.gridOffsetX + segment.x * this.cellSize + segmentPadding, this.gridOffsetY + segment.y * this.cellSize + segmentPadding, 0.0f, 0.0f, segmentSize, segmentSize, segmentSize, segmentSize);
        }
    }

    private void drawInfoPanel(class_332 context) {
        int panelHeight = Math.max(24, Math.min(32, this.cellSize + 8));
        int panelY = Math.max(5, this.gridOffsetY - panelHeight - 4);
        int panelWidth = this.getDisplayGridWidth() * this.cellSize;
        context.method_25296(this.gridOffsetX - 3, panelY, this.gridOffsetX + panelWidth + 3, panelY + panelHeight, -804253680, -534765536);
        context.method_25294(this.gridOffsetX - 3, panelY, this.gridOffsetX + panelWidth + 3, panelY + 2, -15037287);
        Objects.requireNonNull(this.field_22793);
        int textSize = 9;
        int textY1 = panelY + 4;
        int textY2 = panelY + panelHeight - textSize - 2;
        String scoreText = class_2561.method_43469((String)"game.snake.score", (Object[])new Object[]{this.game != null ? this.game.getScore() : 0}).getString();
        context.method_25303(this.field_22793, scoreText, this.gridOffsetX + 5, textY1, -10496);
        String lengthText = class_2561.method_43469((String)"game.snake.length", (Object[])new Object[]{this.game != null ? this.game.getSnake().size() : 0}).getString();
        context.method_25303(this.field_22793, lengthText, this.gridOffsetX + 5, textY2, -16711936);
        String bestText = class_2561.method_43469((String)"game.snake.best_score", (Object[])new Object[]{this.bestScore}).getString();
        float scale = Math.max(1.0f, (float)this.cellSize / 18.0f);
        int textWidth = (int)((float)this.field_22793.method_1727(bestText) * scale);
        Objects.requireNonNull(this.field_22793);
        int textHeight = (int)(9.0f * scale);
        float x = (float)this.gridOffsetX + (float)panelWidth / 2.0f - (float)textWidth / 2.0f;
        float y = (float)panelY + (float)panelHeight / 2.0f - (float)textHeight / 2.0f;
        context.method_51439(this.field_22793, (class_2561)class_2561.method_43470((String)bestText), (int)x, (int)y, -7876885, true);
        String controls = "WASD | R";
        int controlsWidth = this.field_22793.method_1727(controls);
        if (controlsWidth < panelWidth - 60) {
            context.method_25303(this.field_22793, controls, this.gridOffsetX + panelWidth - controlsWidth, panelY + panelHeight / 2 - textSize / 2, -5592406);
        }
    }

    private void drawGameOverScreen(class_332 context) {
        context.method_25296(this.gridOffsetX, this.gridOffsetY, this.gridOffsetX + this.getDisplayGridWidth() * this.cellSize, this.gridOffsetY + this.getDisplayGridHeight() * this.cellSize, -794165248, -799735808);
        int centerX = this.gridOffsetX + this.getDisplayGridWidth() * this.cellSize / 2;
        int centerY = this.gridOffsetY + this.getDisplayGridHeight() * this.cellSize / 2;
        Objects.requireNonNull(this.field_22793);
        int lineHeight = 9 + 4;
        class_5250 gameOverText = class_2561.method_43471((String)"game.snake.lose");
        context.method_27534(this.field_22793, (class_2561)gameOverText, centerX, centerY - lineHeight * 2, -1);
        class_5250 scoreText = class_2561.method_43469((String)"game.snake.score", (Object[])new Object[]{this.game != null ? this.game.getScore() : 0});
        context.method_27534(this.field_22793, (class_2561)scoreText, centerX, centerY - lineHeight / 2, -256);
        class_5250 lengthText = class_2561.method_43469((String)"game.snake.length", (Object[])new Object[]{this.game != null ? this.game.getSnake().size() : 0});
        context.method_27534(this.field_22793, (class_2561)lengthText, centerX, centerY + lineHeight / 2, -16711936);
        class_5250 bestScoreText = class_2561.method_43469((String)"game.snake.best_score", (Object[])new Object[]{this.bestScore});
        context.method_27534(this.field_22793, (class_2561)bestScoreText, centerX, centerY + lineHeight * 3, -7876885);
        class_5250 restartText = class_2561.method_43471((String)"game.snake.restart_hint");
        context.method_27534(this.field_22793, (class_2561)restartText, centerX, centerY + lineHeight * 2, -3355444);
    }

    private void drawGameWonScreen(class_332 context) {
        context.method_25296(this.gridOffsetX, this.gridOffsetY, this.gridOffsetX + this.getDisplayGridWidth() * this.cellSize, this.gridOffsetY + this.getDisplayGridHeight() * this.cellSize, -805262848, -799670528);
        int centerX = this.gridOffsetX + this.getDisplayGridWidth() * this.cellSize / 2;
        int centerY = this.gridOffsetY + this.getDisplayGridHeight() * this.cellSize / 2;
        class_5250 wonText = class_2561.method_43471((String)"game.snake.won");
        context.method_27534(this.field_22793, (class_2561)wonText, centerX, centerY, -1);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (this.game == null) {
            return super.method_25404(keyCode, scanCode, modifiers);
        }
        switch (keyCode) {
            case 87: 
            case 265: {
                this.game.setDirection(class_2350.field_11043);
                return true;
            }
            case 83: 
            case 264: {
                this.game.setDirection(class_2350.field_11035);
                return true;
            }
            case 65: 
            case 263: {
                this.game.setDirection(class_2350.field_11039);
                return true;
            }
            case 68: 
            case 262: {
                this.game.setDirection(class_2350.field_11034);
                return true;
            }
            case 82: {
                if (this.game != null) {
                    this.game.reset();
                }
                return true;
            }
            case 256: {
                if (this.field_22787 != null) {
                    this.field_22787.method_1507(this.parent);
                }
                return true;
            }
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public void method_25410(class_310 client, int width, int height) {
        super.method_25410(client, width, height);
        this.recalcGridLayout();
    }

    public boolean method_25421() {
        return false;
    }
}

