/*
 * Decompiled with CFR 0.152.
 */
package com.fanya.gamemc.minigames.snake;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.class_2350;
import net.minecraft.class_2960;

public class SnakeGame {
    private final int gridWidth;
    private final int gridHeight;
    private final List<Position> snake;
    private class_2350 direction;
    private class_2350 nextDirection;
    private Position food;
    private class_2960 currentFoodTexture;
    private boolean gameOver;
    private int score;
    private final Random random;
    private long lastMoveTime;
    private static final long MOVE_DELAY = 120L;
    private static final class_2960[] FOOD_TEXTURES = new class_2960[]{class_2960.method_60656((String)"textures/item/apple.png"), class_2960.method_60656((String)"textures/item/golden_apple.png"), class_2960.method_60656((String)"textures/item/carrot.png"), class_2960.method_60656((String)"textures/item/potato.png"), class_2960.method_60656((String)"textures/item/beetroot.png"), class_2960.method_60656((String)"textures/item/melon_slice.png"), class_2960.method_60656((String)"textures/item/bread.png"), class_2960.method_60656((String)"textures/item/cookie.png"), class_2960.method_60656((String)"textures/item/pumpkin_pie.png"), class_2960.method_60656((String)"textures/item/cooked_beef.png")};

    public SnakeGame(int gridWidth, int gridHeight) {
        this.gridWidth = gridWidth;
        this.gridHeight = gridHeight;
        this.snake = new ArrayList<Position>();
        this.random = new Random();
        this.reset();
    }

    public void reset() {
        this.snake.clear();
        int startX = this.gridWidth / 2;
        int startY = this.gridHeight / 2;
        this.snake.add(new Position(startX, startY));
        this.snake.add(new Position(startX - 1, startY));
        this.snake.add(new Position(startX - 2, startY));
        this.direction = class_2350.field_11034;
        this.nextDirection = class_2350.field_11034;
        this.gameOver = false;
        this.score = 0;
        this.lastMoveTime = System.currentTimeMillis();
        this.spawnFood();
    }

    public void update() {
        if (this.gameOver) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastMoveTime < 120L) {
            return;
        }
        this.lastMoveTime = currentTime;
        this.direction = this.nextDirection;
        Position head = this.snake.get(0);
        Position newHead = new Position(head.x, head.y);
        switch (this.direction) {
            case field_11043: {
                --newHead.y;
                break;
            }
            case field_11035: {
                ++newHead.y;
                break;
            }
            case field_11039: {
                --newHead.x;
                break;
            }
            case field_11034: {
                ++newHead.x;
            }
        }
        if (newHead.x < 0 || newHead.x >= this.gridWidth || newHead.y < 0 || newHead.y >= this.gridHeight) {
            this.gameOver = true;
            return;
        }
        for (Position segment : this.snake) {
            if (!segment.equals(newHead)) continue;
            this.gameOver = true;
            return;
        }
        this.snake.add(0, newHead);
        if (newHead.equals(this.food)) {
            this.score += 10;
            this.spawnFood();
        } else {
            this.snake.remove(this.snake.size() - 1);
        }
    }

    public void setDirection(class_2350 newDirection) {
        if (newDirection == class_2350.field_11043 && this.direction != class_2350.field_11035) {
            this.nextDirection = newDirection;
        } else if (newDirection == class_2350.field_11035 && this.direction != class_2350.field_11043) {
            this.nextDirection = newDirection;
        } else if (newDirection == class_2350.field_11039 && this.direction != class_2350.field_11034) {
            this.nextDirection = newDirection;
        } else if (newDirection == class_2350.field_11034 && this.direction != class_2350.field_11039) {
            this.nextDirection = newDirection;
        }
    }

    private void spawnFood() {
        do {
            this.food = new Position(this.random.nextInt(this.gridWidth), this.random.nextInt(this.gridHeight));
        } while (this.snake.contains(this.food));
        this.currentFoodTexture = FOOD_TEXTURES[this.random.nextInt(FOOD_TEXTURES.length)];
    }

    public List<Position> getSnake() {
        return this.snake;
    }

    public Position getFood() {
        return this.food;
    }

    public class_2960 getCurrentFoodTexture() {
        return this.currentFoodTexture;
    }

    public boolean isGameOver() {
        return this.gameOver;
    }

    public int getScore() {
        return this.score;
    }

    public int getGridWidth() {
        return this.gridWidth;
    }

    public int getGridHeight() {
        return this.gridHeight;
    }

    public static class Position {
        public int x;
        public int y;

        public Position(int x, int y) {
            this.x = x;
            this.y = y;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Position)) {
                return false;
            }
            Position other = (Position)obj;
            return this.x == other.x && this.y == other.y;
        }

        public int hashCode() {
            return this.x * 1000 + this.y;
        }
    }
}

