/*
 * Decompiled with CFR 0.152.
 */
package com.fanya.gamemc.minigames._2048;

import com.fanya.gamemc.data.GameRecords;
import java.util.Arrays;
import java.util.Random;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3417;

public class Game2048 {
    private static final int COLS = 6;
    private static final int ROWS = 7;
    private final int[][] board = new int[7][6];
    private int currentLevel;
    private int currentX;
    private int currentY;
    private int score = 0;
    private State state = State.RUNNING;
    private final Random random = new Random();
    private final String recordKey = "2048_blocks";

    private void playSound(class_3414 sound, float pitch, float volume) {
        class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4757((class_3414)sound, (float)pitch, (float)volume));
    }

    private void playSpawnSound() {
        this.playSound(class_3417.field_14719, 1.2f, 0.7f);
    }

    private void playLandSound() {
        this.playSound(class_3417.field_14574, 1.0f, 0.6f);
    }

    private void playMergeSound() {
        this.playSound(class_3417.field_26980, 1.0f + this.random.nextFloat() * 0.3f, 0.8f);
    }

    private void playComboSound() {
        this.playSound(class_3417.field_49045, 1.0f, 0.9f);
    }

    private void playGameOverSound() {
        this.playSound(class_3417.field_14833, 0.8f, 1.0f);
    }

    private void playVictorySound() {
        this.playSound(class_3417.field_15195, 1.0f, 1.0f);
    }

    public Game2048() {
        this.reset();
    }

    public void reset() {
        for (int r = 0; r < 7; ++r) {
            Arrays.fill(this.board[r], 0);
        }
        this.score = 0;
        this.state = State.RUNNING;
        this.spawnBlock();
    }

    public int[][] getBoard() {
        return this.board;
    }

    public int getCols() {
        return 6;
    }

    public int getRows() {
        return 7;
    }

    public int getScore() {
        return this.score;
    }

    public State getState() {
        return this.state;
    }

    public int getCurrentLevel() {
        return this.currentLevel;
    }

    public int getCurrentX() {
        return this.currentX;
    }

    public int getCurrentY() {
        return this.currentY;
    }

    private void spawnBlock() {
        this.currentLevel = this.getRandomBlockLevel();
        switch (this.currentLevel) {
            case 1: {
                this.currentX = 0;
                break;
            }
            case 2: {
                this.currentX = 2;
                break;
            }
            case 3: {
                this.currentX = 4;
                break;
            }
            case 4: {
                this.currentX = 5;
                break;
            }
            default: {
                this.currentX = 3;
            }
        }
        this.currentY = 0;
        if (this.board[this.currentY][this.currentX] != 0) {
            this.endGame();
            return;
        }
        this.playSpawnSound();
    }

    private int getRandomBlockLevel() {
        double r = this.random.nextDouble();
        if (r < 0.6) {
            return 1;
        }
        if (r < 0.85) {
            return 2;
        }
        if (r < 0.95) {
            return 3;
        }
        return 4;
    }

    public void togglePause() {
        if (this.state == State.RUNNING) {
            this.state = State.PAUSED;
        } else if (this.state == State.PAUSED) {
            this.state = State.RUNNING;
        }
    }

    private void endGame() {
        this.state = State.GAMEOVER;
        GameRecords.getInstance().setBestScore("2048_blocks", this.score);
        this.playGameOverSound();
    }

    private void winGame() {
        this.state = State.VICTORY;
        GameRecords.getInstance().setBestScore("2048_blocks", this.score);
        this.playVictorySound();
    }

    public boolean dropStep() {
        if (this.state != State.RUNNING) {
            return false;
        }
        int ny = this.currentY + 1;
        if (ny >= 7 || this.board[ny][this.currentX] != 0) {
            this.placeBlock();
            return false;
        }
        this.currentY = ny;
        return true;
    }

    public void hardDrop() {
        while (this.dropStep()) {
        }
    }

    public void move(int dx) {
        if (this.state != State.RUNNING) {
            return;
        }
        int nx = this.currentX + dx;
        if (nx < 0 || nx >= 6) {
            return;
        }
        if (this.board[this.currentY][nx] == 0) {
            this.currentX = nx;
        }
    }

    private void placeBlock() {
        this.playLandSound();
        int y = this.currentY;
        int x = this.currentX;
        int lvl = this.currentLevel;
        if (y + 1 < 7 && this.board[y + 1][x] == lvl) {
            this.board[y + 1][x] = Math.min(11, lvl + 1);
            this.score += 1 << this.board[y + 1][x];
            this.applyGravity();
        } else {
            this.board[y][x] = lvl;
            this.applyGravity();
        }
        for (int r = 0; r < 7; ++r) {
            for (int c = 0; c < 6; ++c) {
                if (this.board[r][c] != 11) continue;
                this.winGame();
                return;
            }
        }
        this.checkTopLine();
        if (this.state == State.RUNNING) {
            this.spawnBlock();
        }
    }

    private void checkTopLine() {
        for (int c = 0; c < 6; ++c) {
            if (this.board[0][c] == 0) continue;
            this.endGame();
            break;
        }
    }

    private void applyGravity() {
        boolean merged;
        int comboCount = 0;
        do {
            int r;
            int c;
            merged = false;
            for (c = 0; c < 6; ++c) {
                for (r = 5; r >= 0; --r) {
                    if (this.board[r][c] == 0 || this.board[r + 1][c] != 0) continue;
                    this.board[r + 1][c] = this.board[r][c];
                    this.board[r][c] = 0;
                    merged = true;
                }
            }
            for (c = 0; c < 6; ++c) {
                for (r = 5; r >= 0; --r) {
                    if (this.board[r][c] == 0 || this.board[r][c] != this.board[r + 1][c]) continue;
                    this.board[r + 1][c] = Math.min(11, this.board[r][c] + 1);
                    this.board[r][c] = 0;
                    this.score += 1 << this.board[r + 1][c];
                    this.playMergeSound();
                    merged = true;
                    ++comboCount;
                }
            }
            for (int r2 = 6; r2 >= 0; --r2) {
                for (int c2 = 0; c2 < 5; ++c2) {
                    if (this.board[r2][c2] == 0 || this.board[r2][c2] != this.board[r2][c2 + 1]) continue;
                    this.board[r2][c2] = Math.min(11, this.board[r2][c2] + 1);
                    this.board[r2][c2 + 1] = 0;
                    this.score += 1 << this.board[r2][c2];
                    this.playMergeSound();
                    merged = true;
                    ++comboCount;
                }
            }
        } while (merged);
        if (comboCount >= 3) {
            this.playComboSound();
        }
    }

    public static enum State {
        RUNNING,
        GAMEOVER,
        PAUSED,
        VICTORY;

    }
}

