/*
 * Decompiled with CFR 0.152.
 */
package com.fanya.gamemc.minigames.simon;

import com.fanya.gamemc.data.GameRecords;
import com.fanya.gamemc.minigames.simon.SimonGame;
import net.minecraft.class_10799;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;

public class SimonGameScreen
extends class_437 {
    private static final class_2960 COPPER_LAMP_TEXTURE = class_2960.method_60656((String)"textures/block/copper_bulb.png");
    private static final class_2960 COPPER_LAMP_LIT_TEXTURE = class_2960.method_60656((String)"textures/block/copper_bulb_lit.png");
    private final class_437 parent;
    private SimonGame game;
    private int bestScore;
    private int centerX;
    private int centerY;
    private int blockSize;
    private int spacing;
    private int lastShownStep = -1;
    private final long[] lampFlashTimes = new long[4];
    private static final long FLASH_DURATION = 400L;
    private long lastFlashTriggerTime = 0L;

    public SimonGameScreen(class_437 parent) {
        super((class_2561)class_2561.method_43471((String)"game.simon.title"));
        this.parent = parent;
    }

    protected void method_25426() {
        this.bestScore = GameRecords.getInstance().getBestScore("simon");
        if (this.game == null) {
            this.game = new SimonGame(3);
        }
        int buttonWidth = Math.min(90, this.field_22789 / 6);
        int buttonHeight = 16;
        int y = this.field_22790 - 28;
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.back"), b -> this.field_22787.method_1507(this.parent)).method_46434(this.field_22789 / 2 - buttonWidth - 4, y, buttonWidth, buttonHeight).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"game.simon.button.newgame"), b -> this.game.reset()).method_46434(this.field_22789 / 2 + 4, y, buttonWidth, buttonHeight).method_46431());
        this.calculateLayout();
    }

    private void calculateLayout() {
        this.blockSize = Math.max(28, Math.min(64, this.field_22789 / 8));
        this.spacing = Math.max(6, this.blockSize / 6);
        int totalWidth = this.blockSize * 4 + this.spacing * 3;
        this.centerX = (this.field_22789 - totalWidth) / 2;
        this.centerY = Math.max(80, this.field_22790 / 2 - this.blockSize / 2);
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        super.method_57728(context, delta);
        context.method_25296(0, 0, this.field_22789, this.field_22790, -1342177280, -1073741824);
        if (this.game != null) {
            this.game.update();
        }
        int pad = 6;
        int panelWidth = this.blockSize * 4 + this.spacing * 3 + pad * 2;
        int panelHeight = this.blockSize + pad * 2;
        int panelX = this.centerX - pad;
        int panelY = this.centerY - pad;
        context.method_25296(panelX - 2, panelY - 2, panelX + panelWidth + 2, panelY + panelHeight + 2, -15037287, -15901338);
        context.method_25294(panelX, panelY, panelX + panelWidth, panelY + panelHeight, -16115169);
        if (this.game.getState() == SimonGame.State.SHOWING) {
            int activeLamp = this.game.getCurrentlyShowingIndex();
            if (activeLamp >= 0 && activeLamp < 4) {
                long now = System.currentTimeMillis();
                if (this.lastShownStep != activeLamp || now - this.lastFlashTriggerTime > this.game.getShowDuration() + this.game.getBetweenDelay() / 2L) {
                    this.lastShownStep = activeLamp;
                    this.lastFlashTriggerTime = now;
                    this.lampFlashTimes[activeLamp] = now;
                }
            }
        } else {
            this.lastShownStep = -1;
        }
        for (int i = 0; i < 4; ++i) {
            int x = this.centerX + i * (this.blockSize + this.spacing);
            this.drawLamp(context, x, this.centerY, this.blockSize, i);
        }
        this.drawInfo(context);
        if (this.game.getState() == SimonGame.State.LOST) {
            this.drawGameOver(context);
        }
        this.method_25396().forEach(child -> {
            if (child instanceof class_4185) {
                class_4185 b = (class_4185)child;
                b.method_25394(context, mouseX, mouseY, delta);
            }
        });
    }

    private void drawLamp(class_332 context, int x, int y, int size, int index) {
        boolean lit = false;
        if (this.game.getState() == SimonGame.State.SHOWING) {
            lit = this.game.getCurrentlyShowingIndex() == index;
        }
        class_2960 tex = lit ? COPPER_LAMP_LIT_TEXTURE : COPPER_LAMP_TEXTURE;
        context.method_25290(class_10799.field_56883, tex, x, y, 0.0f, 0.0f, size, size, size, size);
        long elapsed = System.currentTimeMillis() - this.lampFlashTimes[index];
        if (elapsed < 400L) {
            float progress = (float)elapsed / 400.0f;
            float alpha = 1.0f - progress;
            float scale = 1.0f + progress * 0.5f;
            int border = (int)(6.0f * scale);
            int baseColor = switch (index) {
                case 0 -> -48060;
                case 1 -> -12255420;
                case 2 -> -12285697;
                case 3 -> -188;
                default -> -1;
            };
            int color = (int)(alpha * 255.0f) << 24 | baseColor & 0xFFFFFF;
            context.method_25294(x - border, y - border, x + size + border, y, color);
            context.method_25294(x - border, y + size, x + size + border, y + size + border, color);
            context.method_25294(x - border, y, x, y + size, color);
            context.method_25294(x + size, y, x + size + border, y + size, color);
        }
        int mx = (int)(this.field_22787.field_1729.method_1603() * (double)this.field_22789 / (double)this.field_22787.method_22683().method_4489());
        int my = (int)(this.field_22787.field_1729.method_1604() * (double)this.field_22790 / (double)this.field_22787.method_22683().method_4506());
        if (mx >= x && mx <= x + size && my >= y && my <= y + size) {
            context.method_25294(x, y, x + size, y + size, 0x33FFFFFF);
        }
        context.method_25294(x, y + size - 4, x + size, y + size - 3, -12303292);
    }

    private void drawInfo(class_332 context) {
        int centerX = this.field_22789 / 2;
        int panelY = 20;
        String title = this.field_22793.method_27523(class_2561.method_43471((String)"game.simon.title").getString(), 200);
        context.method_51439(this.field_22793, (class_2561)class_2561.method_43470((String)title), centerX - this.field_22793.method_1727(title) / 2, panelY, -16711681, true);
        String seq = this.field_22793.method_27523(class_2561.method_43469((String)"game.simon.sequence_length", (Object[])new Object[]{this.game.getSequenceLength()}).getString(), 200);
        context.method_51439(this.field_22793, (class_2561)class_2561.method_43470((String)seq), centerX - this.field_22793.method_1727(seq) / 2, panelY + 15, -5592406, true);
        String best = this.field_22793.method_27523(class_2561.method_43469((String)"game.simon.best_score", (Object[])new Object[]{this.bestScore}).getString(), 200);
        context.method_51439(this.field_22793, (class_2561)class_2561.method_43470((String)best), centerX - this.field_22793.method_1727(best) / 2, panelY + 30, -5592406, true);
    }

    private void drawGameOver(class_332 context) {
        int boxW = 260;
        int boxH = 120;
        int bx = (this.field_22789 - boxW) / 2;
        int by = (this.field_22790 - boxH) / 2;
        context.method_25296(bx, by, bx + boxW, by + boxH, -794165248, -799735808);
        int cx = bx + boxW / 2;
        int y = by + 18;
        context.method_27534(this.field_22793, (class_2561)class_2561.method_43471((String)"game.simon.lose"), cx, y, -1);
        context.method_27534(this.field_22793, (class_2561)class_2561.method_43469((String)"game.simon.length", (Object[])new Object[]{this.game.getSequenceLength() - 1}), cx, y += 22, -256);
        context.method_27534(this.field_22793, (class_2561)class_2561.method_43471((String)"game.simon.restart_hint"), cx, y += 22, -3355444);
    }

    public boolean method_25402(class_11909 click, boolean doubled) {
        if (this.game == null || click.method_74245() != 0) {
            return super.method_25402(click, doubled);
        }
        if (this.game.getState() == SimonGame.State.SHOWING) {
            return false;
        }
        int mx = (int)click.comp_4798();
        int my = (int)click.comp_4799();
        for (int i = 0; i < 4; ++i) {
            int score;
            int x = this.centerX + i * (this.blockSize + this.spacing);
            int y = this.centerY;
            if (mx < x || mx > x + this.blockSize || my < y || my > y + this.blockSize) continue;
            boolean handled = this.game.clickButton(i);
            this.lampFlashTimes[i] = System.currentTimeMillis();
            if (this.game.getState() == SimonGame.State.LOST && (score = Math.max(0, this.game.getSequenceLength() - 1)) > this.bestScore) {
                this.bestScore = score;
                GameRecords.getInstance().setBestScore("simon", this.bestScore);
            }
            return handled || super.method_25402(click, doubled);
        }
        return super.method_25402(click, doubled);
    }

    public boolean method_25404(class_11908 input) {
        if (input.method_74228() == 82) {
            this.game.reset();
            return true;
        }
        if (input.method_74228() == 256) {
            this.field_22787.method_1507(this.parent);
            return true;
        }
        return super.method_25404(input);
    }

    public boolean method_25421() {
        return false;
    }
}

