/*
 * Decompiled with CFR 0.152.
 */
package com.fanya.gamemc.minigames.simon;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_310;
import net.minecraft.class_3417;
import net.minecraft.class_6880;

public class SimonGame {
    private final Random random = new Random();
    private final List<Integer> sequence = new ArrayList<Integer>();
    private int showingIndex = -1;
    private int playerInputIndex = 0;
    private boolean currentlyLit = false;
    private long lastChangeTime = 0L;
    private final long showDuration = 500L;
    private final long betweenDelay = 200L;
    private State state = State.IDLE;
    private long waitStartTime = 0L;
    private final int initialLength;
    private static final int LAMP_COUNT = 4;

    public SimonGame(int initialLength) {
        this.initialLength = Math.max(1, initialLength);
        this.reset();
    }

    public void reset() {
        this.sequence.clear();
        for (int i = 0; i < this.initialLength; ++i) {
            this.sequence.add(this.random.nextInt(4));
        }
        this.startShowing();
    }

    private void startShowing() {
        this.state = State.SHOWING;
        this.showingIndex = 0;
        this.playerInputIndex = 0;
        this.currentlyLit = false;
        this.lastChangeTime = System.currentTimeMillis();
    }

    private void startNextRoundDelay() {
        this.state = State.WAITING_NEXT_ROUND;
        this.waitStartTime = System.currentTimeMillis();
    }

    public void startInputPhase() {
        this.state = State.INPUT;
        this.currentlyLit = false;
        this.showingIndex = -1;
        this.playerInputIndex = 0;
    }

    public void update() {
        long now = System.currentTimeMillis();
        switch (this.state.ordinal()) {
            case 0: {
                this.updateShowing(now);
                break;
            }
            case 3: {
                this.updateWaiting(now);
            }
        }
    }

    private void updateWaiting(long now) {
        long betweenRoundsDelay = 800L;
        if (now - this.waitStartTime >= betweenRoundsDelay) {
            this.startShowing();
        }
    }

    private void updateShowing(long now) {
        if (!this.currentlyLit) {
            if (now - this.lastChangeTime >= 200L) {
                this.currentlyLit = true;
                this.lastChangeTime = now;
                this.playLampSound(this.sequence.get(this.showingIndex));
            }
        } else if (now - this.lastChangeTime >= 500L) {
            this.currentlyLit = false;
            this.lastChangeTime = now;
            ++this.showingIndex;
            if (this.showingIndex >= this.sequence.size()) {
                this.startInputPhase();
            }
        }
    }

    public boolean clickButton(int index) {
        if (this.state != State.INPUT) {
            return false;
        }
        this.playLampSound(index);
        int expected = this.sequence.get(this.playerInputIndex);
        if (expected != index) {
            this.state = State.LOST;
            return true;
        }
        ++this.playerInputIndex;
        if (this.playerInputIndex >= this.sequence.size()) {
            this.sequence.add(this.random.nextInt(4));
            this.startNextRoundDelay();
        }
        return true;
    }

    public int getCurrentlyShowingIndex() {
        if (this.state != State.SHOWING || !this.currentlyLit || this.showingIndex < 0 || this.showingIndex >= this.sequence.size()) {
            return -1;
        }
        return this.sequence.get(this.showingIndex);
    }

    private void playLampSound(int index) {
        class_310 client = class_310.method_1551();
        if (client == null) {
            return;
        }
        float pitch = switch (index) {
            case 0 -> 0.7f;
            case 1 -> 0.9f;
            case 2 -> 1.1f;
            case 3 -> 1.3f;
            default -> 1.0f;
        };
        client.method_1483().method_4873((class_1113)class_1109.method_47978((class_6880)class_3417.field_15114, (float)pitch));
    }

    public long getShowDuration() {
        return 500L;
    }

    public long getBetweenDelay() {
        return 200L;
    }

    public State getState() {
        return this.state;
    }

    public int getSequenceLength() {
        return this.sequence.size();
    }

    public static enum State {
        SHOWING,
        INPUT,
        LOST,
        WAITING_NEXT_ROUND,
        IDLE;

    }
}

