/*
 * Decompiled with CFR 0.152.
 */
package com.fanya.gamemc.minigames.snake;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Random;
import java.util.function.Consumer;
import net.minecraft.class_2350;
import net.minecraft.class_2960;

public class SnakeGame {
    private final int gridWidth;
    private final int gridHeight;
    private final List<RenderSegment> snake;
    private class_2350 direction;
    private final List<Position> foods = new ArrayList<Position>();
    private final Map<Position, FoodConfig> foodMap = new HashMap<Position, FoodConfig>();
    private boolean gameOver;
    private boolean gameWon;
    private int score;
    private final Random random;
    private long lastMoveTime;
    private long moveDelay;
    private List<FoodConfig> foodConfigs = new ArrayList<FoodConfig>();
    private Consumer<FoodConfig> onFoodEaten = null;
    private final Queue<class_2350> inputQueue = new ArrayDeque<class_2350>();

    public SnakeGame(int gridWidth, int gridHeight) {
        this.gridWidth = Math.max(5, gridWidth);
        this.gridHeight = Math.max(5, gridHeight);
        this.snake = new ArrayList<RenderSegment>();
        this.random = new Random();
        this.initDefaultFoodConfigs();
        this.reset();
    }

    private void initDefaultFoodConfigs() {
        ArrayList<FoodConfig> list = new ArrayList<FoodConfig>();
        list.add(new FoodConfig(class_2960.method_60656((String)"textures/item/potato.png"), 1, 30));
        list.add(new FoodConfig(class_2960.method_60656((String)"textures/item/cookie.png"), 2, 25));
        list.add(new FoodConfig(class_2960.method_60656((String)"textures/item/carrot.png"), 3, 25));
        list.add(new FoodConfig(class_2960.method_60656((String)"textures/item/apple.png"), 4, 20));
        list.add(new FoodConfig(class_2960.method_60656((String)"textures/item/bread.png"), 5, 15));
        list.add(new FoodConfig(class_2960.method_60656((String)"textures/item/honey_bottle.png"), 6, 15));
        list.add(new FoodConfig(class_2960.method_60656((String)"textures/item/cooked_beef.png"), 8, 10));
        list.add(new FoodConfig(class_2960.method_60656((String)"textures/item/golden_apple.png"), 20, 5));
        list.add(new FoodConfig(class_2960.method_60656((String)"textures/item/poisonous_potato.png"), -3, 25));
        list.add(new FoodConfig(class_2960.method_60656((String)"textures/item/rotten_flesh.png"), -5, 10, 1));
        this.foodConfigs = list;
    }

    public void setOnFoodEaten(Consumer<FoodConfig> callback) {
        this.onFoodEaten = callback;
    }

    public boolean isGameWon() {
        return this.gameWon;
    }

    public void reset() {
        this.snake.clear();
        int startX = this.gridWidth / 2;
        int startY = this.gridHeight / 2;
        this.snake.add(new RenderSegment(startX, startY));
        this.snake.add(new RenderSegment(startX - 1, startY));
        this.snake.add(new RenderSegment(startX - 2, startY));
        this.direction = class_2350.field_11034;
        this.inputQueue.clear();
        this.gameOver = false;
        this.gameWon = false;
        this.score = 0;
        this.lastMoveTime = System.currentTimeMillis();
        this.calculateMoveDelay();
        this.spawnFoods();
    }

    private void calculateMoveDelay() {
        long baseDelay = 180L;
        long minDelay = 50L;
        int gridArea = this.gridWidth * this.gridHeight;
        int maxArea = 1500;
        int minArea = 100;
        this.moveDelay = minDelay + (long)(maxArea - gridArea) * (baseDelay - minDelay) / (long)(maxArea - minArea);
        if (this.moveDelay < minDelay) {
            this.moveDelay = minDelay;
        }
        if (this.moveDelay > baseDelay) {
            this.moveDelay = baseDelay;
        }
    }

    public void update() {
        if (this.gameOver) {
            return;
        }
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastMoveTime < this.moveDelay) {
            return;
        }
        this.lastMoveTime = currentTime;
        for (RenderSegment seg : this.snake) {
            seg.prevGridX = seg.gridX;
            seg.prevGridY = seg.gridY;
        }
        if (!this.inputQueue.isEmpty()) {
            this.direction = this.inputQueue.poll();
        }
        RenderSegment head = this.snake.getFirst();
        Position newHead = new Position(head.gridX, head.gridY);
        switch (this.direction) {
            case field_11043: {
                --newHead.y;
                break;
            }
            case field_11035: {
                ++newHead.y;
                break;
            }
            case field_11039: {
                --newHead.x;
                break;
            }
            case field_11034: {
                ++newHead.x;
            }
        }
        if (newHead.x < 0) {
            newHead.x = this.gridWidth - 1;
        }
        if (newHead.x >= this.gridWidth) {
            newHead.x = 0;
        }
        if (newHead.y < 0) {
            newHead.y = this.gridHeight - 1;
        }
        if (newHead.y >= this.gridHeight) {
            newHead.y = 0;
        }
        for (RenderSegment seg : this.snake) {
            if (seg.gridX != newHead.x || seg.gridY != newHead.y) continue;
            this.gameOver = true;
            return;
        }
        this.snake.addFirst(new RenderSegment(newHead.x, newHead.y));
        FoodConfig eaten = this.foodMap.get(newHead);
        int segmentsToRemove = 1;
        if (eaten != null) {
            int extraRemove;
            double multiplier = this.getScoreMultiplier();
            this.score += (int)((double)eaten.getPoints() * multiplier);
            if (this.onFoodEaten != null) {
                try {
                    this.onFoodEaten.accept(eaten);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            segmentsToRemove = (extraRemove = Math.max(0, eaten.getSegmentsToRemove())) > 0 ? (segmentsToRemove += extraRemove) : 0;
            this.spawnFoods();
        }
        for (int i = 0; i < segmentsToRemove; ++i) {
            if (this.snake.size() <= 1) continue;
            this.snake.removeLast();
        }
        if (this.snake.size() == this.gridWidth * this.gridHeight) {
            this.gameWon = true;
            this.gameOver = true;
        }
    }

    public void setDirection(class_2350 newDirection) {
        class_2350 lastDir;
        class_2350 class_23502 = lastDir = this.inputQueue.peek() != null ? this.inputQueue.peek() : this.direction;
        if (lastDir == class_2350.field_11043 && newDirection == class_2350.field_11035 || lastDir == class_2350.field_11035 && newDirection == class_2350.field_11043 || lastDir == class_2350.field_11039 && newDirection == class_2350.field_11034 || lastDir == class_2350.field_11034 && newDirection == class_2350.field_11039) {
            return;
        }
        this.inputQueue.add(newDirection);
    }

    private void spawnFoods() {
        this.clearFoods();
        int gridArea = this.gridWidth * this.gridHeight;
        int freeCells = gridArea - this.snake.size();
        if (freeCells <= 0) {
            return;
        }
        int maxSpawn = Math.min(4, freeCells);
        int count = 1 + this.random.nextInt(maxSpawn);
        int totalWeight = this.foodConfigs.stream().mapToInt(FoodConfig::getWeight).sum();
        for (int i = 0; i < count; ++i) {
            FoodConfig fc;
            Position p;
            block6: {
                int attempts = 0;
                do {
                    Position testPos = p = new Position(this.random.nextInt(this.gridWidth), this.random.nextInt(this.gridHeight));
                    boolean collidesWithSnake = this.snake.stream().anyMatch(seg -> seg.gridX == testPos.x && seg.gridY == testPos.y);
                    boolean collidesWithFood = this.foods.contains(testPos);
                    if (!collidesWithSnake && !collidesWithFood) break block6;
                } while (++attempts <= 1000);
                return;
            }
            if (totalWeight <= 0) {
                fc = this.foodConfigs.get(this.random.nextInt(this.foodConfigs.size()));
            } else {
                int pick = this.random.nextInt(totalWeight);
                int acc = 0;
                fc = this.foodConfigs.getFirst();
                for (FoodConfig cand : this.foodConfigs) {
                    if (pick >= (acc += cand.getWeight())) continue;
                    fc = cand;
                    break;
                }
            }
            this.foods.add(p);
            this.foodMap.put(p, fc);
        }
    }

    private void clearFoods() {
        this.foods.clear();
        this.foodMap.clear();
    }

    public List<RenderSegment> getSnake() {
        return this.snake;
    }

    public List<Position> getFoods() {
        return Collections.unmodifiableList(this.foods);
    }

    public FoodConfig getFoodConfigAt(Position pos) {
        return this.foodMap.get(pos);
    }

    public boolean isGameOver() {
        return this.gameOver;
    }

    public int getScore() {
        return this.score;
    }

    public int getGridWidth() {
        return this.gridWidth;
    }

    public int getGridHeight() {
        return this.gridHeight;
    }

    public long getLastMoveTime() {
        return this.lastMoveTime;
    }

    public long getMoveDelay() {
        return this.moveDelay;
    }

    public double getScoreMultiplier() {
        int area = this.gridWidth * this.gridHeight;
        int smallThreshold = 240;
        int mediumThreshold = 600;
        if (area <= smallThreshold) {
            return 2.0;
        }
        if (area <= mediumThreshold) {
            return 1.5;
        }
        return 1.0;
    }

    public static class FoodConfig {
        private final class_2960 texture;
        private final int points;
        private final int weight;
        private final int segmentsToRemove;

        public FoodConfig(class_2960 texture, int points, int weight, int segmentsToRemove) {
            this.texture = texture;
            this.points = points;
            this.weight = weight;
            this.segmentsToRemove = segmentsToRemove;
        }

        public FoodConfig(class_2960 texture, int points, int weight) {
            this(texture, points, weight, 0);
        }

        public class_2960 getTexture() {
            return this.texture;
        }

        public int getPoints() {
            return this.points;
        }

        public int getWeight() {
            return this.weight;
        }

        public int getSegmentsToRemove() {
            return this.segmentsToRemove;
        }
    }

    public static class RenderSegment {
        public float x;
        public float y;
        public int gridX;
        public int gridY;
        public int prevGridX;
        public int prevGridY;

        public RenderSegment(int gridX, int gridY) {
            this.gridX = gridX;
            this.gridY = gridY;
            this.prevGridX = gridX;
            this.prevGridY = gridY;
            this.x = gridX;
            this.y = gridY;
        }

        public void updatePosition(float t) {
            this.x = (float)this.prevGridX + t * (float)(this.gridX - this.prevGridX);
            this.y = (float)this.prevGridY + t * (float)(this.gridY - this.prevGridY);
        }
    }

    public static class Position {
        public int x;
        public int y;

        public Position(int x, int y) {
            this.x = x;
            this.y = y;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof Position)) {
                return false;
            }
            Position other = (Position)obj;
            return this.x == other.x && this.y == other.y;
        }

        public int hashCode() {
            return this.x * 1000 + this.y;
        }
    }
}

