/*
 * Decompiled with CFR 0.152.
 */
package com.fanya.gamemc.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;

public class VersionChecker {
    private static final String PROJECT_ID = "Y8NDA63J";
    private static final String API_URL = "https://api.modrinth.com/v2/project/Y8NDA63J/version";
    private volatile String latestVersion = "";
    private final String currentVersion = ((ModContainer)FabricLoader.getInstance().getModContainer("gamemc").orElseThrow()).getMetadata().getVersion().getFriendlyString();
    private volatile boolean done = false;
    private volatile boolean failed = false;

    public VersionChecker() {
        System.out.println("(gamemc) Current version: " + this.currentVersion);
    }

    public void fetchLatestVersionAsync() {
        Thread thread = new Thread(() -> {
            try {
                URL url = new URL(API_URL);
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                connection.setRequestMethod("GET");
                BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                JsonArray array = JsonParser.parseReader((Reader)reader).getAsJsonArray();
                if (array.size() == 0) {
                    this.failed = true;
                    this.done = true;
                    return;
                }
                JsonObject newest = array.get(0).getAsJsonObject();
                String newestDate = newest.get("date_published").getAsString();
                for (JsonElement el : array) {
                    JsonObject obj = el.getAsJsonObject();
                    String date = obj.get("date_published").getAsString();
                    if (date.compareTo(newestDate) <= 0) continue;
                    newest = obj;
                    newestDate = date;
                }
                this.latestVersion = newest.get("version_number").getAsString();
            }
            catch (Exception e) {
                this.failed = true;
            }
            this.done = true;
        });
        thread.setDaemon(true);
        thread.start();
    }

    public boolean isReady() {
        return this.done && !this.failed;
    }

    public boolean isUpdateAvailable() {
        String currentMod;
        if (!this.done || this.latestVersion.isEmpty()) {
            return false;
        }
        String latestMod = this.extractModVersion(this.latestVersion);
        return !latestMod.equals(currentMod = this.extractModVersion(this.currentVersion));
    }

    public String extractModVersion(String v) {
        int plus = v.indexOf(43);
        return plus == -1 ? v : v.substring(0, plus);
    }

    public String getLatestVersion() {
        return this.latestVersion;
    }
}

