/*
 * Decompiled with CFR 0.152.
 */
package com.fanya.gamemc.minigames.simon;

import com.fanya.gamemc.data.GameRecords;
import com.fanya.gamemc.minigames.simon.GuiNoteParticle;
import com.fanya.gamemc.minigames.simon.SimonGame;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_5348;

public class SimonGameScreen
extends class_437 {
    private static final class_2960 NOTE_BLOCK_TEXTURE = class_2960.method_60656((String)"textures/block/note_block.png");
    private final class_437 parent;
    private SimonGame game;
    private int bestScore;
    private int centerX;
    private int centerY;
    private int blockSize;
    private int spacing;
    private final List<GuiNoteParticle> guiParticles = new ArrayList<GuiNoteParticle>();
    private int lastShownStep = -1;

    public SimonGameScreen(class_437 parent) {
        super((class_2561)class_2561.method_43471((String)"game.simon.title"));
        this.parent = parent;
    }

    protected void method_25426() {
        super.method_25426();
        this.bestScore = GameRecords.getInstance().getBestScore("simon");
        if (this.game == null) {
            this.game = new SimonGame(3);
        }
        int buttonWidth = Math.min(90, this.field_22789 / 6);
        int buttonHeight = 16;
        int y = this.field_22790 - 28;
        int spacingButton = 8;
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_5244.field_24339, button -> {
            if (this.field_22787 != null) {
                this.field_22787.method_1507(this.parent);
            }
        }).method_46434(this.field_22789 / 2 - buttonWidth - spacingButton / 2, y, buttonWidth, buttonHeight).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43471((String)"game.simon.button.newgame"), button -> this.game.reset()).method_46434(this.field_22789 / 2 + spacingButton / 2, y, buttonWidth, buttonHeight).method_46431());
        this.calculateLayout();
    }

    private void calculateLayout() {
        this.blockSize = Math.max(28, Math.min(64, this.field_22789 / 8));
        this.spacing = Math.max(6, this.blockSize / 6);
        int totalWidth = this.blockSize * 5 + this.spacing * 4;
        this.centerX = (this.field_22789 - totalWidth) / 2;
        this.centerY = Math.max(80, this.field_22790 / 2 - this.blockSize / 2);
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        this.guiParticles.removeIf(p -> !p.isAlive());
        for (GuiNoteParticle p2 : this.guiParticles) {
            p2.update();
        }
        super.method_57728(context, delta);
        context.method_25296(0, 0, this.field_22789, this.field_22790, -1342177280, -1073741824);
        if (this.game != null && this.game.getState() != SimonGame.State.LOST) {
            this.game.update();
        }
        int pad = 6;
        int panelWidth = this.blockSize * 5 + this.spacing * 4 + pad * 2;
        int panelHeight = this.blockSize + pad * 2;
        int panelX = this.centerX - pad;
        int panelY = this.centerY - pad;
        context.method_25296(panelX - 2, panelY - 2, panelX + panelWidth + 2, panelY + panelHeight + 2, -15037287, -15901338);
        context.method_25294(panelX, panelY, panelX + panelWidth, panelY + panelHeight, -16115169);
        for (int i = 0; i < 5; ++i) {
            int x = this.centerX + i * (this.blockSize + this.spacing);
            int y = this.centerY;
            this.drawNoteBlock(context, x, y, this.blockSize, i);
        }
        this.drawInfo(context);
        if (this.game != null && this.game.getState() == SimonGame.State.LOST) {
            this.drawGameOver(context);
        }
        this.method_25396().forEach(child -> {
            if (child instanceof class_4185) {
                class_4185 button = (class_4185)child;
                button.method_25394(context, mouseX, mouseY, delta);
            }
        });
        RenderSystem.setShaderTexture((int)0, (class_2960)GuiNoteParticle.NOTE_TEXTURE);
        for (GuiNoteParticle p3 : this.guiParticles) {
            float r = (float)(p3.color >> 16 & 0xFF) / 255.0f;
            float g = (float)(p3.color >> 8 & 0xFF) / 255.0f;
            float b = (float)(p3.color & 0xFF) / 255.0f;
            float a = p3.alpha;
            RenderSystem.setShaderTexture((int)0, (class_2960)GuiNoteParticle.NOTE_TEXTURE);
            RenderSystem.setShaderColor((float)r, (float)g, (float)b, (float)a);
            context.method_25290(GuiNoteParticle.NOTE_TEXTURE, (int)p3.x, (int)p3.y, 0.0f, 0.0f, 16, 16, 16, 16);
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private void drawNoteBlock(class_332 context, int x, int y, int size, int index) {
        RenderSystem.setShaderTexture((int)0, (class_2960)NOTE_BLOCK_TEXTURE);
        context.method_25290(NOTE_BLOCK_TEXTURE, x, y, 0.0f, 0.0f, size, size, size, size);
        if (this.game != null && this.game.getState() == SimonGame.State.SHOWING) {
            int showing = this.game.getCurrentlyShowingIndex();
            if (showing >= 0 && showing < this.game.getSequence().size()) {
                int seqIdx = this.game.getSequence().get(showing);
                if (seqIdx == index && this.lastShownStep != showing) {
                    this.lastShownStep = showing;
                    int color = switch (index) {
                        case 0 -> -65536;
                        case 1 -> -16711936;
                        case 2 -> -16776961;
                        case 3 -> -256;
                        case 4 -> -65281;
                        default -> -1;
                    };
                    this.guiParticles.add(new GuiNoteParticle((float)x + (float)this.blockSize / 2.0f, y, color));
                }
            } else {
                this.lastShownStep = -1;
            }
        }
        int mx = (int)(this.field_22787.field_1729.method_1603() * (double)this.field_22789 / (double)this.field_22787.method_22683().method_4489());
        int my = (int)(this.field_22787.field_1729.method_1604() * (double)this.field_22790 / (double)this.field_22787.method_22683().method_4506());
        if (mx >= x && mx <= x + size && my >= y && my <= y + size) {
            context.method_25294(x, y, x + size, y + size, 0x33FFFFFF);
        }
        context.method_25294(x, y + size - 4, x + size, y + size - 3, -12303292);
    }

    private boolean isCurrentlyLit() {
        return this.game != null && this.game.getState() == SimonGame.State.SHOWING && this.game.getCurrentlyShowingIndex() >= 0;
    }

    private void drawInfo(class_332 context) {
        class_5250 title = class_2561.method_43471((String)"game.simon.title");
        class_5250 seqLen = class_2561.method_43469((String)"game.simon.sequence_length", (Object[])new Object[]{this.game != null ? this.game.getSequenceLength() : 0});
        int panelHeight = 36;
        int panelY = Math.max(8, this.centerY - panelHeight - 8);
        int panelX = this.centerX;
        int panelW = this.blockSize * 5 + this.spacing * 4;
        context.method_25296(panelX - 6, panelY - 6, panelX + panelW + 6, panelY + panelHeight + 6, -804253680, -534765536);
        context.method_27535(this.field_22793, (class_2561)title, panelX + 6, panelY - 2, 0xFFFFFF);
        context.method_27535(this.field_22793, (class_2561)seqLen, panelX + panelW - this.field_22793.method_27525((class_5348)seqLen) - 6, panelY + 12, 16766720);
        class_5250 bestText = class_2561.method_43469((String)"game.simon.best_score", (Object[])new Object[]{this.bestScore});
        context.method_27535(this.field_22793, (class_2561)bestText, panelX + panelW - this.field_22793.method_27525((class_5348)bestText) - 6, panelY - 2, 8900331);
    }

    private void drawGameOver(class_332 context) {
        int boxW = 260;
        int boxH = 120;
        int bx = (this.field_22789 - boxW) / 2;
        int by = (this.field_22790 - boxH) / 2;
        context.method_25296(bx, by, bx + boxW, by + boxH, -794165248, -799735808);
        int centerX = bx + boxW / 2;
        int y = by + 18;
        context.method_27534(this.field_22793, (class_2561)class_2561.method_43471((String)"game.simon.lose"), centerX, y, 0xFFFFFF);
        context.method_27534(this.field_22793, (class_2561)class_2561.method_43469((String)"game.simon.length", (Object[])new Object[]{this.game != null ? this.game.getSequenceLength() - 1 : 0}), centerX, y += 22, 0xFFFF00);
        context.method_27534(this.field_22793, (class_2561)class_2561.method_43471((String)"game.simon.restart_hint"), centerX, y += 22, 0xCCCCCC);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.game == null) {
            return super.method_25402(mouseX, mouseY, button);
        }
        if (button != 0) {
            return super.method_25402(mouseX, mouseY, button);
        }
        if (this.game.getState() == SimonGame.State.SHOWING) {
            return false;
        }
        int mx = (int)mouseX;
        int my = (int)mouseY;
        for (int i = 0; i < 5; ++i) {
            int score;
            int x = this.centerX + i * (this.blockSize + this.spacing);
            int y = this.centerY;
            if (mx < x || mx > x + this.blockSize || my < y || my > y + this.blockSize) continue;
            boolean handled = this.game.clickButton(i);
            int color = switch (i) {
                case 0 -> -65536;
                case 1 -> -16711936;
                case 2 -> -16776961;
                case 3 -> -256;
                case 4 -> -65281;
                default -> -1;
            };
            this.guiParticles.add(new GuiNoteParticle((float)x + (float)this.blockSize / 2.0f, y, color));
            if (this.game.getState() == SimonGame.State.LOST && (score = Math.max(0, this.game.getSequenceLength() - 1)) > this.bestScore) {
                this.bestScore = score;
                GameRecords.getInstance().setBestScore("simon", this.bestScore);
            }
            return handled || super.method_25402(mouseX, mouseY, button);
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 82) {
            if (this.game != null) {
                this.game.reset();
            }
            return true;
        }
        if (keyCode == 256) {
            if (this.field_22787 != null) {
                this.field_22787.method_1507(this.parent);
            }
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public boolean method_25421() {
        return false;
    }
}

