/*
 * Decompiled with CFR 0.152.
 */
package com.fanya.gamemc.screen;

import com.fanya.gamemc.minigames._2048.Game2048Screen;
import com.fanya.gamemc.minigames.simon.SimonGameScreen;
import com.fanya.gamemc.minigames.snake.SnakeSizeSelectScreen;
import com.fanya.gamemc.util.VersionChecker;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_5348;

public class GameSelectionScreen
extends class_437 {
    private final class_437 parent;
    private final List<class_4185> gameButtons = new ArrayList<class_4185>();
    private class_4185 backButton;
    private int scrollOffset = 0;
    private int panelX;
    private int panelY;
    private final int panelWidth = 350;
    private final int panelHeight = 220;
    private int listAreaX;
    private int listAreaY;
    private int listAreaWidth;
    private int listAreaHeight;
    private final int buttonWidth = 200;
    private final int buttonHeight = 20;
    private final int buttonGap = 8;
    private final VersionChecker versionChecker = new VersionChecker();

    public GameSelectionScreen(class_437 parent) {
        super((class_2561)class_2561.method_43471((String)"menu.gamemc.select"));
        this.parent = parent;
    }

    protected void method_25426() {
        super.method_25426();
        this.versionChecker.fetchLatestVersionAsync();
        this.panelX = this.field_22789 / 2 - 175;
        this.panelY = this.field_22790 / 2 - 110;
        this.listAreaX = this.panelX + 16;
        this.listAreaY = this.panelY + 58;
        this.listAreaWidth = 318;
        this.listAreaHeight = 112;
        int centerX = this.field_22789 / 2 - 100;
        this.gameButtons.clear();
        this.gameButtons.add(class_4185.method_46430((class_2561)class_2561.method_43471((String)"menu.gamemc.button.snakegame"), button -> this.setScreenIfPresent(new SnakeSizeSelectScreen(this))).method_46434(centerX, 0, 200, 20).method_46431());
        this.gameButtons.add(class_4185.method_46430((class_2561)class_2561.method_43471((String)"menu.gamemc.button.simon"), button -> this.setScreenIfPresent(new SimonGameScreen(this))).method_46434(centerX, 0, 200, 20).method_46431());
        this.gameButtons.add(class_4185.method_46430((class_2561)class_2561.method_43471((String)"menu.gamemc.button.2048"), button -> this.setScreenIfPresent(new Game2048Screen(this))).method_46434(centerX, 0, 200, 20).method_46431());
        int backBtnX = this.field_22789 / 2 - 100;
        int backBtnY = this.panelY + 220 - 18 - 20;
        this.backButton = class_4185.method_46430((class_2561)class_5244.field_24339, button -> this.setScreenIfPresent(this.parent)).method_46434(backBtnX, backBtnY, 200, 20).method_46431();
    }

    private void setScreenIfPresent(class_437 scr) {
        if (this.field_22787 != null) {
            this.field_22787.method_1507(scr);
        }
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        super.method_57728(context, delta);
        context.method_25296(0, 0, this.field_22789, this.field_22790, -1072689136, -804253680);
        context.method_25294(this.panelX + 4, this.panelY + 4, this.panelX + 350 + 4, this.panelY + 220 + 4, Integer.MIN_VALUE);
        context.method_25296(this.panelX, this.panelY, this.panelX + 350, this.panelY + 220, -535818224, -534765536);
        context.method_25294(this.panelX, this.panelY, this.panelX + 350, this.panelY + 2, -15037287);
        context.method_25294(this.panelX, this.panelY + 220 - 2, this.panelX + 350, this.panelY + 220, -15037287);
        context.method_25294(this.panelX, this.panelY, this.panelX + 2, this.panelY + 220, -15037287);
        context.method_25294(this.panelX + 350 - 2, this.panelY, this.panelX + 350, this.panelY + 220, -15037287);
        context.method_25294(this.panelX + 40, this.panelY + 45, this.panelX + 350 - 40, this.panelY + 47, 0x60FFFFFF);
        String title = this.field_22793.method_27523(class_2561.method_43471((String)"menu.gamemc.title").getString(), 350);
        context.method_51439(this.field_22793, (class_2561)class_2561.method_43470((String)title), this.field_22789 / 2 - this.field_22793.method_1727(title) / 2, this.panelY + 15, -16711681, true);
        String desc = this.field_22793.method_27523(class_2561.method_43471((String)"menu.gamemc.description").getString(), 350);
        context.method_51439(this.field_22793, (class_2561)class_2561.method_43470((String)desc), this.field_22789 / 2 - this.field_22793.method_1727(desc) / 2, this.panelY + 30, -5592406, true);
        if (this.versionChecker.isReady() && this.versionChecker.isUpdateAvailable()) {
            String latest = this.versionChecker.extractModVersion(this.versionChecker.getLatestVersion());
            int x = this.field_22789 / 2 - this.field_22793.method_27525((class_5348)class_2561.method_43469((String)"menu.gamemc.gui.update", (Object[])new Object[]{latest})) / 2;
            int y = this.panelY - 12;
            context.method_51439(this.field_22793, (class_2561)class_2561.method_43469((String)"menu.gamemc.gui.update", (Object[])new Object[]{latest}), x, y, -23296, true);
        }
        class_310 mc = class_310.method_1551();
        double sf = mc.method_22683().method_4495();
        int scX = (int)((double)this.listAreaX * sf);
        int scY = (int)((double)mc.method_22683().method_4507() - (double)(this.listAreaY + this.listAreaHeight) * sf);
        int scW = (int)((double)this.listAreaWidth * sf);
        int scH = (int)((double)this.listAreaHeight * sf);
        RenderSystem.enableScissorForRenderTypeDraws((int)scX, (int)scY, (int)scW, (int)scH);
        int y = this.listAreaY - this.scrollOffset;
        for (class_4185 btn : this.gameButtons) {
            btn.method_46421(this.field_22789 / 2 - 100);
            btn.method_46419(y);
            if (y + 20 > this.listAreaY && y < this.listAreaY + this.listAreaHeight) {
                btn.method_25394(context, mouseX, mouseY, delta);
            }
            y += 28;
        }
        RenderSystem.disableScissorForRenderTypeDraws();
        this.backButton.method_25394(context, mouseX, mouseY, delta);
        int totalBtnsHeight = 28 * this.gameButtons.size();
        if (totalBtnsHeight > this.listAreaHeight) {
            int barX = this.listAreaX + this.listAreaWidth + 2;
            int barY = this.listAreaY;
            int barWidth = 6;
            int barHeight = this.listAreaHeight;
            context.method_25294(barX, barY, barX + barWidth, barY + barHeight, 0x40111111);
            int handleHeight = Math.max(16, (int)((float)barHeight * (float)barHeight / (float)totalBtnsHeight));
            int handleY = (int)((float)barY + (float)this.scrollOffset / (float)(totalBtnsHeight - this.listAreaHeight) * (float)(barHeight - handleHeight));
            context.method_25294(barX, handleY, barX + barWidth, handleY + handleHeight, -7829368);
        }
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        int totalBtnsHeight = 28 * this.gameButtons.size();
        int maxScroll = Math.max(0, totalBtnsHeight - this.listAreaHeight);
        if (mouseX > (double)this.listAreaX && mouseX < (double)(this.listAreaX + this.listAreaWidth) && mouseY > (double)this.listAreaY && mouseY < (double)(this.listAreaY + this.listAreaHeight) && maxScroll > 0) {
            this.scrollOffset = this.clamp(this.scrollOffset - (int)(verticalAmount * 20.0), maxScroll);
            return true;
        }
        return false;
    }

    private int clamp(int val, int max) {
        return Math.max(0, Math.min(max, val));
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        int y = this.listAreaY - this.scrollOffset;
        for (class_4185 btn : this.gameButtons) {
            if (y + 20 > this.listAreaY && y < this.listAreaY + this.listAreaHeight && btn.method_25402(mouseX, mouseY, button)) {
                return true;
            }
            y += 28;
        }
        if (this.backButton.method_25402(mouseX, mouseY, button)) {
            return true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public void method_25420(class_332 context, int mouseX, int mouseY, float delta) {
    }

    public boolean method_25421() {
        return false;
    }
}

