/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.betterfabricconsole.console;

import java.nio.file.Paths;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.jline.reader.Completer;
import org.jline.reader.CompletionMatcher;
import org.jline.reader.Highlighter;
import org.jline.reader.LineReader;
import org.jline.reader.LineReaderBuilder;
import org.jline.reader.Parser;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;
import xyz.jpenilla.betterfabricconsole.configuration.Config;
import xyz.jpenilla.betterfabricconsole.console.ConsoleAppender;
import xyz.jpenilla.betterfabricconsole.console.ConsoleState;
import xyz.jpenilla.betterfabricconsole.console.DelegatingCompleter;
import xyz.jpenilla.betterfabricconsole.console.DelegatingHighlighter;
import xyz.jpenilla.betterfabricconsole.console.DelegatingParser;
import xyz.jpenilla.betterfabricconsole.console.MinecraftCompletionMatcher;
import xyz.jpenilla.betterfabricconsole.remap.Remapper;
import xyz.jpenilla.betterfabricconsole.remap.RemappingRewriter;

@NullMarked
public final class ConsoleSetup {
    private ConsoleSetup() {
    }

    private static LineReader buildLineReader(Completer completer, Highlighter highlighter, Parser parser) {
        System.setProperty("org.jline.reader.support.parsedline", "true");
        return LineReaderBuilder.builder().appName("Dedicated Server").variable("history-file", (Object)Paths.get(".console_history", new String[0])).completer(completer).highlighter(highlighter).parser(parser).completionMatcher((CompletionMatcher)new MinecraftCompletionMatcher()).option(LineReader.Option.INSERT_TAB, false).option(LineReader.Option.DISABLE_EVENT_EXPANSION, true).option(LineReader.Option.COMPLETE_IN_WORD, true).build();
    }

    public static ConsoleState init(@Nullable Remapper remapper, Config config) {
        DelegatingCompleter delegatingCompleter = new DelegatingCompleter();
        DelegatingHighlighter delegatingHighlighter = new DelegatingHighlighter();
        DelegatingParser delegatingParser = new DelegatingParser();
        LineReader lineReader = ConsoleSetup.buildLineReader(delegatingCompleter, delegatingHighlighter, delegatingParser);
        ConsoleAppender consoleAppender = new ConsoleAppender(lineReader, config.logPattern(), remapper != null ? new RemappingRewriter(remapper) : null);
        consoleAppender.start();
        Logger logger = (Logger)LogManager.getRootLogger();
        LoggerContext loggerContext = (LoggerContext)LogManager.getContext((boolean)false);
        LoggerConfig loggerConfig = loggerContext.getConfiguration().getLoggerConfig(logger.getName());
        loggerConfig.removeAppender("SysOut");
        loggerConfig.addAppender((Appender)consoleAppender, loggerConfig.getLevel(), null);
        loggerContext.updateLoggers();
        return new ConsoleState(lineReader, delegatingCompleter, delegatingHighlighter, delegatingParser);
    }
}

