/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.betterfabricconsole.remap;

import com.mojang.logging.LogUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.util.HashMap;
import net.fabricmc.mappingio.MappingReader;
import net.fabricmc.mappingio.MappingVisitor;
import net.fabricmc.mappingio.format.proguard.ProGuardFileReader;
import org.jspecify.annotations.NullMarked;
import org.slf4j.Logger;
import xyz.jpenilla.betterfabricconsole.remap.MojangMappingsDownloader;
import xyz.jpenilla.betterfabricconsole.remap.RemapperImpl;
import xyz.jpenilla.betterfabricconsole.remap.YarnMappingsDownloader;
import xyz.jpenilla.betterfabricconsole.util.Util;

@NullMarked
public interface Remapper {
    public static final Logger LOGGER = LogUtils.getLogger();

    public void remapThrowable(Throwable var1);

    public StackTraceElement[] remapStacktrace(StackTraceElement[] var1);

    public String remapClassName(String var1);

    public static Remapper yarn(YarnMappingsDownloader.YarnData data) throws IOException {
        return RemapperImpl.create("named", tree -> {
            try (FileSystem yarnJarFs = FileSystems.newFileSystem(URI.create("jar:" + String.valueOf(data.mappingsJar().toUri())), new HashMap());
                 BufferedReader yarnReader = Files.newBufferedReader(yarnJarFs.getPath("mappings/mappings.tiny", new String[0]));){
                MappingReader.read((Reader)yarnReader, (MappingVisitor)tree);
            }
        }, data.serialized());
    }

    public static Remapper mojangMappings(MojangMappingsDownloader.MojangMappingsData data) throws IOException {
        return RemapperImpl.create("mojang", tree -> {
            try (BufferedReader serverReader = Util.gzipBufferedReader(data.serverMappings());
                 BufferedReader clientReader = Util.gzipBufferedReader(data.clientMappings());
                 FileSystem intermediaryJarFs = FileSystems.newFileSystem(URI.create("jar:" + String.valueOf(data.intermediaryMappingsJar().toUri())), new HashMap());
                 BufferedReader intermediaryReader = Files.newBufferedReader(intermediaryJarFs.getPath("mappings/mappings.tiny", new String[0]));){
                ProGuardFileReader.read((Reader)serverReader, (String)"mojang", (String)"official", (MappingVisitor)tree);
                ProGuardFileReader.read((Reader)clientReader, (String)"mojang", (String)"official", (MappingVisitor)tree);
                MappingReader.read((Reader)intermediaryReader, (MappingVisitor)tree);
            }
        }, data.serialized());
    }
}

