/*
 * Decompiled with CFR 0.152.
 */
package xyz.jpenilla.betterfabricconsole.remap;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.mojang.logging.LogUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.Duration;
import java.util.Comparator;
import java.util.stream.StreamSupport;
import org.jspecify.annotations.NullMarked;
import org.jspecify.annotations.Nullable;
import org.slf4j.Logger;
import xyz.jpenilla.betterfabricconsole.remap.MappingsCache;
import xyz.jpenilla.betterfabricconsole.remap.MappingsDownloader;
import xyz.jpenilla.betterfabricconsole.util.Util;

@NullMarked
final class YarnMappingsDownloader
implements MappingsDownloader<YarnData> {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final String YARN_VERSIONS_PATH = "data/yarn-versions.json.gz";
    private static final String YARN_MAPPINGS_PATH = "mappings/yarn/" + MappingsCache.MINECRAFT_VERSION + ".jar";
    private static final String SERIALIZED_MAPPINGS_PATH = "mappings/yarn/" + MappingsCache.MINECRAFT_VERSION + "-serialized.json.gz";
    private static final String YARN_MAPPINGS_VERSION_PATH = "mappings/yarn/" + MappingsCache.MINECRAFT_VERSION + "-current-yarn.txt";
    private static final String YARN_URL = "https://maven.fabricmc.net/net/fabricmc/yarn/{}/yarn-{}-mergedv2.jar";
    private static final String YARN_VERSIONS_URL = "https://meta.fabricmc.net/v2/versions/yarn";
    private final Path cache;

    YarnMappingsDownloader(MappingsCache cache) {
        this.cache = cache.cache;
    }

    @Override
    public YarnData downloadMappings() throws IOException {
        Path yarnVersionsPath = this.cache.resolve(YARN_VERSIONS_PATH);
        boolean downloadedJson = YarnMappingsDownloader.downloadYarnVersionsJson(yarnVersionsPath, false);
        @Nullable Integer latestBuild = YarnMappingsDownloader.findLatestYarnBuildForMcVersion(yarnVersionsPath);
        if (!downloadedJson && latestBuild == null) {
            YarnMappingsDownloader.downloadYarnVersionsJson(yarnVersionsPath, true);
            latestBuild = YarnMappingsDownloader.findLatestYarnBuildForMcVersion(yarnVersionsPath);
        }
        if (latestBuild == null) {
            throw new IllegalStateException("Could not find yarn mappings for version " + MappingsCache.MINECRAFT_VERSION);
        }
        String yarnVersion = MappingsCache.MINECRAFT_VERSION + "+build." + latestBuild;
        Path versionFile = this.cache.resolve(YARN_MAPPINGS_VERSION_PATH);
        if (!Files.isRegularFile(versionFile, new LinkOption[0]) || !Files.readString(versionFile).equals(yarnVersion)) {
            this.downloadYarn(downloadedJson, yarnVersion);
        }
        return new YarnData(this.yarnMappingsJar(), this.serializedMappings());
    }

    private static @Nullable Integer findLatestYarnBuildForMcVersion(Path yarnVersionsPath) throws IOException {
        JsonElement root;
        try (BufferedReader reader = Util.gzipBufferedReader(yarnVersionsPath);){
            root = (JsonElement)Util.GSON.fromJson((Reader)reader, JsonElement.class);
        }
        if (!(root instanceof JsonArray)) {
            return null;
        }
        JsonArray yarnVersions = (JsonArray)root;
        return StreamSupport.stream(yarnVersions.spliterator(), false).map(JsonElement::getAsJsonObject).filter(element -> element.get("gameVersion").getAsString().equals(MappingsCache.MINECRAFT_VERSION)).map(object -> object.get("build").getAsInt()).max(Comparator.naturalOrder()).orElse(null);
    }

    private static boolean downloadYarnVersionsJson(Path yarnVersionsPath, boolean forceDownload) throws IOException {
        if (forceDownload || !Files.exists(yarnVersionsPath, new LinkOption[0])) {
            MappingsCache.downloadFileAndGzip(YARN_VERSIONS_URL, yarnVersionsPath);
            return true;
        }
        long lastModified = Files.getLastModifiedTime(yarnVersionsPath, new LinkOption[0]).toMillis();
        Duration sinceModified = Duration.ofMillis(System.currentTimeMillis() - lastModified);
        if (sinceModified.compareTo(Duration.ofDays(7L)) > 0) {
            try {
                MappingsCache.downloadFileAndGzip(YARN_VERSIONS_URL, yarnVersionsPath);
            }
            catch (IOException ex) {
                LOGGER.warn("Failed to update yarn version index", (Throwable)ex);
                return false;
            }
            return true;
        }
        return false;
    }

    private void downloadYarn(boolean forceDownload, String yarnVersion) throws IOException {
        Path yarnMappings = this.yarnMappingsJar();
        if (forceDownload || !Files.exists(yarnMappings, new LinkOption[0])) {
            MappingsCache.downloadFile(YARN_URL.replace("{}", yarnVersion), yarnMappings);
            Path version = this.cache.resolve(YARN_MAPPINGS_VERSION_PATH);
            Files.writeString(version, (CharSequence)yarnVersion, new OpenOption[0]);
            Files.deleteIfExists(this.serializedMappings());
        }
    }

    private Path yarnMappingsJar() {
        return this.cache.resolve(YARN_MAPPINGS_PATH);
    }

    private Path serializedMappings() {
        return this.cache.resolve(SERIALIZED_MAPPINGS_PATH);
    }

    public record YarnData(Path mappingsJar, Path serialized) {
    }
}

