package com.amotassic.dabaosword.api.skill;

import com.amotassic.dabaosword.item.ModItems;
import com.amotassic.dabaosword.item.skillcard.SkillCards;
import com.amotassic.dabaosword.util.ModTools;
import java.util.List;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2561;

/**
 * 一个用于封装技能物品堆的类，省去了以原版物品堆为基础实现技能的麻烦。
 * 即使构造函数传入的物品堆不是技能物品，也会将其封装为{@link ModItems#EMPTY_SKILL}，不至于出现类转换异常。
 * @author Amotassic
 */
public final class Skill {
    public final class_1799 stack;
    public final ISkill item;

    public Skill(class_1799 skill) {
        this.stack = skill;
        this.item = skill.method_7909() instanceof ISkill iSkill ? iSkill : ModItems.EMPTY_SKILL;
    }

    public boolean lockOn() {
        if (item.isActiveSkill()) return false;
        return this.item.lockOn();
    }

    public boolean isActiveSkill() {return this.item.isActiveSkill();}

    public List<SkillExecutor> data() {
        return SkillCards.SKILL_MAP.getOrDefault(stack.method_7909(), List.of());
    }

    public boolean activeSkill(class_1657 user, Skill skill) {return item.activeSkill(user, skill);}
    public boolean activeSkill(class_1657 user, Skill skill, class_1309 target) {return item.activeSkill(user, skill, target);}

    public int getCD() {Integer i = stack.method_57824(ModItems.CD); return i == null ? 0 : i;}
    public void setCD(int seconds) {stack.method_57379(ModItems.CD, seconds);}

    public int getTag() {Integer i = stack.method_57824(ModItems.TAGS); return i == null ? 0 : i;}
    public void setTag(int value) {stack.method_57379(ModItems.TAGS, value);}

    public int getMinSelect() {
        var nbt = getNbt();
        if (!nbt.method_10545("minSelect")) return -1;
        return nbt.method_10550("minSelect");
    }
    public void setMinSelect(int value) { //设置打开GUI时后需要选择物品的最小数量
        var nbt = getNbt();
        nbt.method_10569("minSelect", value);
        setNbt(nbt);
    }

    public int getMaxSelect() {
        var nbt = getNbt();
        if (!nbt.method_10545("maxSelect")) return Integer.MAX_VALUE;
        return nbt.method_10550("maxSelect");
    }
    public void setMaxSelect(int value) { //设置打开GUI时后需要选择物品的最大数量
        var nbt = getNbt();
        nbt.method_10569("maxSelect", value);
        setNbt(nbt);
    }

    /**若需要同时限制技能选取卡牌的最大值和最小值，调用这个方法更方便*/
    public void setShouldSelect(int min, int max) {setMinSelect(min); setMaxSelect(max);}

    public boolean isEmpty() {return stack.method_7960();}

    public class_2561 toHoverableText() {return stack.method_7954();}

    public class_2487 getNbt() {return ModTools.getOrCreateNbt(stack);}

    public void setNbt(class_2487 nbt) {ModTools.setNbt(stack, nbt);}

}
