package com.amotassic.dabaosword.data;

import com.amotassic.dabaosword.DabaoSword;
import com.amotassic.dabaosword.api.card.Card;
import com.amotassic.dabaosword.api.card.Rank;
import com.amotassic.dabaosword.api.card.Suit;
import com.amotassic.dabaosword.item.card.CardItem;
import com.google.gson.*;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import net.minecraft.class_7923;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class CardSuitAndRank extends class_4309 implements IdentifiableResourceReloadListener {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    public static final CardSuitAndRank INSTANCE = new CardSuitAndRank();
    // 所有的牌
    public static final List<class_1799> ALL_CARDS = new ArrayList<>();

    public CardSuitAndRank() {super(GSON, "default_suit_and_rank");}

    @Override
    public class_2960 getFabricId() {
        return class_2960.method_60655("dabaosword", "default_suit_and_rank");
    }

    @Override
    protected void apply(Map<class_2960, JsonElement> prepared, class_3300 manager, class_3695 profiler) {
        ALL_CARDS.clear();
        for (Map.Entry<class_2960, JsonElement> entry : prepared.entrySet()) {
            // System.out.println(entry.getKey() + " " + entry.getValue());
            class_2960 key = entry.getKey();
            JsonElement jsonElement = entry.getValue();
            try {
                class_1792 item = class_7923.field_41178.method_10223(key);
                if (item instanceof CardItem cardItem) {
                    try {
                        JsonArray srs = jsonElement.getAsJsonObject().get("suits_and_ranks").getAsJsonArray();
                        for (int j = 0; j < srs.size(); j++) {
                            JsonObject sr = srs.get(j).getAsJsonObject();
                            String suit = sr.get("suit").getAsString();
                            String rank = sr.get("rank").getAsString();

                            Card card = new Card(cardItem, Suit.valueOf(suit), Rank.fromString(rank));
                            ALL_CARDS.add(card.toStack());
                        }
                    } catch (Exception e) {
                        DabaoSword.LOGGER.error("Missing Element: suits_and_ranks");
                    }
                }
            } catch (Exception e) {
                DabaoSword.LOGGER.error("No such card registered: {}", key);
            }
        }
        DabaoSword.LOGGER.info("Loaded {} cards", ALL_CARDS.size());
    }
}
