package com.amotassic.dabaosword.event;

import com.amotassic.dabaosword.api.event.EndEntityTick;
import com.amotassic.dabaosword.api.skill.ISkill;
import com.amotassic.dabaosword.api.skill.Skill;
import com.amotassic.dabaosword.item.ModItems;
import com.amotassic.dabaosword.util.Gamerule;
import com.amotassic.dabaosword.util.ModConfig;
import java.util.Collections;
import java.util.Objects;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1934;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3545;
import net.minecraft.class_5134;

import static com.amotassic.dabaosword.util.ModTools.*;
import static dev.emi.trinkets.api.TrinketsApi.getTrinketComponent;

public class EntityTickEvents implements EndEntityTick.EndLivingTick, EndEntityTick.EndPlayerTick {
    @Override
    public void endLivingTick(class_1309 entity) {
        if (entity.method_37908() instanceof class_3218 world) {
            long time = world.method_8510();
            if (time % 2 == 0) {
                String[] tags = {"sha", "juedou", "nanman", "wanjian"};
                for (var tag : tags) entity.method_5752().remove(tag);
            }
            if (time % 20 == 0) {
                //阳光开朗的笑容的效果：让与其对视的实体冻伤（阴风阵阵）
                if (entity.method_6118(class_1304.field_6169).method_31574(ModItems.SUNSHINE_SMILE)) for (var e : world.method_8390(class_1309.class, new class_238(entity.method_24515()).method_1014(20), e -> e != entity && isEyeContact(e, entity, 25))) e.method_32317(240);
            }
            if (time % 200 == 0) {
                entity.method_5752().remove("seen_skill_tip");
            }

            //处理所有加触及距离和近战防御距离的效果
            int level1 = 0; int level2 = 0;
            if (shouldReachLong(entity)) level1 += 114;
            for (var skill : getSkillsMayUse(entity)) {
                level1 += skill.item.getExtraReach(entity, skill);
                level2 += skill.item.getDefend(entity, skill);
            }
            if (level1 > 0) entity.method_6092(new class_1293(ModItems.REACH, 2,level1 - 1,false,false,false));
            if (level2 > 0) entity.method_6092(new class_1293(ModItems.DEFEND, 2,level2 - 1,false,false,false));

            //若方天画戟被触发了，只要左键就可以造成群伤
            class_1657 closest = world.method_18460(entity, 5);
            class_1799 stack;
            if (closest != null && !(stack = trinketItem(ModItems.FANGTIAN, closest)).method_7960() && entity.method_5805()) {
                if (s(stack).getCD() > 15 && closest.field_6279 == 1) {
                    //给玩家本人一个极短的无敌效果，以防止被误伤
                    closest.method_6092(new class_1293(ModItems.INVULNERABLE,2,0,false,false,false));
                    float i = (float) closest.method_45325(class_5134.field_23721);
                    entity.method_5643(closest.method_48923().method_48802(closest), i);
                }
            }
        }
    }

    @Override
    public void endPlayerTick(class_1657 player) {
        if (player.method_37908() instanceof class_3218 world) {
            var time = world.method_8510();
            int giveCard = world.method_8450().method_8356(Gamerule.GIVE_CARD_INTERVAL) * 20;
            boolean limit = world.method_8450().method_8355(Gamerule.ENABLE_CARDS_LIMIT);

            if (time % 100 == 0) {
                //若玩家不在任何一场对战中，且拥有身份标签，则移除。如果意外卡在旁观者模式，变回生存模式并杀死
                if (!PVPGameEvents.getGameManager().isPlayerInGame(player)) {
                    var tags = player.method_5752();
                    if (tags.contains("dabaosword.zhong") || tags.contains("dabaosword.fan") || tags.contains("dabaosword.nei")) {
                        player.method_5752().remove("dabaosword.zhong");
                        player.method_5752().remove("dabaosword.fan");
                        player.method_5752().remove("dabaosword.nei");
                        if (player.method_7325()) {
                            ((class_3222) player).method_7336(class_1934.field_9215);
                            player.method_5768();
                        }
                    }
                }
            }

            if (time % giveCard == 0) { // 每分钟摸两张牌
                if (!player.method_7337() && !player.method_7325() && player.method_5805()) {
                    player.method_7353(class_2561.method_43471("dabaosword.draw"),true);
                    if (player.method_6059(ModItems.BINGLIANG)) player.method_6016(ModItems.BINGLIANG);
                    else if (countCards(player) < player.method_6063() || !limit) {
                        int draw = hasTrinket(ModItems.CARD_PILE, player) ? 2 : 0;
                        for (var skill : getSkillsMayUse(player)) {
                            int i = skill.item.onDrawPhase(player, skill);
                            if (i <= -114) {draw = 0; break;}
                            draw += i;
                        }
                        if (draw > 0) draw(player, draw);
                    }
                }
            }

            if (time % 2 == 0) decreaseAttackRange(player);

            if (player.field_7512 != player.field_7498 && time % 3 == 0) {
                for (var skill : getTrinketComponent(player).map(c -> c.getEquipped(s -> s.method_7909() instanceof ISkill).stream().map(class_3545::method_15441).map(Skill::new).toList()).orElse(Collections.emptyList())) {
                    var s = skill.item;
                    if (s.shouldTickUpdate()) s.tickUpdateNbt(skill, player);
                }
            }

            //下落攻击触发：脚底下两格是空气，手里拿着有耐久度的物品左键即可触发
            class_2338 blockPos = player.method_24515().method_10087(1); class_2338 blockPos2 = player.method_24515().method_10087(2);
            if (ModConfig.FallingAttack && world.method_8320(blockPos).method_26204() == class_2246.field_10124 && world.method_8320(blockPos2).method_26204() == class_2246.field_10124 && player.method_6047().method_7963() && player.field_6279 == 1) {
                player.method_6092(new class_1293(ModItems.FALLING_ATTACK, class_1293.field_42106,0,false,false,false));
            }

        }
    }

    private void decreaseAttackRange(class_1309 entity) {
        class_238 box = new class_238(entity.method_24515()).method_1014(20);
        for (class_1309 target : entity.method_37908().method_8390(class_1309.class, box, living -> living != entity && living.method_6059(ModItems.DEFEND) && isLooking(entity, living))) {
            //实现沈佳宜的效果：若玩家看到的玩家有近战防御效果，则给当前玩家攻击范围缩短效果
            int amplifier = Objects.requireNonNull(target.method_6112(ModItems.DEFEND)).method_5578();
            entity.method_6092(new class_1293(ModItems.DEFENDED, 2, amplifier,false,false,true));
        }
    }

    public static boolean isLooking(class_1309 entity, class_1297 target) {
        class_243 playerPos = entity.method_33571();
        class_243 lookVec = entity.method_5828(1.0F);
        class_238 targetBox = target.method_5829();
        // 进行射线与碰撞箱的相交检测
        return targetBox.method_992(playerPos, playerPos.method_1019(lookVec.method_1021(100.0))).isPresent();
    }

    public static boolean isEyeContact(class_1297 entity1, class_1297 entity2, float angle) {
        double MAX_ANGLE = Math.toRadians(angle);
        class_243 pos1 = entity1.method_19538(); class_243 pos2 = entity2.method_19538();
        // 计算从生物 1 到生物 2 的向量
        class_243 d = pos2.method_1020(pos1);
        // 获取生物的视线方向
        class_243 v1 = entity1.method_5828(1.0F); class_243 v2 = entity2.method_5828(1.0F);
        // 计算夹角
        double theta1 = Math.acos(v1.method_1026(d.method_1029()));
        double theta2 = Math.acos(v2.method_1026(d.method_1029().method_22882()));
        // 判断夹角是否在允许范围内
        return theta1 <= MAX_ANGLE && theta2 <= MAX_ANGLE;
    }
}
