package com.amotassic.dabaosword.item.card.equipment;

import com.amotassic.dabaosword.api.card.Card;
import com.amotassic.dabaosword.api.skill.*;
import com.amotassic.dabaosword.item.ModItems;
import com.amotassic.dabaosword.item.skillcard.SkillCards;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.class_124;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_8111;

import static com.amotassic.dabaosword.api.CardEvents.cardDiscard;
import static com.amotassic.dabaosword.util.ModTools.*;
import static net.minecraft.class_124.field_1075;

public class Weapon extends Equipment {

    public static class Cixiong extends Weapon  {
        @Override
        public void addTip(Skill skill, List<class_2561> tooltip) {
            tooltip.add(getTip("1"));
            tooltip.add(getTip("2", field_1075));
        }

        @SkillInfo(trigger = Trigger.SELECT_TARGET, relation = Relation.NOT_SELF)
        public int onSha(class_1309 user, class_1309 target, Skill skill, ExData data) {
            Card card = data.getFirst();
            if (isSha.test(card.toStack()) && target != null && new Random().nextFloat() < 0.5) {
                draw(user); voice(user, this);
            }
            return 0;
        }
    }

    public static class Fangtian extends Weapon {
        @Override
        public void addTip(Skill skill, List<class_2561> tooltip) {
            tooltip.add(getTip("1"));
            tooltip.add(getTip("2", field_1075));
        }

        @Override
        public void preAttack(class_1657 player, class_1309 target, Skill skill) {
            //方天画戟：打中生物后触发特效，给予CD和持续时间
            if (skill.getCD() == 0) {
                skill.setCD(20);
                voice(player, this);
                player.method_7353(class_2561.method_43471("dabaosword.fangtian").method_27692(class_124.field_1061), true);
            }
        }
    }

    public static class Guanshi extends Weapon  {
        @Override
        public void addTip(Skill skill, List<class_2561> tooltip) {
            tooltip.add(getTip("1"));
            tooltip.add(getTip("2", field_1075));
        }
    }

    public static class Guding extends Weapon {
        @Override
        public void addTip(Skill skill, List<class_2561> tooltip) {
            tooltip.add(class_2561.method_43471("item.dabaosword.gudingdao.tooltip").method_27692(class_124.field_1060));
            tooltip.add(class_2561.method_43471("item.dabaosword.gudingdao.tooltip2").method_27692(field_1075));
        }

        @SkillInfo(trigger = Trigger.MODIFY_DAMAGE, relation = Relation.DIRECT_ATTACKER)
        public int addDamage(class_1309 user, class_1309 target, Skill skill, ExData data) {
            var adds = data.adds;
            int i = 0;
            for (var s : target.method_5661()) {if (s.method_7960()) i++;}
            if (i == 4) {
                voice(user, this);
                adds.add(5f);
            }
            return 0;
        }
    }

    public static class Hanbing extends Weapon {
        public void addTip(Skill skill, List<class_2561> tooltip) {tooltip.add(getTip(field_1075));}

        @SkillInfo(trigger = Trigger.ON_HURT, relation = Relation.DIRECT_ATTACKER)
        public int onHit(class_1309 user, class_1309 target, Skill skill, ExData data) {
            voice(user, this);
            target.field_6008 = 0;
            target.method_32317(500);
            return 0;
        }
    }

    public static class Liannu extends Weapon {
        @Override
        public void addTip(Skill skill, List<class_2561> tooltip) {
            tooltip.add(getTip("1"));
            tooltip.add(getTip("2", field_1075));
        }

        @Override
        public void preAttack(class_1657 player, class_1309 target, Skill skill) {
            int i = 2;
            if (hasTrinket(ModItems.CHITU, player)) i++;
            if (hasTrinket(SkillCards.MASHU, player)) i++;
            if (hasTrinket(ModItems.DILU, target)) i--;
            if (hasTrinket(SkillCards.FEIYING, target)) i--;
            if (player.method_5739(target) <= i) {
                player.method_6092(new class_1293(class_1294.field_5917, 3, 255,false, false, false));
                voice(player, this);
            }
        }
    }

    public static class Qilin extends Weapon {
        @Override
        public void addTip(Skill skill, List<class_2561> tooltip) {
            tooltip.add(getTip("1"));
            tooltip.add(getTip("2", field_1075));
            tooltip.add(getTip("3", field_1075));
        }

        @Override public int getExtraReach(class_1309 entity, Skill skill) {return 1;}

        @SkillInfo(trigger = Trigger.ON_HURT, relation = Relation.ATTACKER)
        public int nimameile(class_1309 user, class_1309 target, Skill skill, ExData data) {
            if (skill.getCD() != 0) return 0;
            class_1799 chitu = trinketItem(ModItems.CHITU, target);
            class_1799 dilu = trinketItem(ModItems.DILU, target);
            List<class_1799> horse = new ArrayList<>();
            if (!chitu.method_7960()) horse.add(chitu); if (!dilu.method_7960()) horse.add(dilu);
            if (horse.isEmpty()) return 0;
            class_1799 selected = horse.get(new Random().nextInt(horse.size()));
            class_2561 message = class_2561.method_43469("dabaosword.discard", user.method_5476(), target.method_5476(), selected.method_7954());
            if (user instanceof class_1657 player) player.method_43496(message);
            if (target instanceof class_1657 player) player.method_43496(message);
            cardDiscard(target, d().cards(selected, 1, true));
            voice(user, this);
            skill.setCD(30);
            return 0;
        }
    }

    public static class Qinggang extends Weapon {
        @Override
        public void addTip(Skill skill, List<class_2561> tooltip) {
            tooltip.add(getTip("1"));
            tooltip.add(getTip("2", field_1075));
        }

        @Override
        public void preAttack(class_1657 player, class_1309 target, Skill skill) {
            if (player.method_7261(0f) < 1f) return;
            //青釭剑额外伤害
            float extraDamage = Math.min(20, 0.2f * target.method_6063());
            target.method_5643(getDamageSource(player, class_8111.field_44869), extraDamage); target.field_6008 = 0;
            voice(player, this);
        }
    }

    public static class Qinglong extends Weapon {
        @Override
        public void addTip(Skill skill, List<class_2561> tooltip) {
            tooltip.add(getTip("1"));
            tooltip.add(getTip("2", field_1075));
        }

        @Override
        public void preAttack(class_1657 player, class_1309 target, Skill skill) {
            voice(player, this);
            player.method_6092(new class_1293(ModItems.INVULNERABLE,10,0,false,false,false));
            player.method_6082(target.method_23317(), target.method_23318(), target.method_23321(), false);
            class_243 momentum = player.method_5720().method_1021(2);
            target.field_6037 = true; target.method_18800(momentum.method_10216(),0 ,momentum.method_10215());
        }
    }

    public static class Zhangba extends Weapon {
        @Override
        public void addTip(Skill skill, List<class_2561> tooltip) {
            tooltip.add(getTip("1"));
            tooltip.add(getTip("2", field_1075));
        }

        @SkillInfo(trigger = Trigger.LOSE_CARD_USE, relation = Relation.SELF)
        public int useCardGetSha(class_1309 user, class_1309 target, Skill skill, ExData data) {
            if (skill.getCD() > 0) return 0;
            class_1799 stack = data.getFirst().toStack();
            if (isSha.test(stack)) return 0;
            skill.setTag(skill.getTag() + 1);
            if (skill.getTag() >= 2) {
                skill.setTag(0);
                skill.setCD(1);
                give(user, new Card(ModItems.SHA).toStack());
            }
            return 0;
        }
    }

    public static class Zhuque extends Weapon {
        @Override
        public void addTip(Skill skill, List<class_2561> tooltip) {
            tooltip.add(getTip("1"));
            tooltip.add(getTip("2", field_1075));
        }

        @SkillInfo(trigger = Trigger.ON_HURT, relation = Relation.ATTACKER)
        public int fire(class_1309 user, class_1309 target, Skill skill, ExData data) {
            voice(user, this);
            target.method_5639(4);
            return 0;
        }
    }
}
