package com.amotassic.dabaosword.mixin;

import com.amotassic.dabaosword.api.event.PlayerConnectCallback;
import com.amotassic.dabaosword.api.event.PlayerRespawnCallback;
import com.llamalad7.mixinextras.sugar.Local;
import net.minecraft.class_1297;
import net.minecraft.class_2535;
import net.minecraft.class_3222;
import net.minecraft.class_3324;
import net.minecraft.class_8792;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(class_3324.class)
public abstract class PlayerManagerMixin {

    @Inject(
            method = "onPlayerConnect",
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/server/PlayerManager;sendToAll(Lnet/minecraft/network/packet/Packet;)V"
            )
    )
    public void onPlayerConnect(class_2535 connection, class_3222 player, class_8792 clientData, CallbackInfo ci) {
        PlayerConnectCallback.EVENT.invoker().onPlayerConnect(connection, player);
    }

    @SuppressWarnings({"checkstyle:NoWhitespaceBefore", "checkstyle:MethodName"})
    @Inject(method = "respawnPlayer", at = @At(value = "INVOKE",
            // This target lets us modify respawn position
            target = "Lnet/minecraft/server/world/ServerWorld;getLevelProperties()Lnet/minecraft/world/WorldProperties;"
    ))
    public void onRespawnPlayer_afterSetPosition(
            class_3222 oldPlayer, boolean alive, class_1297.class_5529 removalReason, CallbackInfoReturnable<class_3222> cir,
            @Local(ordinal = 1) class_3222 serverPlayerEntity
    ) {
        PlayerRespawnCallback.EVENT.invoker().onPlayerRespawn(oldPlayer, serverPlayerEntity);
    }
}
