package com.amotassic.dabaosword.mixin;

import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.Objects;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1584;
import net.minecraft.class_1937;
import net.minecraft.class_3763;

@Mixin(class_1584.class)
public abstract class RavagerMixin extends class_3763 {
    @Shadow private int stunTick;

    @Shadow private int roarTick;

    @Shadow protected abstract void knockBack(class_1297 entity);

    protected RavagerMixin(class_1299<? extends class_3763> entityType, class_1937 world) {super(entityType, world);}

    @Inject(method = "tickMovement", at = @At("HEAD"))
    public void tickMovement(CallbackInfo ci) {
        if (method_5752().contains("a")) {
            stunTick = 20;
            method_5752().remove("a");
        }
        if (method_5752().contains("b") && roarTick == 1) method_31472();
    }

    @Inject(method = "roar", at = @At("HEAD"), cancellable = true)
    private void roar(CallbackInfo ci) {
        if (method_5805() && method_16914() && method_5752().contains("b")) {
            int id = Integer.parseInt(Objects.requireNonNull(method_5797()).getString());
            class_1309 living = (class_1309) method_37908().method_8469(id);
            if (living == null) {ci.cancel(); return;}
            knockBack(living);
            ci.cancel();
        }
    }
}
