package com.amotassic.dabaosword.network;

import com.amotassic.dabaosword.item.ModItems;
import com.amotassic.dabaosword.item.skillcard.SkillCards;
import com.amotassic.dabaosword.ui.PileScreenHandler;
import com.amotassic.dabaosword.util.Tags;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.minecraft.class_124;
import net.minecraft.class_1293;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_3222;

import static com.amotassic.dabaosword.util.ModTools.*;

public class ServerNetworking {

    public static void registerActiveSkill() {
        PayloadTypeRegistry.playC2S().register(ActiveSkillPayload.ID, ActiveSkillPayload.CODEC);
        PayloadTypeRegistry.playC2S().register(ShensuPayload.ID, ShensuPayload.CODEC);
        PayloadTypeRegistry.playC2S().register(QuickSwapPayload.ID, QuickSwapPayload.CODEC);

        ServerPlayNetworking.registerGlobalReceiver(ActiveSkillPayload.ID, (payload, context) -> {
            class_1657 player = context.player();
            if (player.method_6059(ModItems.TIEJI)) {
                player.method_7353(class_2561.method_43471("effect.tieji.tip").method_27692(class_124.field_1061), true);
                return;
            }
            int id = payload.id(); class_1309 entity = (class_1309) player.method_37908().method_8469(id);

            for (var skill : getSkillsMayUse(player)) if (player != entity && skill.activeSkill(player, skill, entity)) return;
            for (var skill : getSkillsMayUse(player)) if (skill.activeSkill(player, skill)) return;
        });

        ServerPlayNetworking.registerGlobalReceiver(ShensuPayload.ID, (p, c) -> {
            class_1657 player =c.player();
            float speed = p.f();
            class_1799 stack = trinketItem(SkillCards.SHENSU, player);
            if (!stack.method_7960()) {
                class_2487 nbt = getOrCreateNbt(stack); nbt.method_10548("speed", speed);
                setNbt(stack, nbt);
                //if (getOrCreateNbt(stack).getFloat("speed") > 0) player.sendMessage(Text.literal("Speed: " + speed), true);
            }
        });

        ServerPlayNetworking.registerGlobalReceiver(QuickSwapPayload.ID, (pl, c) -> {
            class_1657 player = c.player();
            int i = pl.id();
            if (i == 0) openInv(player, player, player, class_2561.method_43471("key.dabaosword.select_card"), class_1799.field_8037, false, false, 3);
            if (i == 2 && hasTrinket(ModItems.CARD_PILE, player)) player.method_17355(new ExtendedScreenHandlerFactory<>() {
                @Override
                public Object getScreenOpeningData(class_3222 player) {return new ActiveSkillPayload(0);}

                @Override
                public class_2561 method_5476() {return class_2561.method_43471("card_pile.title");}

                @Override
                public class_1703 createMenu(int syncId, class_1661 inv, class_1657 player) {
                    return new PileScreenHandler(syncId, inv);
                }
            });
            if (i == 3) {
                var pair = getDamage(player);
                if (pair != null) {
                    //取消闪避后，先移除记录的伤害，给玩家一个CD防止闪触发
                    class_1799 stack = trinketItem(ModItems.CARD_PILE, player);
                    class_2487 nbt = getOrCreateNbt(stack); nbt.method_10551("DamageDodged");
                    setNbt(stack, nbt);
                    player.method_6092(new class_1293(ModItems.COOLDOWN2,2,0,false,false,false));
                    player.method_5643(pair.method_15442().method_15442(), pair.method_15442().method_15441());
                    give(player, pair.method_15441());
                }
            }
            if (i == 9) {
                class_1657 target = getClosestEntity(player, class_1657.class, 100, class_1309::method_5805);
                if (target != null) openFullInv(player, target, false);
            }
            if (i >= 100) {
                replaceTrinketSlot(trinketsWithSlots(player, s -> s.method_31573(Tags.SKILLS)), i - 100);
            }
        });
    }
}
