package com.amotassic.dabaosword.ui;

import com.amotassic.dabaosword.api.skill.ISkill;
import com.amotassic.dabaosword.item.ModItems;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_124;
import net.minecraft.class_1661;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_465;

import static com.amotassic.dabaosword.util.ModTools.getOrCreateNbt;
import static com.amotassic.dabaosword.util.ModTools.s;

public class PlayerInvHandledScreen extends class_465<PlayerInvScreenHandler> {
    private static final class_2960 TEXTURE = class_2960.method_60654("textures/gui/container/generic_54.png");
    private final int rows;

    public PlayerInvHandledScreen(PlayerInvScreenHandler handler, class_1661 inventory, class_2561 title) {
        super(handler, inventory, title);
        this.rows = handler.rows;
        this.field_2779 = 24 + rows * 18;
    }

    public void method_25420(class_332 context, int mouseX, int mouseY, float delta) {
        method_2389(context, delta, mouseX, mouseY); //不要加深背景
    }
    @Override
    protected void method_2389(class_332 context, float delta, int mouseX, int mouseY) {
        context.method_25302(TEXTURE, field_2776, field_2800,0,0, field_2792, 17);
        for (int i = 0; i < rows; i++) {
            context.method_25302(TEXTURE, field_2776, field_2800 + 17 + i * 18,0,17, field_2792, 18);
        }
        context.method_25302(TEXTURE, field_2776, field_2800 + rows * 18 + 17,0,215, field_2792, 7);
    }

    @Override
    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        List<class_2561> screenTips = new ArrayList<>();
        var skill = s(eventStack());
        skill.item.addScreenTip(skill, screenTips);
        if (skill.stack.method_7960()) {
            screenTips.clear();
            screenTips.add(class_2561.method_43471("screen.dabaosword.select_card"));
        }
        if (!screenTips.isEmpty()) for (var text : screenTips) {
            int y = 2 + 10 * screenTips.indexOf(text);
            int textWidth = field_22793.method_27525(text);
            // 绘制文本背景
            context.method_25294(1, y - 1, 1 + textWidth + 2, y + field_22793.field_2000, 0xFF202020);
            // 绘制文本
            context.method_51439(field_22793, text, 2, y, 0xE0E0E0, false);
        }
        super.method_25394(context, mouseX, mouseY, delta);
        this.method_2380(context, mouseX, mouseY);
    }

    @Override
    protected void method_2388(class_332 context, int mouseX, int mouseY) {
        context.method_51439(this.field_22793, this.field_22785, this.field_25267, this.field_25268, 0x404040, false);
        class_4587 matrices = context.method_51448();
        matrices.method_22903();
        matrices.method_46416(0f, 0f, 400f);
        getClicks().forEach((i, clicks) -> {
            class_1735 slot = field_2797.method_7611(i);
            context.method_51439(this.field_22793, class_2561.method_43470(clicks + "").method_27692(class_124.field_1061), slot.field_7873, slot.field_7872 + 6, 0x404040, false);
        });
        matrices.method_22909();
    }

    @Override
    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        //System.out.println("keyCode: " + keyCode + " scanCode: " + scanCode + " modifiers: " + modifiers);
        boolean ctrlA = keyCode == 65 && modifiers == 2;
        boolean ctrlZ = keyCode == 90 && modifiers == 2;
        assert field_22787 != null; var stack = eventStack();
        var manager = field_22787.field_1761;
        if (manager != null) {
            if (ctrlA) {manager.method_2906(field_2797.field_7763, 0, 65, class_1713.field_7793, field_22787.field_1724); return true;}
            if (ctrlZ) {manager.method_2906(field_2797.field_7763, 0, 90, class_1713.field_7793, field_22787.field_1724); return true;}
        }
        boolean canClose = !(stack.method_7909() instanceof ISkill) || selectedCount() >= s(stack).getMinSelect();
        if (!canClose || stack.method_31574(ModItems.DISCARD) || stack.method_31574(ModItems.STEAL)) {
            if (field_22787.field_1690.field_1822.method_1417(keyCode, scanCode) || keyCode == 256) return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    @Override
    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double amount) {
        if (field_22787 == null) return false;
        var manager = field_22787.field_1761;
        if (manager != null && field_2787 != null) {
            int id = field_2787.field_7874; //仅用于根据鼠标滚轮滚动来选择卡牌
            if (amount == 1.0) manager.method_2906(field_2797.field_7763, id, 0, class_1713.field_7790, field_22787.field_1724);
            if (amount == -1.0) manager.method_2906(field_2797.field_7763, id, 1, class_1713.field_7790, field_22787.field_1724);
        }
        return super.method_25401(mouseX, mouseY, horizontalAmount, amount);
    }

    private class_1799 eventStack() {return field_2797.method_7611(81).method_7677();}

    private Map<Integer, Integer> getClicks() {
        String str = getOrCreateNbt(field_2797.method_7611(82).method_7677()).method_10558("Clicks");
        Map<Integer, Integer> clicks = new HashMap<>();
        if (str.isEmpty()) return clicks;
        str = str.substring(1, str.length() - 1); //去掉{}如果还是空，则返回空map
        if (str.isEmpty()) return clicks;

        String[] split = str.split(", ");
        for (String s : split) {
            String[] split1 = s.split("=");
            clicks.put(Integer.parseInt(split1[0]), Integer.parseInt(split1[1]));
        }
        return clicks;
    }
    private int selectedCount() {return getClicks().values().stream().mapToInt(Integer::intValue).sum();}
}
