package com.amotassic.dabaosword.util;

import com.amotassic.dabaosword.api.skill.Trigger;
import com.amotassic.dabaosword.item.ModItems;
import com.amotassic.dabaosword.item.card.CardItem;
import com.amotassic.dabaosword.item.card.Sha;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1268;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_8103;

import static com.amotassic.dabaosword.util.ModTools.*;

public class ModifyDamage {
    //由于fabric没有提供修改伤害的方法，因此我自己注入"applyArmorToDamage"以修改生物受到的伤害值
    public static float modify(class_1309 entity, class_1282 source, float value) {
        float multiply = 0; //倍率增伤乘区
        float add = 0; //固定数值加减伤害区
        List<Float> reducing = new ArrayList<>(); //最终减伤乘区，存储负值，每个值使最终伤害为原来的（1+x）倍

        var exData = d().withDamage(source, value);
        getSkillOwners(entity).forEach(player -> getResult(Trigger.MODIFY_DAMAGE, player, entity, exData));

        for (Float f : exData.adds) add += f;
        for (Float f : exData.muls) {
            if (f < 0) reducing.add(f); else multiply += f;
        }

        if (source.method_5526() instanceof class_1309 SE && SE.method_6047().method_31574(ModItems.GUDINGDAO)) {
            //插入一个武器版古锭刀的结算
            int i = 0; //i == 4则说明受击者的盔甲栏没有任何物品
            for (var s : entity.method_5661()) {if (s.method_7960()) i++;}
            if (i == 4) multiply += 1;
        }

        //伤害结算
        value = value * (1 + multiply) + add;
        for (var f : reducing) {value *= (1 + f);}
        return value;
    }

    /**取消伤害结算：
     * @return 0表示不取消伤害，1表示取消伤害以及后续处理，2表示仅取消伤害，但可以执行后续处理*/
    public static int shouldCancel(class_1309 entity, class_1282 source, float amount) {
        List<class_1309> owners = getSkillOwners(entity);
        var exData = d().withDamage(source, amount);

        class_1297 so = source.method_5526(); class_1297 at = source.method_5529();
        //0.最高优先度执行，暂无用途
        for (class_1309 e : owners) {
            int i = getResult(Trigger.CANCEL_DAMAGE_HIGHEST, e, entity, exData);
            if (i > 0) return i;
        }
        //无敌效果
        if (entity.method_6059(ModItems.INVULNERABLE) && !source.method_48789(class_8103.field_42242)) return 1;

        if (so instanceof class_1309 SE) {
            //被乐的生物无法造成伤害
            if (SE.method_6059(ModItems.TOO_HAPPY)) return 1;
            //沈佳宜防御效果
            if (!(SE instanceof class_1657) && entity.method_6059(ModItems.DEFEND)) {
                if (Objects.requireNonNull(entity.method_6112(ModItems.DEFEND)).method_5578() >= 2) return 1;
            }
        } else if (at instanceof class_1309 AT) {
            //被乐的生物无法造成伤害
            if (AT.method_6059(ModItems.TOO_HAPPY)) return 1;
        }

        if (so instanceof class_1309 SE && shouldSha(SE)) { //只要能触发杀，伤害就会被取消
            class_1268 hand = isSha.test(SE.method_6047()) ? class_1268.field_5808 : isSha.test(SE.method_6079()) ? class_1268.field_5810 : null;
            class_1799 sha = hand != null ? SE.method_5998(hand) : getItem(SE, isSha);
            SE.method_5780("sha");
            Sha.shaUse(SE, sha, hand, amount, entity);
            return 2;
        }

        //1.高优先度执行：装备
        for (class_1309 e : owners) {
            int i = getResult(Trigger.CANCEL_DAMAGE_HIGH, e, entity, exData);
            if (i > 0) return i;
        }
        //2.一般优先度执行：技能
        for (class_1309 e : owners) {
            int i = getResult(Trigger.CANCEL_DAMAGE_NORMAL, e, entity, exData);
            if (i > 0) return i;
        }
        //3.低优先度执行：卡牌 闪以及响应南蛮的杀
        for (class_1309 e : owners) {
            int i = getResult(Trigger.CANCEL_DAMAGE_LOW, e, entity, exData);
            if (i > 0) return i;
        }
        if (at != null && at.method_5752().contains("nanman")) {
            var stack = getCard(entity, isSha);
            if (!stack.method_7960()) {
                voice(entity, stack);
                CardItem.onUse(entity, stack, null, true);
                return 1;
            }
        }
        if (at instanceof class_1309) {
            if (!entity.method_6059(ModItems.COOLDOWN2)) {
                //此处条件是故意设置得与八卦阵条件不一样的，虽然感觉没啥用
                if (hasCard(entity, p(ModItems.SHAN)) && !source.method_48789(class_8103.field_42242)) {
                    class_1799 shan = new class_1799(ModItems.SHAN);
                    CardItem.onUse(entity, shan, null, true);
                    shan(entity, false, source, amount);
                    return 1;
                }
            }
        }
        //4.最低优先度执行：绝情
        for (class_1309 e : owners) {
            int i = getResult(Trigger.CANCEL_DAMAGE_LOWEST, e, entity, exData);
            if (i > 0) return i;
        }
        return 0;
    }

    private static boolean shouldSha(class_1309 entity) {
        return hasItem(entity, isSha) && !entity.method_5752().contains("sha") && !entity.method_5752().contains("juedou") && !entity.method_5752().contains("nanman");
    }

    public static void shan(class_1309 entity, boolean bl, class_1282 source, float amount) {
        int cd = bl ? 60 : 40;
        entity.method_6092(new class_1293(ModItems.INVULNERABLE, 20,0,false,false,false));
        entity.method_6092(new class_1293(ModItems.COOLDOWN2, cd,0,false,false,false));
        if (entity instanceof class_1657 player) {
            writeDamage(source, amount, !bl, trinketItem(ModItems.CARD_PILE, player));
            if (bl) player.method_7353(class_2561.method_43471("dabaosword.bagua"),true);
        }
    }

    public static class_1799 modifyStack(class_1799 stack) {
        if (stack.method_31574(ModItems.SUNSHINE_SMILE)) {
            stack.method_7978(ModTools.getEntry(ModItems.CRIT), 1);
        }
        return stack;
    }
}
