/*
 * Decompiled with CFR 0.152.
 */
package com.amotassic.dabaosword.pvpgame;

import com.amotassic.dabaosword.event.PVPGameEvents;
import com.amotassic.dabaosword.pvpgame.Game;
import com.amotassic.dabaosword.util.ModConfig;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_18;
import net.minecraft.class_238;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_7225;
import org.jetbrains.annotations.Nullable;

public class GameManager
extends class_18 {
    private final Map<Integer, Game> games = new HashMap<Integer, Game>();
    private final class_3218 world;
    private int nextAvailableId;

    public static class_18.class_8645<GameManager> getPersistentStateType(class_3218 world) {
        return new class_18.class_8645(() -> new GameManager(world), (nbt, r) -> GameManager.fromNbt(world, nbt), null);
    }

    public GameManager(class_3218 world) {
        this.world = world;
        this.nextAvailableId = 1;
        this.method_80();
    }

    public int getGameCount() {
        return this.games.size();
    }

    @Nullable
    public Game createGame(class_3222 player, int type) {
        class_238 box = new class_238(player.method_24515()).method_1014((double)ModConfig.SearchRadius);
        List players = player.method_37908().method_8390(class_1657.class, box, p -> !p.method_7325() && !this.isPlayerInGame((class_1657)p));
        if (players.size() < 2) {
            player.method_43496((class_2561)class_2561.method_43470((String)"Not enough players to start a game!").method_27692(class_124.field_1061));
            return null;
        }
        HashSet<UUID> playerUuids = new HashSet<UUID>();
        for (class_1657 p2 : players) {
            playerUuids.add(p2.method_5667());
        }
        Game game = new Game(this.nextId(), this.world, playerUuids, type);
        this.games.put(game.getGameId(), game);
        PVPGameEvents.onGameCreate(player, game, playerUuids);
        this.method_80();
        return game;
    }

    @Nullable
    public Game getGameByPlayer(class_1657 player) {
        for (Game game : this.games.values()) {
            if (!game.isPlayerInThisGame(player)) continue;
            return game;
        }
        return null;
    }

    public boolean isPlayerInGame(class_1657 player) {
        return this.getGameByPlayer(player) != null;
    }

    public void tick() {
        Iterator<Game> iterator = this.games.values().iterator();
        while (iterator.hasNext()) {
            Game game = iterator.next();
            if (!game.isActive()) {
                iterator.remove();
                this.method_80();
                continue;
            }
            game.tick();
        }
        if (this.world.method_8510() % 200L == 0L) {
            this.method_80();
        }
    }

    public static GameManager fromNbt(class_3218 world, class_2487 nbt) {
        GameManager gameManager = new GameManager(world);
        gameManager.nextAvailableId = nbt.method_10550("NextAvailableID");
        class_2499 nbtList = nbt.method_10554("Games", 10);
        for (int i = 0; i < nbtList.size(); ++i) {
            class_2487 nbtCompound = nbtList.method_10602(i);
            Game game = new Game(world, nbtCompound);
            gameManager.games.put(game.getGameId(), game);
        }
        return gameManager;
    }

    public class_2487 method_75(class_2487 nbt, class_7225.class_7874 registryLookup) {
        nbt.method_10569("NextAvailableID", this.nextAvailableId);
        class_2499 nbtList = new class_2499();
        for (Game game : this.games.values()) {
            class_2487 nbtCompound = new class_2487();
            game.writeNbt(nbtCompound);
            nbtList.add((Object)nbtCompound);
        }
        nbt.method_10566("Games", (class_2520)nbtList);
        return nbt;
    }

    private int nextId() {
        return ++this.nextAvailableId;
    }
}

