package com.amotassic.dabaosword.api.card;

import java.util.Objects;
import net.minecraft.class_2487;

public enum Rank {
    Ace("A"),
    Two("2"),
    Three("3"),
    Four("4"),
    Five("5"),
    Six("6"),
    Seven("7"),
    Eight("8"),
    Nine("9"),
    Ten("10"),
    Jack("J"),
    Queen("Q"),
    King("K"),
    None(" ");

    public final String rank;

    Rank(String rank) {
        this.rank = rank;
    }

    public static Rank fromString(String rank) {
        for (var r : Rank.values()) {
            if (Objects.equals(r.rank, rank)) return r;
        }
        return None;
    }

    public static Rank fromNbt(class_2487 nbt) {
        if (!nbt.method_10545("Rank")) return None;
        return fromString(nbt.method_10558("Rank"));
    }
}
