package com.amotassic.dabaosword.client;

import com.amotassic.dabaosword.item.skillcard.SkillCards;
import com.amotassic.dabaosword.network.QuickSwapPayload;
import com.amotassic.dabaosword.network.ShensuPayload;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_243;
import net.minecraft.class_304;
import org.lwjgl.glfw.GLFW;

import static com.amotassic.dabaosword.util.ModTools.hasTrinket;

public class ClientTickEnd {
    public static final class_304 ACTIVE_SKILL = keyBinding("active_skill", GLFW.GLFW_KEY_J);
    public static final class_304 SELECT_CARD = keyBinding("select_card", GLFW.GLFW_KEY_K);

    public static void initialize() {
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            var user = client.field_1724;
            if (user == null) return;
            var ctrl = client.field_1690.field_1867;
            // 当打开screen后，关闭选择技能渲染
            if (ChangeSkillRender.isRendering && client.field_1755 != null) {
                ChangeSkillRender.close();
            }

            if (hasTrinket(SkillCards.SHENSU, user)) {
                class_243 lastPos = new class_243(user.field_6038, user.field_5971, user.field_5989);
                float speed = (float) (user.method_19538().method_1022(lastPos) * 20);
                ClientPlayNetworking.send(new ShensuPayload(speed));
            }

            if (SELECT_CARD.method_1436()) {
                int i = 0;
                if (user.method_5715() && ctrl.method_1436()) i = 3;
                else if (ctrl.method_1436()) i = 2;
                ClientPlayNetworking.send(new QuickSwapPayload(i));
            }
        });
    }

    private static class_304 keyBinding(String name, int key) {
        String category = "category.dabaosword.keybindings";
        return KeyBindingHelper.registerKeyBinding(new class_304("key.dabaosword." + name, key, category));
    }
}
