package com.amotassic.dabaosword.item;

import com.amotassic.dabaosword.api.event.*;
import com.amotassic.dabaosword.effect.*;
import com.amotassic.dabaosword.entity.ModEntity;
import com.amotassic.dabaosword.event.*;
import com.amotassic.dabaosword.item.card.*;
import com.amotassic.dabaosword.item.card.equipment.Armor;
import com.amotassic.dabaosword.item.card.equipment.Mount;
import com.amotassic.dabaosword.item.card.equipment.Weapon;
import com.amotassic.dabaosword.item.skillcard.SkillCards;
import com.amotassic.dabaosword.item.skillcard.SkillItem;
import com.amotassic.dabaosword.item.tool.*;
import com.amotassic.dabaosword.network.ActiveSkillPayload;
import com.amotassic.dabaosword.network.OpenScreenPayload;
import com.amotassic.dabaosword.ui.FullInvScreenHandler;
import com.amotassic.dabaosword.ui.PileScreenHandler;
import com.amotassic.dabaosword.ui.PlayerInvScreenHandler;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerWorldEvents;
import net.fabricmc.fabric.api.event.player.AttackEntityCallback;
import net.fabricmc.fabric.api.itemgroup.v1.FabricItemGroup;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerType;
import net.minecraft.class_1291;
import net.minecraft.class_1322;
import net.minecraft.class_1703;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1826;
import net.minecraft.class_1887;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3917;
import net.minecraft.class_4081;
import net.minecraft.class_5134;
import net.minecraft.class_5321;
import net.minecraft.class_5699;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_9135;
import net.minecraft.class_9331;
import java.util.ArrayList;
import java.util.List;
import java.util.function.UnaryOperator;

@SuppressWarnings("unused")
public class ModItems {
    public static final List<CardItem> CARDS = new ArrayList<>();
    //杀
    public static final CardItem
    SHA = registerCard("sha", new Sha()),
    FIRE_SHA = registerCard("fire_sha", new Sha.Fire()),
    THUNDER_SHA = registerCard("thunder_sha", new Sha.Thunder()),
    //闪
    SHAN = registerCard("shan", new ShanItem()),
    //桃
    PEACH = registerCard("peach", new PeachItem()),
    //酒
    JIU = registerCard("jiu", new JiuItem()),

    //兵粮寸断
    BINGLIANG_ITEM = registerCard("bingliang",new BingliangItem()),
    //乐不思蜀
    TOO_HAPPY_ITEM = registerCard("too_happy", new TooHappyItem()),
    //闪电
    SHANDIAN_ITEM = registerCard("shandian", new ShandianItem()),
    //过河拆桥
    DISCARD = registerCard("discard", new DiscardItem()),
    //火攻
    FIRE_ATTACK = registerCard("huogong", new FireAttackItem()),
    //借刀杀人
    JIEDAO = registerCard("jiedao", new JiedaoItem()),
    //决斗
    JUEDOU = registerCard("juedou",new JuedouItem()),
    //南蛮入侵
    NANMAN = registerCard("nanman", new NanmanItem()),
    //顺手牵羊
    STEAL = registerCard("steal", new StealItem()),
    //桃园结义
    TAOYUAN = registerCard("taoyuan", new TaoyuanItem()),
    //铁锁连环
    TIESUO = registerCard("tiesuo",new TiesuoItem()),
    //万箭齐发
    WANJIAN = registerCard("wanjian", new WanjianItem()),
    //五谷丰登
    WUGU = registerCard("wugu", new WuguItem()),
    //无懈可击
    WUXIE = registerCard("wuxie", new CardItem.Armoury()),
    //无中生有
    WUZHONG = registerCard("wuzhong", new WuzhongItem()),

    //雌雄双股剑
    CIXIONG = registerCard("cixiong", new Weapon.Cixiong()),
    //方天画戟
    FANGTIAN = registerCard("fangtian", new Weapon.Fangtian()),
    //贯石斧
    GUANSHI = registerCard("guanshi", new Weapon.Guanshi()),
    // 古锭刀
    GUDING_WEAPON = registerCard("guding_dao", new Weapon.Guding()),
    //寒冰剑
    HANBING = registerCard("hanbing", new Weapon.Hanbing()),
    //麒麟弓
    QILIN = registerCard("qilin", new Weapon.Qilin()),
    //青釭剑
    QINGGANG = registerCard("qinggang", new Weapon.Qinggang()),
    //青龙偃月刀
    QINGLONG = registerCard("qinglong", new Weapon.Qinglong()),
    //丈八蛇矛
    ZHANGBA = registerCard("zhangba", new Weapon.Zhangba()),
    //诸葛连弩
    LIANNU = registerCard("liannu", new Weapon.Liannu()),
    //朱雀羽扇
    ZHUQUE = registerCard("zhuque", new Weapon.Zhuque()),
    //八卦阵
    BAGUA = registerCard("bagua", new Armor.Bagua()),
    //白银狮子
    BAIYIN = registerCard("baiyin", new Armor.Baiyin()),
    //仁王盾
    RENWANG = registerCard("renwang", new Armor.Renwang()),
    //寿衣
    RATTAN_ARMOR = registerCard("rattan_armor", new Armor.Rattan()),
    //-1马
    CHITU = registerCard("chitu", new Mount.Attack()),
    //+1马
    DILU = registerCard("dilu", new Mount.Defend());

    public static final class_1792
    //摸牌
    GAIN_CARD = register("gain_card", new GainCardItem()),
    //牌堆
    CARD_PILE = register("card_pile", new CardPile()),
    //礼盒
    GIFTBOX = register("gift_box", new GiftBoxItem()),
    GUDINGDAO = register("gudingdao", new GudingdaoItem()),
    ARROW_RAIN = register("arrow_rain", new ArrowRainItem()),
    //BB机
    BBJI = register("bbji", new BBjiItem()),
    //让我康康
    LET_ME_CC = register("let_me_cc", new LetMeCCItem()),
    //阳光开朗的笑容
    SUNSHINE_SMILE = register("sunshine_smile", new SunshineSmile()),
    XUYOU_SPAWN_EGG = register("xuyou_spawn_egg", new class_1826(ModEntity.XUYOU, 0x52BDF7, 0x8D8B96, new class_1792.class_1793())),
    GUDING_ITEM = register("guding", new class_1792(new class_1792.class_1793())),
    INCOMPLETE_GUDINGDAO = register("incomplete_gdd", new class_1792(new class_1792.class_1793().method_7889(1)));
    public static final CardItem EMPTY_CARD = register("empty_card", new CardItem.Empty());
    public static final SkillItem EMPTY_SKILL = register("empty_skill", new SkillItem());

    private static <T extends class_1792> T register(String name, T item) {
        return class_2378.method_10230(class_7923.field_41178, class_2960.method_60655("dabaosword", name), item);
    }
    /**将注册的卡牌添加到卡牌列表中，便于自动将物品添加到物品组*/
    public static CardItem registerCard(String name, CardItem item) {
        CardItem card = register(name, item);
        CARDS.add(card);
        return card;
    }

    public static final class_5321<class_1761> ZZRS = class_5321.method_29179(class_7924.field_44688, class_2960.method_60655("dabaosword", "zzrs"));

    private static void addToGroup(class_1761.class_8128 context, class_1761.class_7704 entries) {
        var wrapper = context.comp_1253().method_46762(class_7924.field_41265);
        var entry = wrapper.method_46747(CRIT);
        class_1799 smile = new class_1799(SUNSHINE_SMILE);
        smile.method_7978(entry, 1);
        //添加所有卡牌
        CARDS.forEach(entries::method_45421);
        entries.method_45421(GAIN_CARD);
        entries.method_45421(CARD_PILE);
        //添加所有技能
        SkillCards.SKILLS.forEach(entries::method_45421);

        entries.method_45421(GIFTBOX);
        entries.method_45421(BBJI);
        entries.method_45421(LET_ME_CC);
        entries.method_45420(smile);
        entries.method_45421(XUYOU_SPAWN_EGG);
    }

    //注册部分
    public static void register() {
        class_2378.method_39197(class_7923.field_44687, ZZRS,
                FabricItemGroup.builder().method_47320(() -> new class_1799(SUNSHINE_SMILE))
                        .method_47321(class_2561.method_43471("itemGroup.dabaosword.zzrs"))
                        .method_47317(ModItems::addToGroup).method_47324());

        ServerWorldEvents.LOAD.register(new PVPGameEvents());
        ServerTickEvents.START_SERVER_TICK.register(new PVPGameEvents());
        ServerTickEvents.START_WORLD_TICK.register(new PVPGameEvents());
        PVPGameTickCallback.EVENT.register(new PVPGameEvents());
        AttackEntityCallback.EVENT.register(new AttackEntityHandler());
        EntityHurtCallback.EVENT.register(new EntityHurtHandler());
        PlayerDeathCallback.EVENT.register(new PlayerEvents());
        PlayerRespawnCallback.EVENT.register(new PlayerEvents());
        EndEntityTick.LIVING_EVENT.register(new EntityTickEvents());
        EndEntityTick.PLAYER_EVENT.register(new EntityTickEvents());
    }

    private static class_6880<class_1291> register(String id, class_1291 statusEffect) {
        return class_2378.method_47985(class_7923.field_41174, class_2960.method_60655("dabaosword", id), statusEffect);
    }//状态效果注册
    //兵粮寸断效果
    public static final class_6880<class_1291> BINGLIANG = register("bingliang",
            new CommonEffect(class_4081.field_18272, 0x46F732).method_5566(class_5134.field_23721, class_2960.method_60654("bingliang"),-4, class_1322.class_1323.field_6328)),
    //乐不思蜀效果
    TOO_HAPPY = register("too_happy", new TooHappyEffect().method_5566(class_5134.field_23719, class_2960.method_60654("too_happy"),-10, class_1322.class_1323.field_6331)),
    //触及距离增加
    REACH = register("reach", new CommonEffect(class_4081.field_18271, 0xFFFFFF)
            .method_5566(class_5134.field_47758, class_2960.method_60654("reach_block"), 1.0, class_1322.class_1323.field_6328)
            .method_5566(class_5134.field_47759, class_2960.method_60654("attack_range"), 1.0, class_1322.class_1323.field_6328)),
    //近战防御范围增加
    DEFEND = register("defend", new CommonEffect(class_4081.field_18271, 0xFFFFFF)),
    DEFENDED = register("defended", new CommonEffect(class_4081.field_18272, 0xFFFFFF).method_5566(class_5134.field_47759, class_2960.method_60654("attack_range_lower"), -1.0, class_1322.class_1323.field_6328)),
    //冷却状态效果
    COOLDOWN = register("cooldown", new CooldownEffect()),
    COOLDOWN2 = register("cooldown2", new Cooldown2Effect()),
    //无敌效果
    INVULNERABLE = register("invulnerable", new CommonEffect(class_4081.field_18271,0x35F5DF)),
    //下落攻击效果
    FALLING_ATTACK = register("falling_attack", new FallingEffect()),
    //翻面效果
    TURNOVER = register("turn_over", new TurnOverEffect()),
    //铁骑效果
    TIEJI = register("tieji", new CommonEffect(class_4081.field_18272, 0x07050F)),
    //闪电效果
    SHANDIAN = register("shandian", new ShandianEffect());

    //物品组件注册
    public static final class_9331<Integer> TAGS = regComp("tags", builder -> builder.method_57881(class_5699.field_33441).method_57882(class_9135.field_48550));
    public static final class_9331<Integer> CD = regComp("cd", builder -> builder.method_57881(class_5699.field_33441).method_57882(class_9135.field_48550));

    private static <T> class_9331<T> regComp(String id, UnaryOperator<class_9331.class_9332<T>> builderOperator) {
        return class_2378.method_10230(class_7923.field_49658, class_2960.method_60655("dabaosword",id), (builderOperator.apply(class_9331.method_57873())).method_57880());
    }

    public static final class_3917<PlayerInvScreenHandler> PLAYER_INV_SCREEN_HANDLER = regScreen("player_inv", new ExtendedScreenHandlerType<>(PlayerInvScreenHandler::new, OpenScreenPayload.CODEC));

    public static final class_3917<FullInvScreenHandler> FULL_INV_SCREEN_HANDLER = regScreen("full_inv", new ExtendedScreenHandlerType<>(FullInvScreenHandler::new, OpenScreenPayload.CODEC));

    public static final class_3917<PileScreenHandler> PILE_SCREEN_HANDLER = regScreen("card_pile", new ExtendedScreenHandlerType<>(PileScreenHandler::new, ActiveSkillPayload.CODEC));

    private static <T extends class_1703> class_3917<T> regScreen(String id, class_3917<T> entry) {
        return class_2378.method_10226(class_7923.field_41187, id, entry);
    }

    public static final class_5321<class_1887> CRIT = class_5321.method_29179(class_7924.field_41265, class_2960.method_60654("dabaosword:crit"));
}
