package com.amotassic.dabaosword.item.skillcard.skills;

import com.amotassic.dabaosword.api.card.Suit;
import com.amotassic.dabaosword.api.skill.*;
import com.amotassic.dabaosword.command.DabaoSwordCommand;
import com.amotassic.dabaosword.damage_type.ModDT;
import com.amotassic.dabaosword.event.PlayerEvents;
import com.amotassic.dabaosword.item.ModItems;
import com.amotassic.dabaosword.item.card.CardItem;
import com.amotassic.dabaosword.item.skillcard.SkillItem;
import com.amotassic.dabaosword.ui.PlayerInvScreenHandler;
import com.google.common.collect.Multimap;
import dev.emi.trinkets.api.SlotReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1713;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5134;
import net.minecraft.class_5250;
import net.minecraft.class_6880;

import static com.amotassic.dabaosword.api.CardEvents.*;
import static com.amotassic.dabaosword.util.ModTools.*;
import static net.minecraft.class_124.*;

public class Wei {

    public static class Chengxiang extends SkillItem {
        @Override
        public void addTip(Skill skill, List<class_2561> tooltip) {
            tooltip.add(getTip("1", field_1078));
            tooltip.add(getTip("2", field_1078));
        }

        @Override
        public void addScreenTip(Skill skill, List<class_2561> tips) {
            addPresetTips(skill, tips, 0, 1, 2, 4);
            tips.add(class_2561.method_43471("chengxiang.screen.tip").method_27692(field_1076));
            super.addScreenTip(skill, tips);
        }

        @SkillInfo(trigger = Trigger.ON_HURT, relation = Relation.SELF)
        public int onHurt(class_1309 user, class_1309 target, Skill skill, ExData data) {
            if (!(user instanceof class_1657 pl)) return 0;
            class_1282 source = data.source; Float amount = data.amount;
            if (source.method_49708(ModDT.LOSEHP)) return 0;
            var nbt = skill.getNbt();
            float hurt = nbt.method_10583("hurt"); hurt += amount;
            if (hurt >= 7 && pl.method_5805()) {
                voice(pl, this);
                List<class_1799> stacks = new ArrayList<>();
                for (int i = 0; i < 13; i++) {
                    if (i < 9) stacks.add(class_1799.field_8037);
                    else stacks.add(newCard());
                }
                pl.method_6092(new class_1293(ModItems.INVULNERABLE, 200));
                openMenu(pl, pl, skill.stack, stacks, skill.toHoverableText());
            }
            while (hurt >= 7) hurt -= 7;
            nbt.method_10548("hurt", hurt); skill.setNbt(nbt);
            return 0;
        }

        @Override
        public void onSlotClick(PlayerInvScreenHandler handler, class_1657 player, Skill skill, class_1657 target, int slot, int button, class_1713 action) {
            int points = 0;
            for (var stack : handler.getSelected()) points += (c(stack).rank.ordinal() + 1);
            points += (c(handler.getStack(slot)).rank.ordinal() + 1);
            if (action == class_1713.field_7790) {
                if (points <= 13 && button == 0) handler.addClick(slot);
                if (button == 1) handler.dropClick(slot);
            }
        }

        @Override
        public void onGuiClose(PlayerInvScreenHandler handler, class_1657 player, Skill skill, class_1657 target) {
            if (handler.getSelectedCount() > 0) handler.toExData().forEachCard(3, (c, i) -> {
                give(player, c.toStack().method_46651(i));});
            else give(player, handler.getStack(9));
            player.method_6016(ModItems.INVULNERABLE);
        }
    }

    public static class Daoshu extends SkillItem implements DabaoSwordCommand.CSkill {
        @Override
        public void addTip(Skill skill, List<class_2561> tooltip) {
            int cd = skill.getCD();
            tooltip.add(class_2561.method_43470(cd == 0 ? "CD: 60s" : "CD: 60s   left: "+ cd +"s"));
            tooltip.add(getTip("1", field_1078));
            tooltip.add(getTip("2", field_1078));
        }

        @Override public boolean isActiveSkill() {return true;}

        @Override
        public boolean activeSkill(class_1657 user, Skill skill) {
            if (skill.getCD() == 0 && !user.method_5752().contains("seen_skill_tip")) {
                user.method_43496(class_2561.method_43469("active_skill.use.tip", skill.toHoverableText(), activeSkillText(user, skill)).method_27692(field_1065));
                user.method_5780("seen_skill_tip");
            } //主动技能使用提示
            return false;
        }

        @Override
        public boolean activeSkill(class_1657 user, Skill skill, class_1309 target) {
            user.method_5780("seen_skill_tip");
            triggerSkill(user, skill, target, 0); return false;
        }

        @Override @SuppressWarnings("DuplicatedCode")
        public void triggerSkill(class_1309 entity, Skill skill, class_1309 target, int value) {
            if (skill.getCD() > 0 || entity == target) return;
            if (!(entity instanceof class_1657 user) || !(target instanceof class_1657 tar)) return;
            if (countCards(tar) < 1) {
                user.method_7353(class_2561.method_43471("daoshu.target.no_card").method_27692(field_1061), true);
                return;
            }
            if (value == 0) {
                user.method_43496(class_2561.method_43469("select_a_suit", daoshuText(user, tar, Suit.Heart), daoshuText(user, tar, Suit.Diamond), daoshuText(user, tar, Suit.Spade), daoshuText(user, tar, Suit.Club)));
                return;
            }
            voice(user, this);
            List<class_1799> items = getItems(tar, isCard, true, false, false, true);
            var card = items.get(new Random().nextInt(items.size())); var c = c(card);
            class_2561 message = class_2561.method_43469("dabaosword.steal", user.method_5476(), tar.method_5476(), card.method_7954());
            user.method_43496(message); tar.method_43496(message);
            cardMove(tar, d().cards(card, 1), user);
            if (c.suit.ordinal() + 1 == value) {
                // 防止触发杀和闪
                user.method_5780("sha"); tar.method_6092(new class_1293(ModItems.COOLDOWN2, 1));
                tar.method_5643(user.method_48923().method_48812(user), 6);
            } else skill.setCD(60);
        }

        private class_5250 daoshuText(class_1657 user, class_1657 target, Suit suit) { //四种花色的提示
            return suit.suit.method_27694(style -> style.method_10958(new class_2558(class_2558.class_2559.field_11750, "/dabaosword " + user.method_5477().getString() + " dabaosword:daoshu " + target.method_5477().getString() + " " + (suit.ordinal() + 1)))).method_27692(suit.color);
        }
    }

    public static class Duanliang extends ConvertSkill {
        @Override
        public void addTip(Skill skill, List<class_2561> tooltip) {
            tooltip.add(getTip(field_1078));
        }

        @Override public Predicate<class_1799> getConvertFilter() {return isBlackCard.and(isArmoury.negate());}
        @Override public CardItem convert(class_1799 stack) {return ModItems.BINGLIANG_ITEM;}
    }

    public static class Fangzhu extends SkillItem {
        @Override
        public void addTip(Skill skill, List<class_2561> tooltip) {tooltip.add(getTip(field_1078));}

        @SkillInfo(trigger = Trigger.ON_HURT, relation = Relation.SELF)
        public int onHurt(class_1309 user, class_1309 target, Skill skill, ExData data) {
            var source = data.source; var amount = data.amount;
            if (source.method_5529() instanceof class_1309 attacker && user != attacker) {
                int i = attacker instanceof class_1657 ? (int) (20 * amount + 60) : 300;
                attacker.method_6092(new class_1293(ModItems.TURNOVER, i));
                voice(user, this);
            }
            return 0;
        }
    }

    public static class Ganglie extends SkillItem {
        @Override
        public void addTip(Skill skill, List<class_2561> tooltip) {
            tooltip.add(getTip("1", field_1078));
            tooltip.add(getTip("2", field_1078));
        }

        @SkillInfo(trigger = Trigger.ON_HURT, relation = Relation.SELF)
        public int onHurt(class_1309 user, class_1309 entity, Skill skill, ExData data) {
            var source = data.source; var amount = data.amount;
            if (source.method_5529() instanceof class_1309 attacker && user != attacker) {
                voice(user, this);
                for (int i = 0; i < amount; i += 5) {
                    if (new Random().nextFloat() < 0.5) { //造成伤害
                        user.method_5780("sha"); //以此造成伤害不自动触发杀
                        float f = i + 5 < amount ? 5 : amount - i;
                        attacker.field_6008 = 0; attacker.method_5643(user.method_48923().method_48812(user), f);
                    } else { //弃牌
                        if (attacker instanceof class_1657 target) { //如果来源是玩家则弃牌
                            List<class_1799> candidate = getItems(target, isCard, true, false, true, true);
                            if (!candidate.isEmpty()) {
                                class_1799 chosen = candidate.get(new Random().nextInt(candidate.size()));
                                class_2561 message = class_2561.method_43469("dabaosword.discard", user.method_5476(), target.method_5476(), chosen.method_7954());
                                if (user instanceof class_1657 player) player.method_43496(message);
                                target.method_43496(message);
                                var cData = d().cards(chosen, 1, isEquipped(attacker, s -> s.equals(chosen)));
                                cardDiscard(target, cData);
                            }
                        } else { //如果来源不是玩家则随机弃置它的主副手物品和装备
                            List<class_1799> candidate = getItems(attacker, s -> !s.method_7960(), true, false, true, false);
                            if (!candidate.isEmpty()) {
                                class_1799 chosen = candidate.get(new Random().nextInt(candidate.size()));
                                if (isCard(chosen)) {
                                    var cData = d().cards(chosen, 1, isEquipped(attacker, s -> s.equals(chosen)));
                                    cardDiscard(attacker, cData);
                                }
                                else chosen.method_7934(1);
                            }
                        }
                    }
                }
            }
            return 0;
        }
    }

    public static class Gongao extends SkillItem {
        @Override
        public void addTip(Skill skill, List<class_2561> tooltip) {
            tooltip.add(getTip("1", field_1078));
            tooltip.add(getTip("2", field_1078));
        }

        @Override public boolean lockOn() {return true;}

        @Override public boolean shouldTickUpdate() {return true;}

        @Override
        public void tickSkill(Skill skill, class_1309 entity) {
            if (entity.method_37908().method_8510() % 600 == 0 && entity instanceof class_1657 player) { // 每30s触发扣体力上限
                int extraHP = skill.getTag();
                if (extraHP >= 5 && !player.method_7337() && !player.method_7325()) {
                    draw(player, 2);
                    skill.setTag(extraHP - 5);
                    voice(player, "weizhong");
                }
            }
        }

        @Override
        public Multimap<class_6880<class_1320>, class_1322> getModifiers(class_1799 stack, SlotReference slot, class_1309 entity, class_2960 slotIdentifier) {
            var modifiers = super.getModifiers(stack, slot, entity, slotIdentifier);
            modifiers.put(class_5134.field_23716, new class_1322(slotIdentifier, s(stack).getTag(), class_1322.class_1323.field_6328));
            return modifiers;
        }

        @SkillInfo(trigger = Trigger.ON_DEATH, relation = Relation.KILLER)
        public int onKill(class_1309 user, class_1309 target, Skill skill, ExData data) {
            int extraHP = skill.getTag();
            int i = target instanceof class_1657 ? 5 : target instanceof class_1588 ? 1 : 0;
            if (i > 0) {
                extraHP += i;
                user.method_6025(i);
                voice(user, this);
            }
            skill.setTag(extraHP);
            return 0;
        }
    }

    public static class Jianxiong extends SkillItem {
        @Override
        public void addTip(Skill skill, List<class_2561> tooltip) {
            tooltip.add(class_2561.method_43470("CD: 15s"));
            tooltip.add(getTip("1", field_1078));
            tooltip.add(getTip("2", field_1078));
        }

        @SkillInfo(trigger = Trigger.ON_HURT, relation = Relation.SELF)
        public int onHurt(class_1309 user, class_1309 target, Skill skill, ExData data) {
            var source = data.source;
            if (source.method_5529() instanceof class_1297 && !user.method_6059(ModItems.COOLDOWN)) {
                voice(user, this);
                draw(user);
                user.method_6092(new class_1293(ModItems.COOLDOWN, 20 * 15,0,false,false,true));
            }
            return 0;
        }

        @SkillInfo(trigger = Trigger.HURT_BY_CARD, relation = Relation.SELF)
        public int hurtByCard(class_1309 user, class_1309 target, Skill skill, ExData data) {
            if (skill.getCD() == 0) {
                voice(user, this);
                skill.setCD(15);
                give(user, data.getFirst().toStack().method_46651(1));
            }
            return 0;
        }
    }

    public static class Jueqing extends SkillItem {
        @Override
        public void addTip(Skill skill, List<class_2561> tooltip) {
            tooltip.add(getTip("1", field_1078));
            tooltip.add(getTip("2", field_1078));
        }

        @Override public boolean lockOn() {return true;}

        @SkillInfo(trigger = Trigger.CANCEL_DAMAGE_LOWEST, relation = Relation.ATTACKER_SELF)
        public int onHit(class_1309 user, class_1309 target, Skill skill, ExData data) {
            var amount = data.amount;
            target.method_5643(ModDT.loseHP(user), Math.min(Math.max(7, target.method_6063() / 3), amount));
            voice(user, this, 1);
            return 1;
        }
    }

    public static class Luoshen extends SkillItem {
        @Override
        public void addTip(Skill skill, List<class_2561> tooltip) {tooltip.add(getTip(field_1078));}

        @Override
        public int onDrawPhase(class_1657 player, Skill skill) {
            voice(player, this);
            while (true) {
                var card = newCard();
                player.method_37908().method_18456().forEach(p -> p.method_43496(class_2561.method_43469("item.dabaosword.luoshen.result", player.method_5476(), card.method_7954())));
                if (isBlackCard.test(card)) give(player, card);
                else break;
            }
            return 0;
        }
    }

    public static class Luoyi extends SkillItem {
        @Override
        public void addTip(Skill skill, List<class_2561> tooltip) {tooltip.add(getTip(field_1078));}

        @Override public boolean lockOn() {return true;}

        @Override public boolean shouldTickUpdate() {return true;}

        @Override
        public Multimap<class_6880<class_1320>, class_1322> getModifiers(class_1799 stack, SlotReference slot, class_1309 entity, class_2960 slotIdentifier) {
            var modifiers = super.getModifiers(stack, slot, entity, slotIdentifier);
            int luoyi = entity.method_5752().contains("duanchang") ? 0 : getEmptyArmorSlot(entity) + 1;
            modifiers.put(class_5134.field_23721, new class_1322(slotIdentifier, luoyi, class_1322.class_1323.field_6328));
            return modifiers;
        }

        @Override
        public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
            if (!world.field_9236 && !user.method_5715()) voice(user, this);
            return super.method_7836(world, user, hand);
        }

        private int getEmptyArmorSlot(class_1309 entity) {
            int i = 0;
            for (var slot : entity.method_5661()) {if (slot.method_7960()) i++;}
            return i;
        }
    }

    public static class Qice extends SkillItem {
        @Override
        public void addTip(Skill skill, List<class_2561> tooltip) {
            int cd = skill.getCD();
            tooltip.add(class_2561.method_43470(cd == 0 ? "CD: 20s" : "CD: 20s   left: "+ cd +"s"));
            tooltip.add(getTip(field_1078));
        }

        @Override public boolean isActiveSkill() {return true;}

        @Override
        public boolean activeSkill(class_1657 user, Skill skill) {
            if (skill.getCD() == 0) {
                if (countCards(user) > 0) {

                    class_1792[] items = {ModItems.BINGLIANG_ITEM, ModItems.TOO_HAPPY_ITEM, ModItems.DISCARD, ModItems.FIRE_ATTACK, ModItems.JIEDAO, ModItems.JUEDOU, ModItems.NANMAN, ModItems.STEAL, ModItems.TAOYUAN, ModItems.TIESUO, ModItems.WANJIAN, ModItems.WUXIE, ModItems.WUGU, ModItems.WUZHONG};
                    var stacks = Arrays.stream(items).map(class_1799::new).toList();

                    openMenu(user, user, skill.stack, stacks, class_2561.method_43471("item.dabaosword.qice.screen"));
                    return true;
                } else user.method_7353(class_2561.method_43471("item.dabaosword.qice.tip").method_27692(field_1061), true);
            } else user.method_7353(class_2561.method_43471("dabaosword.cooldown").method_27692(field_1061), true);
            return false;
        }

        @Override
        public void onSlotClick(PlayerInvScreenHandler handler, class_1657 player, Skill skill, class_1657 target, int slot, int button, class_1713 action) {
            var selected = handler.getStack(slot);
            if (!player.method_7337()) {
                while (countCards(player) > 0) {cardDecrement(player, getCard(player, isCard), 64);}
                skill.setCD(20);
            }
            give(player, selected);
            voice(player, this);
            closeGUI(player);
        }
    }

    public static class Qingguo extends ConvertSkill {
        @Override
        public void addTip(Skill skill, List<class_2561> tooltip) {
            tooltip.add(getTip(field_1078));
        }

        @Override public Predicate<class_1799> getConvertFilter() {return isBlackCard;}
        @Override public CardItem convert(class_1799 stack) {return ModItems.SHAN;}
    }

    public static class Quanji extends SkillItem {
        @Override
        public void addTip(Skill skill, List<class_2561> tooltip) {
            tooltip.add(class_2561.method_30163("权：" + skill.getTag()));
            tooltip.add(getTip("1", field_1078));
            tooltip.add(getTip("2", field_1078));
        }

        @Override
        public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
            if (!world.field_9236 && !user.method_5715()) voice(user, "zili");
            return super.method_7836(world, user, hand);
        }

        @SkillInfo(trigger = Trigger.ON_HURT, relation = Relation.SELF)
        public int onHurt(class_1309 user, class_1309 target, Skill skill, ExData data) {
            if (data.source.method_5529() instanceof class_1309) {
                skill.setTag(skill.getTag() + 1);
                voice(user, this);
            }
            return 0;
        }

        @SkillInfo(trigger = Trigger.MODIFY_DAMAGE, relation = Relation.DIRECT_ATTACKER)
        public int onHit(class_1309 user, class_1309 target, Skill skill, ExData data) {
            var adds = data.adds;
            int quan = skill.getTag();
            if (quan > 0) {
                if (quan > 4) draw(target);
                skill.setTag(quan/2);
                voice(user, "paiyi");
                adds.add((float) quan);
            }
            return 0;
        }
    }

    public static class Shanzhuan extends SkillItem {
        @Override
        public void addTip(Skill skill, List<class_2561> tooltip) {
            tooltip.add(class_2561.method_43470("CD: 8s"));
            tooltip.add(getTip("1", field_1078));
            tooltip.add(getTip("2", field_1078));
        }

        //擅专：我言既出，谁敢不从！
        @SkillInfo(trigger = Trigger.ON_HURT, relation = Relation.ATTACKER)
        public int onHit(class_1309 user, class_1309 entity, Skill skill, ExData data) {
            if (user instanceof class_1657 player && !user.method_6059(ModItems.COOLDOWN)) {
                if (entity instanceof class_1657 target) {
                    if (countAllCards(target) > 0) openInv(player, target, target, class_2561.method_43469("dabaosword.discard.title", skill.toHoverableText()), skill.stack, true, false, 1);
                } else {
                    voice(user, this);
                    if (new Random().nextFloat() < 0.5) {
                        entity.method_6092(new class_1293(ModItems.BINGLIANG, -1,1));
                    } else entity.method_6092(new class_1293(ModItems.TOO_HAPPY, 20 * 5));
                    user.method_6092(new class_1293(ModItems.COOLDOWN, 20 * 5,0,false,false,true));
                }
            }
            return 0;
        }

        @Override
        public void onSlotClick(PlayerInvScreenHandler handler, class_1657 player, Skill skill, class_1657 target, int slot, int button, class_1713 action) {
            var selected = handler.getStack(slot);
            voice(player, this);
            if (isRedCard.test(selected)) target.method_6092(new class_1293(ModItems.TOO_HAPPY, 20 * 5));
            else target.method_6092(new class_1293(ModItems.BINGLIANG, -1,1));
            class_2561 message = class_2561.method_43469("dabaosword.discard", player.method_5476(), target.method_5476(), selected.method_7954());
            player.method_43496(message);
            target.method_43496(message);
            var data = d().cards(selected, 1, slot < 4);
            cardDiscard(target, data);
            player.method_6092(new class_1293(ModItems.COOLDOWN, 20 * 12,0,false,false,true));
            closeGUI(player);
        }
    }

    public static class Shensu extends SkillItem {
        @Override
        public void addTip(Skill skill, List<class_2561> tooltip) {
            tooltip.add(getTip("1", field_1078));
            tooltip.add(getTip("2", field_1078));
        }

        @SkillInfo(trigger = Trigger.MODIFY_DAMAGE, relation = Relation.DIRECT_ATTACKER)
        public int onHit(class_1309 user, class_1309 target, Skill skill, ExData data) {
            var muls = data.muls;
            if (!user.method_6059(ModItems.COOLDOWN)) {
                float walkSpeed = 4.317f;
                float speed = skill.getNbt().method_10583("speed");
                if (speed > walkSpeed) {
                    float m = (speed - walkSpeed) / walkSpeed / 2;
                    user.method_6092(new class_1293(ModItems.COOLDOWN, (int) (5 * 20 * m),0,false,false,true));
                    if (user instanceof class_1657 player) player.method_7353(class_2561.method_43469("shensu.info", speed, m), true);
                    voice(user, this);
                    muls.add(m);
                }
            }
            return 0;
        }

        @Override
        public Multimap<class_6880<class_1320>, class_1322> getModifiers(class_1799 stack, SlotReference slot, class_1309 entity, class_2960 slotIdentifier) {
            var modifiers = super.getModifiers(stack, slot, entity, slotIdentifier);
            double d = 0;
            if (entity instanceof class_1657 player && !player.method_5752().contains("duanchang")) {
                d = Math.min(getEmptySlots(player), 20d) / 40; //当空余20格时，获得最大加成0.5
            }
            modifiers.put(class_5134.field_23719, new class_1322(slotIdentifier, d, class_1322.class_1323.field_6331));
            return modifiers;
        }

        private int getEmptySlots(class_1657 player) {
            int i = 0;
            for (var slot : player.method_31548().field_7547) {if (slot.method_7960()) i++;}
            return i;
        }
    }

    public static class Yiji extends SkillItem {
        @Override
        public void addTip(Skill skill, List<class_2561> tooltip) {
            tooltip.add(class_2561.method_43470("CD: 20s"));
            tooltip.add(getTip(field_1078));
            tooltip.add(getTip("2", field_1078));
        }

        @Override public boolean isActiveSkill() {return true;}

        @Override
        public void addScreenTip(Skill skill, List<class_2561> tips) {
            addPresetTips(skill, tips, 0, 1, 2, 4, 5);
            super.addScreenTip(skill, tips);
        }

        @SkillInfo(trigger = Trigger.ON_HURT, relation = Relation.SELF)
        public int onHurt(class_1309 user, class_1309 target, Skill skill, ExData data) {
            if (data.source.method_49708(ModDT.LOSEHP)) return 0;
            if (!user.method_6059(ModItems.COOLDOWN) && user.method_6032() <= 15) {
                draw(user, 2);
                user.method_6092(new class_1293(ModItems.COOLDOWN, 20 * 20, 0, false, false, true));
                skill.setTag(2);
                voice(user, this);
            }
            return 0;
        }

        @Override
        public boolean activeSkill(class_1657 user, Skill skill, class_1309 entity) {
            if (entity instanceof class_1657 target) {
                int i = skill.getTag();
                if (i <= 0) return false;
                skill.setMaxSelect(i);
                openInv(user, user, target, class_2561.method_43469("give_card.title", skill.toHoverableText()), skill.stack, false, false, 2);
                return true;
            }
            return false;
        }

        @Override
        public void onGuiClose(PlayerInvScreenHandler handler, class_1657 player, Skill skill, class_1657 target) {
            int count = handler.getSelectedCount();
            if (count == 0) return;
            voice(player, this);
            class_2561 message = class_2561.method_43469("give_card.tip", player.method_5476(), skill.toHoverableText(), target.method_5476(), count);
            target.method_43496(message);
            player.method_43496(message);
            skill.setTag(skill.getTag() - count);
            cardMove(player, handler.toExData(), target);
        }
    }

    public static class Xingshang extends SkillItem {
        @Override
        public void addTip(Skill skill, List<class_2561> tooltip) {tooltip.add(getTip(field_1078));}

        @SkillInfo(trigger = Trigger.ON_DEATH, relation = Relation.NOT_SELF)
        public int playerDie(class_1309 user, class_1309 entity, Skill skill, ExData data) {
            if (entity instanceof class_1657 target && user.method_5739(target) <= 30) {
                voice(user, this);
                cardMove(target, PlayerEvents.cardsToDrop(target), user);
            }
            return 0;
        }
    }
}
