package com.amotassic.dabaosword.pvpgame;

import com.amotassic.dabaosword.api.event.PVPGameTickCallback;
import com.amotassic.dabaosword.event.PVPGameEvents;
import com.amotassic.dabaosword.util.ModConfig;
import java.util.*;
import java.util.function.Consumer;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1934;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;

import static com.amotassic.dabaosword.util.ModTools.title;
import static com.amotassic.dabaosword.util.ModTools.voice;

public class Game {
    private final class_3218 world;
    private final int id;
    private final Set<UUID> players = new HashSet<>();
    private final int type;
    private boolean active;
    private int countDown;
    private int gameTime;
    private int timeOut;
    //列举各项数据
    public int zhongLives, fanLives, neiLives;
    public int zhongScore, fanScore, neiScore;
    private Map<String, Integer> primaryDataCache;
    public static final String FANCOUNT = "fanCount", NEICOUNT = "neiCount", ZHONGCOUNT = "zhongCount", ZHONGLIVES = "zhongLives", FANLIVES = "fanLives", NEILIVES = "neiLives";

    public Game(int id, class_3218 world, Set<UUID> players, int type) {
        this.world = world;
        this.id = id;
        this.players.addAll(players);
        this.type = type;
        this.active = true;
        int waitTime = ModConfig.WaitTime > 5 ? ModConfig.WaitTime : 5;
        this.countDown = waitTime * 20;
        this.gameTime = 0;
        this.timeOut = ModConfig.TimeOut;
        initData();
    }

    public Game(class_3218 world, class_2487 nbt) {
        this.world = world;
        this.id = nbt.method_10550("Id");
        class_2499 nbtList = nbt.method_10554("Players", class_2520.field_33261);
        for (class_2520 nbtElement : nbtList) {
            this.players.add(class_2512.method_25930(nbtElement));
        }
        this.type = nbt.method_10550("Type");
        this.active = nbt.method_10577("Active");
        this.countDown = nbt.method_10550("CountDown");
        this.gameTime = nbt.method_10550("GameTime");
        this.timeOut = nbt.method_10550("TimeOut");
        this.zhongLives = nbt.method_10550("ZhongLives");
        this.fanLives = nbt.method_10550("FanLives");
        this.neiLives = nbt.method_10550("NeiLives");
        this.zhongScore = nbt.method_10550("ZhongScore");
        this.fanScore = nbt.method_10550("FanScore");
        this.neiScore = nbt.method_10550("NeiScore");
    }

    public Map<String, Integer> getPrimaryData() {
        if (primaryDataCache != null) return primaryDataCache;

        Map<String, Integer> data = new HashMap<>();
        int playerCount = getPlayers().size();
        int fanCount = playerCount / 2;
        int neiCount = playerCount > 2 ? 1 : 0; //如果是无内奸模式，参与人数为偶数时，不设置内奸
        if (this.type == 1 && playerCount % 2 == 0) neiCount = 0;
        int zhongCount = playerCount - fanCount - neiCount;
        int zhongLives, fanLives, neiLives;
        zhongLives = fanLives = fanCount * 3;
        neiLives = neiCount > 0 ? fanCount * 3 : 0;
        data.put(FANCOUNT, fanCount); data.put(NEICOUNT, neiCount); data.put(ZHONGCOUNT, zhongCount);
        data.put(ZHONGLIVES, zhongLives); data.put(FANLIVES, fanLives); data.put(NEILIVES, neiLives);
        primaryDataCache = data;
        return data;
    }

    private void initData() {
        //根据人数随机分配身份
        var primaryData = getPrimaryData();
        List<String> ids = new ArrayList<>();
        for (int i = 0; i < primaryData.get(ZHONGCOUNT); i++) ids.add(Identity.ZHONG.tag);
        for (int i = 0; i < primaryData.get(FANCOUNT); i++) ids.add(Identity.FAN.tag);
        for (int i = 0; i < primaryData.get(NEICOUNT); i++) ids.add(Identity.NEI.tag);
        Collections.shuffle(ids); // 随机打乱列表中的元素
        forEachPlayer(player -> { //确保移除所有的身份标签再添加新的身份标签
            player.method_5752().remove("dabaosword.zhong");
            player.method_5752().remove("dabaosword.fan");
            player.method_5752().remove("dabaosword.nei");
            player.method_5780(ids.removeFirst());
        });
        this.zhongLives = primaryData.get(ZHONGLIVES);
        this.fanLives = primaryData.get(FANLIVES);
        this.neiLives = primaryData.get(NEILIVES);
        this.zhongScore = this.fanScore = this.neiScore = 0;
    }

    public void writeNbt(class_2487 nbt) {
        nbt.method_10569("Id", this.id);
        class_2499 nbtList = new class_2499();
        for (UUID uuid : this.players) nbtList.add(class_2512.method_25929(uuid));
        nbt.method_10566("Players", nbtList);
        nbt.method_10569("Type", this.type);
        nbt.method_10556("Active", this.active);
        nbt.method_10569("CountDown", this.countDown);
        nbt.method_10569("GameTime", this.gameTime);
        nbt.method_10569("TimeOut", this.timeOut);
        nbt.method_10569("ZhongLives", this.zhongLives);
        nbt.method_10569("FanLives", this.fanLives);
        nbt.method_10569("NeiLives", this.neiLives);
        nbt.method_10569("ZhongScore", this.zhongScore);
        nbt.method_10569("FanScore", this.fanScore);
        nbt.method_10569("NeiScore", this.neiScore);
    }

    public boolean isPlayerInThisGame(class_1657 player) {
        return this.players.contains(player.method_5667());
    }

    public int getGameId() {return id;}

    /**游戏被加载，不论是等待中还是已经开始*/
    public boolean isActive() {return active;}

    public Set<UUID> getPlayers() {return players;}

    /**游戏处于准备阶段倒计时，此时玩家可以拒绝加入游戏*/
    public boolean isWaiting() {return countDown > 0;}

    public int getCountDown() {return countDown;}

    public int getGameTime() {return gameTime;}

    public int getTimeOut() {return timeOut;}

    /**游戏已经开始，且不处于准备阶段*/
    public boolean isOn() {return getGameTime() > 0;}

    public void refuseGame(class_1657 player) {
        if (!isWaiting()) return;
        discardGame();
        forEachPlayer(p -> {
            p.method_43496(class_2561.method_43469("dabaosword.game.refuse", player.method_5476()).method_27692(class_124.field_1061));
            voice(p, class_3417.field_15239);
        });
    }

    public void win(Identity identity) {
        forEachPlayer(player -> {
            if (getIdentity(player) == identity) {
                voice(player, "win");
                title(player, class_2561.method_43471("dabaosword.game.win").method_27692(class_124.field_1065));
            }
            player.method_43496(class_2561.method_43469("dabaosword.game.end", class_2561.method_43471(identity.tag)).method_27692(getIdentityColor(identity)));
        });
        discardGame();
    }

    public void timeOut() {
        forEachPlayer(player -> player.method_43496(class_2561.method_43471("dabaosword.game.timeout").method_27692(class_124.field_1061)));
        Integer max = findUniqueMax(zhongScore, fanScore, neiScore);
        if (max == null) discardGame();
        else if (zhongScore == max) win(Identity.ZHONG);
        else if (fanScore == max) win(Identity.FAN);
        else if (neiScore == max) win(Identity.NEI);
    }

    public void discardGame() {
        this.active = false;
        var scoreboard = world.method_8503().method_3845();
        var obj = scoreboard.method_1151().stream().filter(o -> o.method_1113().equals("dabaosword.death")).findFirst().orElse(null);
        if (obj != null && PVPGameEvents.getGameManager().getGameCount() <= 1) scoreboard.method_1194(obj);
        forEachPlayer(player -> {
            player.method_5752().remove("dabaosword.zhong");
            player.method_5752().remove("dabaosword.fan");
            player.method_5752().remove("dabaosword.nei");
            if (player.method_7325()) {
                player.method_7336(class_1934.field_9215); player.method_5768();
            }
        });
    }

    public void tick() {
        if (!this.active) return;
        PVPGameTickCallback.EVENT.invoker().onGameTick(this, world);
        //倒计时为-1时，游戏开始计时
        if (this.countDown > -1) --this.countDown; else ++this.gameTime;
        if (isOn() && getGameTime() % 20 == 0) --this.timeOut;
    }

    public void forEachPlayer(Consumer<class_3222> action) {
        for (UUID uuid : getPlayers()) {
            class_3222 player = world.method_8503().method_3760().method_14602(uuid);
            if (player == null) continue;
            action.accept(player);
        }
    }

    public int getRespawnChances(Identity identity) {
        var data = getPrimaryData();
        return switch (identity) {
            case ZHONG -> zhongLives - data.get(ZHONGCOUNT) + 1;
            case FAN -> fanLives - data.get(FANCOUNT) + 1;
            case NEI -> neiLives - data.get(NEICOUNT) + 1;
        };
    }

    public int getLives(Identity identity) {
        return switch (identity) {
            case ZHONG -> zhongLives;
            case FAN -> fanLives;
            case NEI -> neiLives;
        };
    }

    public void setLives(Identity identity, int lives) {
        switch (identity) {
            case ZHONG -> zhongLives = lives;
            case FAN -> fanLives = lives;
            case NEI -> neiLives = lives;
        }
    }

    /**减少该玩家所在队伍的剩余生命数（等于0不会减少），玩家死亡时调用*/
    public void decreaseLives(class_3222 player) {
        Identity identity = getIdentity(player);
        int lives = getLives(identity);
        if (lives > 0) setLives(identity, lives - 1);
    }

    public int getScore(Identity identity) {
        return switch (identity) {
            case ZHONG -> zhongScore;
            case FAN -> fanScore;
            case NEI -> neiScore;
        };
    }

    public void setScore(Identity identity, int score) {
        switch (identity) {
            case ZHONG -> zhongScore = score;
            case FAN -> fanScore = score;
            case NEI -> neiScore = score;
        }
    }

    /**增加该玩家所在队伍的分数，同时向所有玩家播报分数*/
    public void increaseScore(class_3222 player) {
        Identity identity = getIdentity(player);
        setScore(identity, getScore(identity) + 1);
        this.timeOut = ModConfig.TimeOut;
        forEachPlayer(p -> p.method_43496(class_2561.method_43469("dabaosword.score.add", player.method_5476()).method_27692(class_124.field_1067)));
    }

    /**确保玩家在该对局中才可以调用本方法*/
    public Identity getIdentity(class_3222 player) {
        if (player.method_5752().contains(Identity.ZHONG.tag)) return Identity.ZHONG;
        if (player.method_5752().contains(Identity.FAN.tag)) return Identity.FAN;
        return Identity.NEI;
    }

    public static Integer findUniqueMax(int... numbers) {
        if (numbers.length == 0) return null;
        int max = numbers[0];
        boolean isUnique = true;
        for (int i = 1; i < numbers.length; i++) {
            if (numbers[i] > max) {
                max = numbers[i];
                isUnique = true;
            } else if (numbers[i] == max) {isUnique = false;}
        }
        return isUnique ? max : null;
    }

    public static class_124 getIdentityColor(Identity identity) {
        return switch (identity) {
            case ZHONG -> class_124.field_1054;
            case FAN -> class_124.field_1060;
            case NEI -> class_124.field_1078;
        };
    }

    public enum Identity {
        ZHONG("dabaosword.zhong"),
        FAN("dabaosword.fan"),
        NEI("dabaosword.nei");

        public final String tag;

        Identity(String tag) {
            this.tag = tag;
        }
    }
}
