package com.amotassic.dabaosword.ui;

import com.amotassic.dabaosword.api.CardEvents;
import com.amotassic.dabaosword.api.skill.ExData;
import com.amotassic.dabaosword.api.skill.Skill;
import com.amotassic.dabaosword.item.ModItems;
import com.amotassic.dabaosword.network.OpenScreenPayload;
import com.amotassic.dabaosword.util.TempInventory;
import com.mojang.datafixers.util.Pair;
import java.util.*;
import java.util.function.Consumer;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;

import static com.amotassic.dabaosword.api.CardEvents.cardDiscard;
import static com.amotassic.dabaosword.util.ModTools.*;
import static net.minecraft.class_1723.*;

public class PlayerInvScreenHandler extends class_1703 {
    private final class_1657 target;
    private final TempInventory inv;
    private final class_1799 stack;
    private final Skill skill;
    private final List<Integer> clicks = new ArrayList<>();
    public final int rows;

    public PlayerInvScreenHandler(int syncId, class_1661 inv, OpenScreenPayload buf) {
        this(syncId, new TempInventory(inv.field_7546, paibei(), List.of()), (class_1657) inv.field_7546.method_37908().method_8469(buf.id()), stringToSet(buf.str()));
    }
    private static Set<Integer> stringToSet(String str) {
        String trimmed = str.substring(1, str.length() - 1);
        String[] parts = trimmed.split(", ");
        Set<Integer> set = new HashSet<>();
        for (String part : parts) if (!part.isEmpty()) set.add(Integer.parseInt(part));
        return set;
    }

    public PlayerInvScreenHandler(int syncId, TempInventory inventory, class_1657 target, Set<Integer> rowsToShow) {
        super(ModItems.PLAYER_INV_SCREEN_HANDLER, syncId);
        this.target = target;
        this.inv = inventory;
        this.stack = inv.method_5438(81);
        this.skill = s(stack);
        this.rows = rowsToShow.size();
        int line = 0;
        for (int j = 0; j < 9; j++) {
            if (rowsToShow.contains(j)) {
                if (j == 0) {
                    for (int i = 0; i < 4; ++i) method_7621(new class_1735(inv, i, 8 + i * 18, 18));
                    method_7621(new class_1735(inv, 4, 8 + 4 * 18, 18) {
                        public Pair<class_2960, class_2960> method_7679() {
                            return Pair.of(field_21668, field_21669);
                        }
                    });
                    method_7621(new class_1735(inv, 5, 8 + 5 * 18, 18) {
                        public Pair<class_2960, class_2960> method_7679() {
                            return Pair.of(field_21668, field_21670);
                        }
                    });
                    method_7621(new class_1735(inv, 6, 8 + 6 * 18, 18) {
                        public Pair<class_2960, class_2960> method_7679() {
                            return Pair.of(field_21668, field_21671);
                        }
                    });
                    method_7621(new class_1735(inv, 7, 8 + 7 * 18, 18) {
                        public Pair<class_2960, class_2960> method_7679() {
                            return Pair.of(field_21668, field_21672);
                        }
                    });
                    method_7621(new class_1735(inv, 8, 8 + 8 * 18, 18) {
                        public Pair<class_2960, class_2960> method_7679() {
                            return Pair.of(field_21668, field_21673);
                        }
                    });
                }
                else {
                    for (int i = 0; i < 9; ++i) method_7621(new class_1735(inv, i + j * 9, 8 + i * 18, 18 + line * 18));
                }
                line++;
            } else {
                for (int i = 0; i < 9; ++i) method_7621(new class_1735(inv, i + j * 9, 114514, 114514));
            }
        }
        inv.method_5447(82, paibei());
        for (int i = 0; i < 2; i++) method_7621(new class_1735(inv, 81 + i, 114514, 114514));
    }

    @Override
    public void method_7593(int index, int button, class_1713 action, class_1657 player) {
        if (index >= 0 && index < 81 && !player.method_37908().field_9236) {
            //System.out.println(index + " button: " + button + " action: " + action);
            var selected = getStack(index);
            if (button == 65 && maxSelect() >= 100) forEachNonEmptySlot(s -> addClick(s.method_34266(), 99)); //全选
            if (button == 90) forEachNonEmptySlot(s -> setClick(s.method_34266(), 0)); //清空
            if (!selected.method_7960()) skill.item.onSlotClick(this, player, skill, target, index, button, action);
            writeClicks();

            if (stack.method_7960()) {
                boolean right = action == class_1713.field_7790 && button == 1;
                class_1799 toReplace = right ? player.method_6047() : player.method_6079();
                var mainCopy = toReplace.method_7972(); var copy = selected.method_7972();

                if (!selected.method_7960() && !class_1799.method_7973(toReplace, selected)) {
                    toReplace.method_7939(0); selected.method_7939(0);
                    if (index >= 45) getCardPack(player).method_5441(index - 45);
                    player.method_6122(right ? class_1268.field_5808 : class_1268.field_5810, copy);
                    give(player, mainCopy);
                } closeGUI(player);
            }

            if (!selected.method_7960()) {
                if (stack.method_31574(ModItems.STEAL)) {
                    class_2561 message = class_2561.method_43469("dabaosword.steal", player.method_5476(), target.method_5476(), selected.method_7954());
                    player.method_43496(message);
                    target.method_43496(message);
                    if (isCard(selected)) { //如果选择的物品是卡牌才触发事件
                        var exData = d().cards(selected, 1, index < 4);
                        CardEvents.cardMove(target, exData, player);
                    } else {
                        give(player, selected.method_46651(1)); /*顺手：复制一个物品*/
                        selected.method_7934(1);
                    }
                    closeGUI(player);
                }

                if (stack.method_31574(ModItems.DISCARD)) {
                    class_2561 message = class_2561.method_43469("dabaosword.discard", player.method_5476(), target.method_5476(), selected.method_7954());
                    player.method_43496(message);
                    target.method_43496(message);
                    var exData = d().cards(selected, 1, index < 4);
                    cardDiscard(target, exData);
                    closeGUI(player);
                }
            }
        }
    }

    @Override
    public void method_7595(class_1657 player) {skill.item.onGuiClose(this, player, skill, target);}

    /**获取该容器内对应slot上的物品，即使卡牌以牌背形态显示，也返回目标对应的卡牌*/
    public class_1799 getStack(int slot) {
        if (slot < 0 || slot > 80) return class_1799.field_8037;
        var item = inv.method_5438(slot);
        if (inv.type == 1 && item.method_31574(ModItems.GAIN_CARD) && inv.owner instanceof class_1657 pl) {
            if (slot < 45) return pl.method_31548().field_7547.get(slot - 9);
            else return getCardPack(pl).cards.get(slot - 45);
        }
        return item;
    }

    @Override
    public class_1799 method_7601(class_1657 player, int invSlot) {return class_1799.field_8037;}

    @Override
    public boolean method_7597(class_1657 player) {
        var effect = player.method_6112(ModItems.COOLDOWN2);
        return effect == null || effect.method_5578() != 2;
    }

    public void forEachNonEmptySlot(Consumer<class_1735> action) {
        for (int i = 0; i < 81; i++) {
            class_1735 slot = method_7611(i);
            if (slot.method_7681()) action.accept(slot);
        }
    }

    private void writeClicks() {
        class_1799 cinfo = method_7611(82).method_7677();
        class_2487 nbt = new class_2487();
        nbt.method_10582("Clicks", getClickMap().toString());
        setNbt(cinfo, nbt);
    }

    public int maxSelect() {return skill.getMaxSelect();}

    private int getSlotClicked(int slot) {
        if (!clicks.contains(slot)) return 0;
        return getClickMap().get(slot);
    }

    /**使点击的槽位物品选择数量增加，如果增加后已选择物品数量大于最大可选数量，会自动移除最早的选择项*/
    public void addClick(int slot, int... count) {
        int num = count.length > 0 ? count[0] : 1;
        int n = method_7611(slot).method_7677().method_7947();
        num = Math.min(n - getSlotClicked(slot), num);
        for (int i = 0; i < num; i++) {
            clicks.add(slot);
            if (getSelectedCount() > maxSelect()) dropFirst();
        }
    }

    /**使点击的槽位物品选择数量减少*/
    public void dropClick(int slot, int... count) {
        if (!clicks.contains(slot)) return;
        int num = count.length > 0 ? count[0] : 1;
        for (int i = 0; i < num; i++) {
            if (!clicks.remove(Integer.valueOf(slot))) break;
        }
    }

    /**设置该槽位的选择数*/
    public void setClick(int slot, int count) {
        if (clicks.contains(slot)) dropClick(slot, 114514);
        if (count > 0) addClick(slot, count);
    }

    public void dropFirst(int... count) {
        if (clicks.isEmpty()) return;
        dropClick(clicks.getFirst(), count);
    }

    /**@return GUI中已选择卡牌的数量*/
    public int getSelectedCount() {return clicks.size();}

    public List<class_1799> getSelected() {
        List<class_1799> selected = new ArrayList<>();
        clicks.forEach(slot -> {
            class_1799 stack = method_7611(slot).method_7677();
            if (!stack.method_7960()) selected.add(stack.method_46651(1));
        });
        return selected;
    }

    public Map<Integer, Integer> getClickMap() {
        Map<Integer, Integer> map = new HashMap<>();
        for (Integer num : clicks) {
            if (map.containsKey(num)) {
                map.put(num, map.get(num) + 1);
            } else map.put(num, 1);
        }
        return map;
    }

    /**将GUI中已选的卡牌直接输出为ExData，省去手动获取已选卡牌的功夫，一般用于{@link com.amotassic.dabaosword.api.skill.ISkill#onGuiClose(PlayerInvScreenHandler, class_1657, Skill, class_1657)}*/
    public ExData toExData() {
        var exData = d(); var clickMap = getClickMap();
        clickMap.forEach((slot, count) -> {
            class_1799 stack = getStack(slot);
            if (isCard(stack)) exData.cards(stack, count, slot < 4);
        });
        return exData;
    }

}
