/*
 * Decompiled with CFR 0.152.
 */
package com.amotassic.dabaosword.api;

import com.amotassic.dabaosword.item.ModItems;
import com.amotassic.dabaosword.util.ModTools;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_7225;

public class CardPileInventory
implements class_1263 {
    public class_2371<class_1799> cards;
    public class_1657 player;
    private static final class_1792 pile = ModItems.CARD_PILE;

    public CardPileInventory(class_1657 player) {
        this.player = player;
        this.cards = class_2371.method_10213((int)36, (Object)class_1799.field_8037);
        this.readNbt();
    }

    public void method_5432(class_1657 player) {
        this.writeNbtToStack();
    }

    public int getEmptySlot() {
        for (int i = 0; i < this.method_5439(); ++i) {
            if (!((class_1799)this.cards.get(i)).method_7960()) continue;
            return i;
        }
        return -1;
    }

    public void readNbt() {
        class_2499 list = ModTools.getOrCreateNbt(ModTools.trinketItem(pile, (class_1309)this.player)).method_10554("Items", 10);
        if (list != null) {
            this.readNbt(list);
        }
    }

    public void readNbt(class_2499 nbtList) {
        this.cards.clear();
        for (int i = 0; i < nbtList.size(); ++i) {
            class_2487 nbtCompound = nbtList.method_10602(i);
            byte j = nbtCompound.method_10571("Slot");
            class_1799 itemStack = class_1799.method_57360((class_7225.class_7874)this.player.method_56673(), (class_2520)nbtCompound).orElse(class_1799.field_8037);
            if (itemStack.method_7960() || j < 0 || j >= this.method_5439()) continue;
            this.method_5447(j, itemStack);
        }
    }

    public void writeNbtToStack() {
        class_2487 nbtCompound;
        if (this.player.method_37908().method_8608()) {
            return;
        }
        class_2499 nbtList = new class_2499();
        for (int i = 0; i < this.method_5439(); ++i) {
            if (((class_1799)this.cards.get(i)).method_7960()) continue;
            nbtCompound = new class_2487();
            nbtCompound.method_10567("Slot", (byte)i);
            nbtList.add((Object)((class_1799)this.cards.get(i)).method_57376((class_7225.class_7874)this.player.method_56673(), (class_2520)nbtCompound));
        }
        class_1799 stack = ModTools.trinketItem(pile, (class_1309)this.player);
        nbtCompound = ModTools.getOrCreateNbt(stack);
        nbtCompound.method_10566("Items", (class_2520)nbtList);
        ModTools.setNbt(stack, nbtCompound);
    }

    public int method_5439() {
        return this.cards.size();
    }

    public boolean method_5442() {
        for (class_1799 itemStack : this.cards) {
            if (itemStack.method_7960()) continue;
            return false;
        }
        return true;
    }

    public boolean isNotFull() {
        for (class_1799 itemStack : this.cards) {
            if (!itemStack.method_7960()) continue;
            return true;
        }
        return false;
    }

    public class_1799 method_5438(int slot) {
        return (class_1799)this.cards.get(slot);
    }

    public int getSlotWith(class_1799 stack) {
        for (int i = 0; i < this.method_5439(); ++i) {
            class_1799 itemStack = this.method_5438(i);
            if (itemStack.method_7960() || !class_1799.method_7973((class_1799)itemStack, (class_1799)stack)) continue;
            return i;
        }
        return -1;
    }

    public boolean removeStack(class_1799 stack, int count) {
        int i = this.getSlotWith(stack);
        if (i == -1) {
            return false;
        }
        this.method_5434(i, count);
        return true;
    }

    public class_1799 method_5434(int slot, int amount) {
        class_1799 stack = class_1262.method_5430(this.cards, (int)slot, (int)amount);
        this.writeNbtToStack();
        return stack;
    }

    public class_1799 method_5441(int slot) {
        class_1799 itemStack = (class_1799)this.cards.get(slot);
        this.cards.set(slot, (Object)class_1799.field_8037);
        this.writeNbtToStack();
        return itemStack;
    }

    public void method_5447(int slot, class_1799 stack) {
        this.cards.set(slot, (Object)stack);
    }

    public void method_5431() {
    }

    public boolean method_5443(class_1657 player) {
        return true;
    }

    public void method_5448() {
        this.cards.clear();
        this.writeNbtToStack();
    }

    public void insertStack(class_1799 stack) {
        if (this.insertStack(-1, stack)) {
            this.writeNbtToStack();
        }
    }

    public boolean insertStack(int slot, class_1799 stack) {
        if (stack.method_7960()) {
            return false;
        }
        if (!stack.method_7986()) {
            int i;
            do {
                i = stack.method_7947();
                if (slot == -1) {
                    stack.method_7939(this.addStack(stack));
                    continue;
                }
                stack.method_7939(this.addStack(slot, stack));
            } while (!stack.method_7960() && stack.method_7947() < i);
            return stack.method_7947() < i;
        }
        if (slot == -1) {
            slot = this.getEmptySlot();
        }
        if (slot >= 0) {
            this.cards.set(slot, (Object)stack.method_51164());
            return true;
        }
        return false;
    }

    private int addStack(class_1799 stack) {
        int i = this.getOccupiedSlotWithRoomForStack(stack);
        if (i == -1) {
            i = this.getEmptySlot();
        }
        if (i == -1) {
            return stack.method_7947();
        }
        return this.addStack(i, stack);
    }

    private int addStack(int slot, class_1799 stack) {
        int j;
        int k;
        int i = stack.method_7947();
        class_1799 itemStack = this.method_5438(slot);
        if (itemStack.method_7960()) {
            itemStack = stack.method_46651(0);
            this.method_5447(slot, itemStack);
        }
        if ((k = Math.min(i, j = this.method_58350(itemStack) - itemStack.method_7947())) != 0) {
            i -= k;
            itemStack.method_7933(k);
        }
        return i;
    }

    public int getOccupiedSlotWithRoomForStack(class_1799 stack) {
        for (int i = 0; i < this.cards.size(); ++i) {
            if (!this.canStackAddMore((class_1799)this.cards.get(i), stack)) continue;
            return i;
        }
        return -1;
    }

    private boolean canStackAddMore(class_1799 existingStack, class_1799 stack) {
        return !existingStack.method_7960() && class_1799.method_31577((class_1799)existingStack, (class_1799)stack) && existingStack.method_7946() && existingStack.method_7947() < this.method_58350(existingStack);
    }
}

