/*
 * Decompiled with CFR 0.152.
 */
package com.amotassic.dabaosword.event;

import com.amotassic.dabaosword.DabaoSword;
import com.amotassic.dabaosword.api.CardPileInventory;
import com.amotassic.dabaosword.api.event.PVPGameTickCallback;
import com.amotassic.dabaosword.item.ModItems;
import com.amotassic.dabaosword.pvpgame.Game;
import com.amotassic.dabaosword.pvpgame.GameManager;
import com.amotassic.dabaosword.util.ModTools;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerWorldEvents;
import net.minecraft.class_124;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_266;
import net.minecraft.class_274;
import net.minecraft.class_2995;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_5250;
import net.minecraft.class_8646;
import net.minecraft.server.MinecraftServer;

public class PVPGameEvents
implements ServerWorldEvents.Load,
ServerTickEvents.StartTick,
ServerTickEvents.StartWorldTick,
PVPGameTickCallback {
    private static GameManager gameManager;
    public static final Map<class_3222, CardPileInventory> PLAYER_CARD_PACKS;

    public static GameManager getGameManager() {
        return gameManager;
    }

    public void onWorldLoad(MinecraftServer server, class_3218 world) {
        if (world.method_27983() == class_1937.field_25179) {
            gameManager = (GameManager)world.method_17983().method_17924(GameManager.getPersistentStateType());
        }
    }

    public void onStartTick(class_3218 world) {
        if (world.method_27983() == class_1937.field_25179) {
            gameManager.tick(world);
        }
    }

    @Override
    public void onGameTick(Game game, class_3218 world) {
        int countDown = game.getCountDown();
        if (game.isWaiting()) {
            this.countDownTip(game, countDown);
        }
        if (countDown == 0) {
            this.onGameStart(game, world);
        }
        if (game.isOn()) {
            this.handleTimeOut(game, game.getTimeOut());
        }
        if (game.neiLives <= 0) {
            if (game.fanLives <= 0) {
                game.win(Game.Identity.ZHONG);
            }
            if (game.zhongLives <= 0) {
                game.win(Game.Identity.FAN);
            }
        } else {
            if (game.fanLives <= 0) {
                this.twoTeam(game, Game.Identity.ZHONG);
                if (game.zhongLives <= 0) {
                    game.win(Game.Identity.NEI);
                }
            }
            if (game.zhongLives <= 0) {
                this.twoTeam(game, Game.Identity.FAN);
            }
        }
    }

    public static void onGameCreate(class_3222 player, Game game, Set<UUID> players) {
        class_5250 text = class_2561.method_43469((String)"dabaosword.game.create", (Object[])new Object[]{player.method_5476(), players.size()});
        if (game.getPrimaryData().get("neiCount") == 0) {
            text = text.method_10852((class_2561)class_2561.method_43471((String)"dabaosword.game.no_turn_coat"));
        }
        class_5250 finalText = text;
        game.forEachPlayer(p -> p.method_64398((class_2561)finalText));
    }

    private void countDownTip(Game game, int countDown) {
        if (countDown % 20 != 0) {
            return;
        }
        game.forEachPlayer(player -> {
            if (countDown % 100 == 0) {
                class_5250 quit = class_2561.method_43471((String)"dabaosword.refuse").method_27692(class_124.field_1061).method_27694(style -> style.method_10958((class_2558)new class_2558.class_10609("/dabaosword refusegame")).method_10949((class_2568)new class_2568.class_10613((class_2561)class_2561.method_43471((String)"dabaosword.refuse_hover"))));
                player.method_64398((class_2561)class_2561.method_43469((String)"dabaosword.game.wait", (Object[])new Object[]{countDown / 20}).method_10852((class_2561)quit));
                return;
            }
            Set<Integer> times = Set.of(Integer.valueOf(60), Integer.valueOf(40), Integer.valueOf(20));
            if (times.contains(countDown)) {
                ModTools.voice((class_1309)player, (class_3414)class_3417.field_14793.comp_349(), new float[0]);
                ModTools.title(player, (class_2561)class_2561.method_43470((String)String.valueOf(countDown / 20)));
            }
        });
    }

    private void onGameStart(Game game, class_3218 world) {
        class_2995 scoreboard = world.method_8503().method_3845();
        class_266 obj = scoreboard.method_1151().stream().filter(o -> o.method_1113().equals("dabaosword.death")).findFirst().orElse(null);
        class_274 criterion = class_274.field_1456;
        if (obj == null) {
            obj = scoreboard.method_1168("dabaosword.death", criterion, (class_2561)class_2561.method_43471((String)"dabaosword.score.death"), criterion.method_1227(), false, null);
        }
        scoreboard.method_1158(class_8646.field_45157, obj);
        game.forEachPlayer(player -> {
            Game.Identity identity = game.getIdentity((class_3222)player);
            class_124 color = Game.getIdentityColor(identity);
            class_5250 o1 = class_2561.method_43471((String)identity.tag);
            class_5250 o2 = class_2561.method_43471((String)(identity.tag + ".tip"));
            class_5250 o3 = class_2561.method_43469((String)"dabaosword.game.start.tip", (Object[])new Object[]{o1, o2}).method_27692(color);
            ModTools.title(player, (class_2561)class_2561.method_43471((String)"dabaosword.game.start").method_27692(class_124.field_1065));
            ModTools.subtitle(player, (class_2561)o3);
            player.method_64398((class_2561)o3);
            ModTools.voice((class_1309)player, (class_3414)class_3417.field_17266.comp_349(), 32.0f);
        });
    }

    private void handleTimeOut(Game game, int timeOut) {
        if (game.getGameTime() % 20 != 0) {
            return;
        }
        if (timeOut == 60 || timeOut == 30) {
            game.forEachPlayer(player -> player.method_64398((class_2561)class_2561.method_43469((String)"dabaosword.game.timeout.warn", (Object[])new Object[]{timeOut}).method_27692(class_124.field_1054)));
        }
        if (timeOut == 0) {
            game.timeOut();
        }
    }

    private void twoTeam(Game game, Game.Identity identity) {
        Game.Identity nei = Game.Identity.NEI;
        if (identity == nei) {
            return;
        }
        if (game.getScore(identity) > game.neiScore) {
            game.win(identity);
        }
        if (game.getScore(identity) < game.neiScore) {
            game.win(nei);
        }
    }

    public void onStartTick(MinecraftServer server) {
        DabaoSword.server = server;
        List playerList = server.method_3760().method_14571();
        for (class_3222 player2 : playerList) {
            if (PLAYER_CARD_PACKS.containsKey(player2) || !ModTools.hasTrinket(ModItems.CARD_PILE, (class_1309)player2)) continue;
            PLAYER_CARD_PACKS.put(player2, new CardPileInventory((class_1657)player2));
        }
        PLAYER_CARD_PACKS.keySet().removeIf(player -> player == null || player.method_31481() || !ModTools.hasTrinket(ModItems.CARD_PILE, (class_1309)player));
    }

    static {
        PLAYER_CARD_PACKS = new HashMap<class_3222, CardPileInventory>();
    }
}

