/*
 * Decompiled with CFR 0.152.
 */
package com.amotassic.dabaosword.item.skillcard.skills;

import com.amotassic.dabaosword.api.skill.ExData;
import com.amotassic.dabaosword.api.skill.Skill;
import com.amotassic.dabaosword.item.card.CardItem;
import com.amotassic.dabaosword.item.skillcard.SkillItem;
import com.amotassic.dabaosword.ui.PlayerInvScreenHandler;
import com.amotassic.dabaosword.util.ModTools;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1713;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2561;

public abstract class ConvertSkill
extends SkillItem {
    public ConvertSkill(class_1792.class_1793 settings) {
        super(settings);
    }

    public abstract Predicate<class_1799> getConvertFilter();

    public boolean chooseEquipment() {
        return false;
    }

    public abstract CardItem convert(class_1799 var1);

    @Override
    public boolean isActiveSkill() {
        return true;
    }

    @Override
    public void addScreenTip(Skill skill, List<class_2561> tips) {
        this.addPresetTips(skill, tips, new Integer[]{0, 1, 2, 3, 4});
        super.addScreenTip(skill, tips);
    }

    @Override
    public boolean activeSkill(class_1657 user, Skill skill) {
        if (skill.getCD() > 0) {
            return false;
        }
        if (ModTools.count((class_1309)user, this.getConvertFilter(), false, true, this.chooseEquipment()) > 0) {
            skill.setMaxSelect(64);
            ModTools.openInv(user, (class_1309)user, user, skill.toHoverableText(), skill.stack, this.chooseEquipment(), false, 2);
            return true;
        }
        return false;
    }

    @Override
    public void onSlotClick(PlayerInvScreenHandler handler, class_1657 player, Skill skill, class_1657 target, int slot, int button, class_1713 action) {
        class_1799 clicked = handler.getStack(slot);
        if (this.getConvertFilter().test(clicked)) {
            super.onSlotClick(handler, player, skill, target, slot, button, action);
        }
    }

    @Override
    public void onGuiClose(PlayerInvScreenHandler handler, class_1657 player, Skill skill, class_1657 target) {
        if (handler.getSelectedCount() > 0) {
            ModTools.voice((class_1309)player, this, new float[0]);
            ExData data = handler.toExData();
            data.forEachCard(3, (card, count) -> {
                class_1799 stack = card.toStack();
                ModTools.give((class_1309)player, ModTools.c(stack, this.convert(stack)).toStack().method_46651(count.intValue()), new int[0]);
            });
            data.clearCards((class_1309)player);
        }
    }
}

