/*
 * Decompiled with CFR 0.152.
 */
package com.amotassic.dabaosword.pvpgame;

import com.amotassic.dabaosword.DabaoSword;
import com.amotassic.dabaosword.api.event.PVPGameTickCallback;
import com.amotassic.dabaosword.event.PVPGameEvents;
import com.amotassic.dabaosword.util.ModConfig;
import com.amotassic.dabaosword.util.ModTools;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1934;
import net.minecraft.class_2561;
import net.minecraft.class_266;
import net.minecraft.class_2995;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_4844;

public class Game {
    public static final MapCodec<Game> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.INT.fieldOf("id").forGetter(game -> game.id), (App)class_4844.field_47491.fieldOf("players").forGetter(game -> game.players), (App)Codec.INT.fieldOf("type").forGetter(game -> game.type), (App)Codec.BOOL.fieldOf("active").forGetter(game -> game.active), (App)Codec.INT.fieldOf("count_down").forGetter(game -> game.countDown), (App)Codec.INT.fieldOf("game_time").forGetter(game -> game.gameTime), (App)Codec.INT.fieldOf("time_out").forGetter(game -> game.timeOut), (App)Codec.INT.fieldOf("zhong_lives").forGetter(game -> game.zhongLives), (App)Codec.INT.fieldOf("fan_lives").forGetter(game -> game.fanLives), (App)Codec.INT.fieldOf("nei_lives").forGetter(game -> game.neiLives), (App)Codec.INT.fieldOf("zhong_score").forGetter(game -> game.zhongScore), (App)Codec.INT.fieldOf("fan_score").forGetter(game -> game.fanScore), (App)Codec.INT.fieldOf("nei_score").forGetter(game -> game.neiScore)).apply((Applicative)instance, Game::new));
    private final int id;
    private final Set<UUID> players = new HashSet<UUID>();
    private final int type;
    private boolean active;
    private int countDown;
    private int gameTime;
    private int timeOut;
    public int zhongLives;
    public int fanLives;
    public int neiLives;
    public int zhongScore;
    public int fanScore;
    public int neiScore;
    private Map<String, Integer> primaryDataCache;
    public static final String FANCOUNT = "fanCount";
    public static final String NEICOUNT = "neiCount";
    public static final String ZHONGCOUNT = "zhongCount";
    public static final String ZHONGLIVES = "zhongLives";
    public static final String FANLIVES = "fanLives";
    public static final String NEILIVES = "neiLives";

    public Game(int id, Set<UUID> players, int type) {
        this.id = id;
        this.players.addAll(players);
        this.type = type;
        this.active = true;
        int waitTime = ModConfig.WaitTime > 5 ? ModConfig.WaitTime : 5;
        this.countDown = waitTime * 20;
        this.gameTime = 0;
        this.timeOut = ModConfig.TimeOut;
        this.initData();
    }

    private Game(int id, Set<UUID> players, int type, boolean active, int countDown, int gameTime, int timeOut, int zhongLives, int fanLives, int neiLives, int zhongScore, int fanScore, int neiScore) {
        this.id = id;
        this.players.addAll(players);
        this.type = type;
        this.active = active;
        this.countDown = countDown;
        this.gameTime = gameTime;
        this.timeOut = timeOut;
        this.zhongLives = zhongLives;
        this.fanLives = fanLives;
        this.neiLives = neiLives;
        this.zhongScore = zhongScore;
        this.fanScore = fanScore;
        this.neiScore = neiScore;
    }

    public Map<String, Integer> getPrimaryData() {
        int fanLives;
        int neiCount;
        if (this.primaryDataCache != null) {
            return this.primaryDataCache;
        }
        HashMap<String, Integer> data = new HashMap<String, Integer>();
        int playerCount = this.getPlayers().size();
        int fanCount = playerCount / 2;
        int n = neiCount = playerCount > 2 ? 1 : 0;
        if (this.type == 1 && playerCount % 2 == 0) {
            neiCount = 0;
        }
        int zhongCount = playerCount - fanCount - neiCount;
        int zhongLives = fanLives = fanCount * 3;
        int neiLives = neiCount > 0 ? fanCount * 3 : 0;
        data.put(FANCOUNT, fanCount);
        data.put(NEICOUNT, neiCount);
        data.put(ZHONGCOUNT, zhongCount);
        data.put(ZHONGLIVES, zhongLives);
        data.put(FANLIVES, fanLives);
        data.put(NEILIVES, neiLives);
        this.primaryDataCache = data;
        return data;
    }

    private void initData() {
        int i;
        Map<String, Integer> primaryData = this.getPrimaryData();
        ArrayList<String> ids = new ArrayList<String>();
        for (i = 0; i < primaryData.get(ZHONGCOUNT); ++i) {
            ids.add(Identity.ZHONG.tag);
        }
        for (i = 0; i < primaryData.get(FANCOUNT); ++i) {
            ids.add(Identity.FAN.tag);
        }
        for (i = 0; i < primaryData.get(NEICOUNT); ++i) {
            ids.add(Identity.NEI.tag);
        }
        Collections.shuffle(ids);
        this.forEachPlayer(player -> {
            player.method_5752().remove("dabaosword.zhong");
            player.method_5752().remove("dabaosword.fan");
            player.method_5752().remove("dabaosword.nei");
            player.method_5780((String)ids.removeFirst());
        });
        this.zhongLives = primaryData.get(ZHONGLIVES);
        this.fanLives = primaryData.get(FANLIVES);
        this.neiLives = primaryData.get(NEILIVES);
        this.neiScore = 0;
        this.fanScore = 0;
        this.zhongScore = 0;
    }

    public boolean isPlayerInThisGame(class_1657 player) {
        return this.players.contains(player.method_5667());
    }

    public int getGameId() {
        return this.id;
    }

    public boolean isActive() {
        return this.active;
    }

    public Set<UUID> getPlayers() {
        return this.players;
    }

    public boolean isWaiting() {
        return this.countDown > 0;
    }

    public int getCountDown() {
        return this.countDown;
    }

    public int getGameTime() {
        return this.gameTime;
    }

    public int getTimeOut() {
        return this.timeOut;
    }

    public boolean isOn() {
        return this.getGameTime() > 0;
    }

    public void refuseGame(class_1657 player) {
        if (!this.isWaiting()) {
            return;
        }
        this.discardGame();
        this.forEachPlayer(p -> {
            p.method_64398((class_2561)class_2561.method_43469((String)"dabaosword.game.refuse", (Object[])new Object[]{player.method_5476()}).method_27692(class_124.field_1061));
            ModTools.voice((class_1309)p, (class_3414)class_3417.field_15239.comp_349(), new float[0]);
        });
    }

    public void win(Identity identity) {
        this.forEachPlayer(player -> {
            if (this.getIdentity((class_3222)player) == identity) {
                ModTools.voice((class_1309)player, "win", new float[0]);
                ModTools.title(player, (class_2561)class_2561.method_43471((String)"dabaosword.game.win").method_27692(class_124.field_1065));
            }
            player.method_64398((class_2561)class_2561.method_43469((String)"dabaosword.game.end", (Object[])new Object[]{class_2561.method_43471((String)identity.tag)}).method_27692(Game.getIdentityColor(identity)));
        });
        this.discardGame();
    }

    public void timeOut() {
        this.forEachPlayer(player -> player.method_64398((class_2561)class_2561.method_43471((String)"dabaosword.game.timeout").method_27692(class_124.field_1061)));
        Integer max = Game.findUniqueMax(this.zhongScore, this.fanScore, this.neiScore);
        if (max == null) {
            this.discardGame();
        } else if (this.zhongScore == max) {
            this.win(Identity.ZHONG);
        } else if (this.fanScore == max) {
            this.win(Identity.FAN);
        } else if (this.neiScore == max) {
            this.win(Identity.NEI);
        }
    }

    public void discardGame() {
        this.active = false;
        class_2995 scoreboard = DabaoSword.server.method_3845();
        class_266 obj = scoreboard.method_1151().stream().filter(o -> o.method_1113().equals("dabaosword.death")).findFirst().orElse(null);
        if (obj != null && PVPGameEvents.getGameManager().getGameCount() <= 1) {
            scoreboard.method_1194(obj);
        }
        this.forEachPlayer(player -> {
            player.method_5752().remove("dabaosword.zhong");
            player.method_5752().remove("dabaosword.fan");
            player.method_5752().remove("dabaosword.nei");
            if (player.method_7325()) {
                player.method_7336(class_1934.field_9215);
                player.method_5768(ModTools.world((class_1297)player));
            }
        });
    }

    public void tick(class_3218 world) {
        if (!this.active) {
            return;
        }
        ((PVPGameTickCallback)PVPGameTickCallback.EVENT.invoker()).onGameTick(this, world);
        if (this.countDown > -1) {
            --this.countDown;
        } else {
            ++this.gameTime;
        }
        if (this.isOn() && this.getGameTime() % 20 == 0) {
            --this.timeOut;
        }
    }

    public void forEachPlayer(Consumer<class_3222> action) {
        for (UUID uuid : this.getPlayers()) {
            class_3222 player = DabaoSword.server.method_3760().method_14602(uuid);
            if (player == null) continue;
            action.accept(player);
        }
    }

    public int getRespawnChances(Identity identity) {
        Map<String, Integer> data = this.getPrimaryData();
        return switch (identity.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> this.zhongLives - data.get(ZHONGCOUNT) + 1;
            case 1 -> this.fanLives - data.get(FANCOUNT) + 1;
            case 2 -> this.neiLives - data.get(NEICOUNT) + 1;
        };
    }

    public int getLives(Identity identity) {
        return switch (identity.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> this.zhongLives;
            case 1 -> this.fanLives;
            case 2 -> this.neiLives;
        };
    }

    public void setLives(Identity identity, int lives) {
        switch (identity.ordinal()) {
            case 0: {
                this.zhongLives = lives;
                break;
            }
            case 1: {
                this.fanLives = lives;
                break;
            }
            case 2: {
                this.neiLives = lives;
            }
        }
    }

    public void decreaseLives(class_3222 player) {
        Identity identity = this.getIdentity(player);
        int lives = this.getLives(identity);
        if (lives > 0) {
            this.setLives(identity, lives - 1);
        }
    }

    public int getScore(Identity identity) {
        return switch (identity.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> this.zhongScore;
            case 1 -> this.fanScore;
            case 2 -> this.neiScore;
        };
    }

    public void setScore(Identity identity, int score) {
        switch (identity.ordinal()) {
            case 0: {
                this.zhongScore = score;
                break;
            }
            case 1: {
                this.fanScore = score;
                break;
            }
            case 2: {
                this.neiScore = score;
            }
        }
    }

    public void increaseScore(class_3222 player) {
        Identity identity = this.getIdentity(player);
        this.setScore(identity, this.getScore(identity) + 1);
        this.timeOut = ModConfig.TimeOut;
        this.forEachPlayer(p -> p.method_64398((class_2561)class_2561.method_43469((String)"dabaosword.score.add", (Object[])new Object[]{player.method_5476()}).method_27692(class_124.field_1067)));
    }

    public Identity getIdentity(class_3222 player) {
        if (player.method_5752().contains(Identity.ZHONG.tag)) {
            return Identity.ZHONG;
        }
        if (player.method_5752().contains(Identity.FAN.tag)) {
            return Identity.FAN;
        }
        return Identity.NEI;
    }

    public static Integer findUniqueMax(int ... numbers) {
        if (numbers.length == 0) {
            return null;
        }
        int max = numbers[0];
        boolean isUnique = true;
        for (int i = 1; i < numbers.length; ++i) {
            if (numbers[i] > max) {
                max = numbers[i];
                isUnique = true;
                continue;
            }
            if (numbers[i] != max) continue;
            isUnique = false;
        }
        return isUnique ? Integer.valueOf(max) : null;
    }

    public static class_124 getIdentityColor(Identity identity) {
        return switch (identity.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> class_124.field_1054;
            case 1 -> class_124.field_1060;
            case 2 -> class_124.field_1078;
        };
    }

    public static enum Identity {
        ZHONG("dabaosword.zhong"),
        FAN("dabaosword.fan"),
        NEI("dabaosword.nei");

        public final String tag;

        private Identity(String tag) {
            this.tag = tag;
        }
    }
}

