/*
 * Decompiled with CFR 0.152.
 */
package com.amotassic.dabaosword.pvpgame;

import com.amotassic.dabaosword.event.PVPGameEvents;
import com.amotassic.dabaosword.pvpgame.Game;
import com.amotassic.dabaosword.util.ModConfig;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_10741;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_18;
import net.minecraft.class_238;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import org.jetbrains.annotations.Nullable;

public class GameManager
extends class_18 {
    public static final Codec<GameManager> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)GameWithId.CODEC.listOf().optionalFieldOf("games", List.of()).forGetter(gameManager -> gameManager.games.int2ObjectEntrySet().stream().map(GameWithId::fromMapEntry).toList()), (App)Codec.INT.fieldOf("next_id").forGetter(raidManager -> raidManager.nextAvailableId)).apply((Applicative)instance, GameManager::new));
    private final Int2ObjectMap<Game> games = new Int2ObjectOpenHashMap();
    private int nextAvailableId;

    public static class_10741<GameManager> getPersistentStateType() {
        return new class_10741("dabaosword_game", GameManager::new, CODEC, null);
    }

    public GameManager() {
        this.method_80();
    }

    public GameManager(List<GameWithId> games, int nextAvailableId) {
        for (GameWithId gameWithId : games) {
            this.games.put(gameWithId.id, (Object)gameWithId.game);
        }
        this.nextAvailableId = nextAvailableId;
        this.method_80();
    }

    public int getGameCount() {
        return this.games.size();
    }

    @Nullable
    public Game createGame(class_3222 player, int type) {
        class_238 box = new class_238(player.method_24515()).method_1014((double)ModConfig.SearchRadius);
        List players = player.method_51469().method_8390(class_1657.class, box, p -> !p.method_7325() && !this.isPlayerInGame((class_1657)p));
        if (players.size() < 2) {
            player.method_64398((class_2561)class_2561.method_43470((String)"Not enough players to start a game!").method_27692(class_124.field_1061));
            return null;
        }
        HashSet<UUID> playerUuids = new HashSet<UUID>();
        for (class_1657 p2 : players) {
            playerUuids.add(p2.method_5667());
        }
        Game game = new Game(this.nextId(), playerUuids, type);
        this.games.put(game.getGameId(), (Object)game);
        PVPGameEvents.onGameCreate(player, game, playerUuids);
        this.method_80();
        return game;
    }

    @Nullable
    public Game getGameByPlayer(class_1657 player) {
        for (Game game : this.games.values()) {
            if (!game.isPlayerInThisGame(player)) continue;
            return game;
        }
        return null;
    }

    public boolean isPlayerInGame(class_1657 player) {
        return this.getGameByPlayer(player) != null;
    }

    public void tick(class_3218 world) {
        ObjectIterator iterator = this.games.values().iterator();
        while (iterator.hasNext()) {
            Game game = (Game)iterator.next();
            if (!game.isActive()) {
                iterator.remove();
                this.method_80();
                continue;
            }
            game.tick(world);
        }
        if (world.method_8510() % 200L == 0L) {
            this.method_80();
        }
    }

    private int nextId() {
        return ++this.nextAvailableId;
    }

    public record GameWithId(int id, Game game) {
        public static final Codec<GameWithId> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("id").forGetter(GameWithId::id), (App)Game.CODEC.forGetter(GameWithId::game)).apply((Applicative)instance, GameWithId::new));

        public static GameWithId fromMapEntry(Int2ObjectMap.Entry<Game> entry) {
            return new GameWithId(entry.getIntKey(), (Game)entry.getValue());
        }
    }
}

