package com.amotassic.dabaosword.api;

import com.amotassic.dabaosword.api.skill.ExData;
import com.amotassic.dabaosword.api.skill.Trigger;
import com.amotassic.dabaosword.item.ModItems;
import com.amotassic.dabaosword.item.card.equipment.Equipment;
import net.minecraft.class_1268;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;

import static com.amotassic.dabaosword.util.ModTools.*;

public class CardEvents {

    public static void cardDiscard(class_1309 entity, ExData exData) {
        exData.forEachCard(1, (c, i) ->
                getResult(Trigger.SHOULD_DISCARD, entity, entity, d().cards(c, i)) > 0);
        exData.forEachCard(2, (c, i) ->
                getResult(Trigger.SHOULD_DISCARD, entity, entity, d().cards(c, i, true)) > 0);
        exData.forEachCard(3, (c, i) -> {cardDecrement(entity, c.origin(), i);});
        getSkillOwners(entity).forEach(player -> getResult(Trigger.LOSE_CARD_DISCARD, player, entity, exData));
    }

    public static void cardMove(class_1309 from, ExData exData, class_1309 to) {
        exData.forEachCard(3, (c, i) -> {
            cardDecrement(from, c.origin(), i);
            give(to, c.toStack().method_46651(i));
        });
        getSkillOwners(from).forEach(player -> {
            getResult(Trigger.LOSE_CARD_MOVE, player, from, exData);
            getResult(Trigger.GET_CARD_MOVE, player, to, exData);
        });
    }

    public static void cardToEquip(class_1309 from, ExData exData, class_1309 to) {
        exData.forEachCard(3, (c, i) -> {
            cardDecrement(from, c.origin(), i);
            Equipment.useOrReplaceEquip(to, c.toStack().method_46651(i));
        });
        getSkillOwners(from).forEach(player -> getResult(Trigger.LOSE_CARD_MOVE, player, from, exData));
    }

    public static void hurtBy(class_1309 e, class_1792 c) {hurtByCard(e, newCard(c));}
    public static void hurtByCard(class_1309 entity, class_1799 card) {
        getSkillOwners(entity).forEach(player ->
                getResult(Trigger.HURT_BY_CARD, player, entity, d().cards(card, card.method_7947())));
    }

    /**专为处理卡牌减少而写的方法，牌堆中的卡牌减少，需要保存nbt*/
    public static void cardDecrement(class_1309 entity, class_1799 stack, int count) {
        if (entity instanceof class_1657 player) {
            if (getCardPack(player).removeStack(stack, count)) return;
            else stack.method_7934(count);
            return;
        }
        stack.method_7934(count);
    }
    /**卡牌使用后减少，不需要传入原始的itemStack*/
    public static void cardUseAndDecrement(class_1309 user, class_1799 card) {
        //即使创造模式，无懈可击也会消耗，为什么呢？我也不知道
        if (card.method_31574(ModItems.WUXIE)) cardDecrement(user, getCard(user, p(ModItems.WUXIE)), 1);
        else {
            //如果使用者是创造模式玩家，则不消耗卡牌
            if (user instanceof class_1657 player && player.method_31549().field_7477) return;
            class_1792 usedItem = card.method_7909();
            //找到和要消耗的完全相同的卡牌，若找不到，则找和要消耗的卡牌同名的牌
            var stack = getCard(user, s -> class_1799.method_7973(s, card));
            if (stack.method_7960()) stack = getCard(user, p(usedItem));
            cardDecrement(user, stack, 1);
            //如果使用者是玩家，且消耗的卡牌stack没了，则尝试补充卡牌
            if (user instanceof class_1657 player && stack.method_7947() == 0) {
                if (isSha.test(usedItem.method_7854())) { //如果使用了杀则补充杀，否则补充同名牌
                    var s = getCard(user, isSha);
                    if (!s.method_7960()) {give(player, s.method_7972()); cardDecrement(player, s, s.method_7947());}
                } else if (player.method_6047().method_7960()) {
                    var s = getCard(user, p(usedItem));
                    if (!s.method_7960()) {player.method_6122(class_1268.field_5808, s.method_7972()); cardDecrement(player, s, s.method_7947());}
                }
            }
        }
    }
}
