package com.amotassic.dabaosword.api;

import com.amotassic.dabaosword.item.ModItems;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_2499;

import static com.amotassic.dabaosword.util.ModTools.*;

public class CardPileInventory implements class_1263 {
    public class_2371<class_1799> cards;
    public class_1657 player;
    private static final class_1792 pile = ModItems.CARD_PILE;

    public CardPileInventory(class_1657 player) {
        this.player = player;
        this.cards = class_2371.method_10213(36, class_1799.field_8037);
        readNbt();
    }

    @Override
    public void method_5432(class_1657 player) {writeNbtToStack();}

    public int getEmptySlot() {
        for (int i = 0; i < method_5439(); ++i) {
            if (!cards.get(i).method_7960()) continue;
            return i;
        }
        return -1;
    }

    public void readNbt() {
        class_2499 list = getOrCreateNbt(trinketItem(pile, player)).method_10554("Items", 10);
        if (list != null) readNbt(list);
    }

    public void readNbt(class_2499 nbtList) {
        cards.clear();
        for (int i = 0; i < nbtList.size(); ++i) {
            class_2487 nbtCompound = nbtList.method_10602(i);
            int j = nbtCompound.method_10571("Slot");
            class_1799 itemStack = class_1799.method_57360(player.method_56673(), nbtCompound).orElse(class_1799.field_8037);
            if (itemStack.method_7960()) continue;
            if (j >= 0 && j < method_5439()) method_5447(j, itemStack);
        }
    }

    public void writeNbtToStack() { //当涉及牌堆物品变化后，必须调用这个方法
        if (player.method_37908().method_8608()) return;
        class_2499 nbtList = new class_2499();
        class_2487 nbtCompound;
        for (int i = 0; i < method_5439(); ++i) {
            if (cards.get(i).method_7960()) continue;
            nbtCompound = new class_2487();
            nbtCompound.method_10567("Slot", (byte) i);
            nbtList.add(cards.get(i).method_57376(player.method_56673(), nbtCompound));
        }
        class_1799 stack = trinketItem(pile, player);
        nbtCompound = getOrCreateNbt(stack);
        nbtCompound.method_10566("Items", nbtList);
        setNbt(stack, nbtCompound);
    }

    @Override
    public int method_5439() {return cards.size();}

    @Override
    public boolean method_5442() {
        for (class_1799 itemStack : cards) {
            if (itemStack.method_7960()) continue;
            return false;
        }
        return true;
    }

    public boolean isNotFull() {
        for (class_1799 itemStack : cards) {
            if (itemStack.method_7960()) return true;
        }
        return false;
    }

    @Override
    public class_1799 method_5438(int slot) {return cards.get(slot);}

    public int getSlotWith(class_1799 stack) { //倒序检索 3.3放弃了倒序检索，会出现bug
        for (int i = 0; i < method_5439(); i++) {
            class_1799 itemStack = method_5438(i);
            if (itemStack.method_7960()) continue;
            if (class_1799.method_7973(itemStack, stack)) return i;
        }
        return -1;
    }

    /**@return 若成功移除指定物品则返回true，否则为false*/
    public boolean removeStack(class_1799 stack, int count) {
        int i = getSlotWith(stack);
        if (i == -1) return false;
        method_5434(i, count);
        return true;
    }

    @Override
    public class_1799 method_5434(int slot, int amount) {
        class_1799 stack = class_1262.method_5430(cards, slot, amount);
        writeNbtToStack();
        return stack;
    }

    @Override
    public class_1799 method_5441(int slot) {
        class_1799 itemStack = cards.get(slot);
        cards.set(slot, class_1799.field_8037);
        writeNbtToStack();
        return itemStack;
    }

    @Override
    public void method_5447(int slot, class_1799 stack) {cards.set(slot, stack);}

    @Override
    public void method_5431() {}

    @Override
    public boolean method_5443(class_1657 player) {return true;}

    @Override
    public void method_5448() {
        cards.clear();
        writeNbtToStack();
    }

    public void insertStack(class_1799 stack) {
        if (insertStack(-1, stack)) writeNbtToStack();
    }

    public boolean insertStack(int slot, class_1799 stack) {
        if (stack.method_7960()) return false;
        if (!stack.method_7986()) {
            int i;
            do {
                i = stack.method_7947();
                if (slot == -1) {
                    stack.method_7939(addStack(stack));
                    continue;
                }
                stack.method_7939(addStack(slot, stack));
            } while (!stack.method_7960() && stack.method_7947() < i);
            return stack.method_7947() < i;
        }
        if (slot == -1) slot = getEmptySlot();
        if (slot >= 0) {
            cards.set(slot, stack.method_51164());
            return true;
        }
        return false;
    }

    private int addStack(class_1799 stack) {
        int i = getOccupiedSlotWithRoomForStack(stack);
        if (i == -1) i = getEmptySlot();
        if (i == -1) return stack.method_7947();
        return addStack(i, stack);
    }

    private int addStack(int slot, class_1799 stack) {
        int i = stack.method_7947();
        class_1799 itemStack = method_5438(slot);
        if (itemStack.method_7960()) {
            itemStack = stack.method_46651(0);
            method_5447(slot, itemStack);
        }
        int j = method_58350(itemStack) - itemStack.method_7947();
        int k = Math.min(i, j);
        if (k != 0) {
            i -= k;
            itemStack.method_7933(k);
        }
        return i;
    }

    public int getOccupiedSlotWithRoomForStack(class_1799 stack) {
        for (int i = 0; i < cards.size(); ++i) {
            if (!canStackAddMore(cards.get(i), stack)) continue;
            return i;
        }
        return -1;
    }

    private boolean canStackAddMore(class_1799 existingStack, class_1799 stack) {
        return !existingStack.method_7960() && class_1799.method_31577(existingStack, stack) && existingStack.method_7946() && existingStack.method_7947() < this.method_58350(existingStack);
    }
}
