package com.amotassic.dabaosword.client;

import com.amotassic.dabaosword.item.skillcard.SkillCards;
import com.amotassic.dabaosword.network.ActiveSkillPayload;
import com.amotassic.dabaosword.network.QuickSwapPayload;
import com.amotassic.dabaosword.network.ShensuPayload;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1309;
import net.minecraft.class_243;
import net.minecraft.class_304;
import net.minecraft.class_3966;
import org.lwjgl.glfw.GLFW;

import static com.amotassic.dabaosword.util.ModTools.*;

public class ClientTickEnd {
    public static final class_304 ACTIVE_SKILL = keyBinding("active_skill", GLFW.GLFW_KEY_J);
    public static final class_304 SELECT_CARD = keyBinding("select_card", GLFW.GLFW_KEY_K);

    public static void initialize() {
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            var user = client.field_1724;
            var ctrl = client.field_1690.field_1867;
            if (user != null) {
                if (hasTrinket(SkillCards.SHENSU, user)) {
                    class_243 lastPos = new class_243(user.field_6038, user.field_5971, user.field_5989);
                    float speed = (float) (user.method_19538().method_1022(lastPos) * 20);
                    ClientPlayNetworking.send(new ShensuPayload(speed));
                }

                if (SELECT_CARD.method_1436()) {
                    int i = 0;
                    if (user.method_5715() && ctrl.method_1436()) i = 3;
                    else if (ctrl.method_1436()) i = 2;
                    ClientPlayNetworking.send(new QuickSwapPayload(i));
                    return;
                }

                var result = client.field_1765; class_1309 target;
                if (result instanceof class_3966 eResult && eResult.method_17782() instanceof class_1309 entity) {
                    target = entity;
                } else target = user;

                if (ACTIVE_SKILL.method_1436() && isEquipped(user, s -> s(s).isActiveSkill())) {
                    ClientPlayNetworking.send(new ActiveSkillPayload(target.method_5628()));
                }
            }
        });
    }

    private static class_304 keyBinding(String name, int key) {
        String category = "category.dabaosword.keybindings";
        return KeyBindingHelper.registerKeyBinding(new class_304("key.dabaosword." + name, key, category));
    }
}
