package com.amotassic.dabaosword.client;

import com.amotassic.dabaosword.item.ModItems;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.rendering.v1.HudRenderCallback;
import net.minecraft.class_1802;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_9779;

@Environment(value= EnvType.CLIENT)
public class TiesuoHud implements HudRenderCallback {

    private static final class_2960 TIESUO_HUD = class_2960.method_60655("dabaosword","textures/misc/tiesuo_hud.png");

    private int scaledWidth;
    private int scaledHeight;
    private float tiesuoScale;

    @Override
    public void onHudRender(class_332 drawContext, class_9779 tickCounter) {
        class_310 client = class_310.method_1551();
        this.scaledWidth = drawContext.method_51421();
        this.scaledHeight = drawContext.method_51443();
        float f = tickCounter.method_60636();
        this.tiesuoScale = class_3532.method_16439(0.5f * f, this.tiesuoScale, 1.125f);
        if (client.field_1690.method_31044().method_31034()) {
            var player = client.field_1724;
            if (player != null && player.method_6115() && player.method_6030().method_31574(ModItems.TIESUO) && player.method_6079().method_7909() == class_1802.field_8361) {
                this.renderTiesuoOverlay(drawContext, this.tiesuoScale);
            }
        }
    }

    private void renderTiesuoOverlay(class_332 context, float scale) {
        float f;
        float g = f = (float)Math.max(this.scaledWidth, this.scaledHeight);
        float h = Math.max((float)this.scaledWidth / f, (float)this.scaledHeight / g) * scale;
        int i = class_3532.method_15375(f * h);
        int j = class_3532.method_15375(g * h);
        int k = (this.scaledWidth - i) / 2;
        int l = (this.scaledHeight - j) / 2;
        int m = k + i;
        int n = l + j;
        context.method_25290(class_1921::method_62277, TIESUO_HUD, k, l, 0.0f, 0.0f, i, j, i, j);
        context.method_48196(class_1921.method_51785(), 0, n, this.scaledWidth, this.scaledHeight, -90, -16777216);
        context.method_48196(class_1921.method_51785(), 0, 0, this.scaledWidth, l, -90, -16777216);
        context.method_48196(class_1921.method_51785(), 0, l, k, n, -90, -16777216);
        context.method_48196(class_1921.method_51785(), m, l, this.scaledWidth, n, -90, -16777216);
    }
}
