package com.amotassic.dabaosword.command;

import com.amotassic.dabaosword.api.skill.Skill;
import com.amotassic.dabaosword.pvpgame.Game;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.class_124;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2168;
import net.minecraft.class_2186;
import net.minecraft.class_2287;
import net.minecraft.class_2290;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_7157;

import static com.amotassic.dabaosword.event.PVPGameEvents.getGameManager;
import static com.amotassic.dabaosword.util.ModTools.s;
import static com.amotassic.dabaosword.util.ModTools.trinketItem;
import static net.minecraft.class_2170.method_9244;
import static net.minecraft.class_2170.method_9247;

public class DabaoSwordCommand {
    public static void register(CommandDispatcher<class_2168> dispatcher, class_7157 access) {
        dispatcher.register(method_9247("dabaosword")
                .requires(source -> source.method_9228() != null)
                .executes(c -> help(c.getSource(), 0))
                .then(method_9244("page", IntegerArgumentType.integer())
                        .executes(c -> help(c.getSource(), IntegerArgumentType.getInteger(c, "page")))
                )
                .then(method_9244("user", class_2186.method_9305())
                        .then(method_9244("skill", class_2287.method_9776(access))
                                .executes(c -> skill(class_2186.method_9315(c, "user"), class_2287.method_9777(c, "skill"), class_2186.method_9315(c, "user")))
                                .then(method_9244("target", class_2186.method_9309())
                                        .executes(c -> skill(class_2186.method_9315(c, "user"), class_2287.method_9777(c, "skill"), (class_1309) class_2186.method_9313(c, "target")))
                                        .then(method_9244("value", IntegerArgumentType.integer())
                                                .executes(c -> skill(class_2186.method_9315(c, "user"), class_2287.method_9777(c, "skill"), (class_1309) class_2186.method_9313(c, "target"), IntegerArgumentType.getInteger(c, "value")))
                                        )
                                )
                        )
                )
                .then(method_9247("creategame")
                        .then(method_9244("type", IntegerArgumentType.integer())
                                .executes(c -> createGame(c.getSource(), IntegerArgumentType.getInteger(c, "type")))
                        )
                )
                .then(method_9247("refusegame").executes(DabaoSwordCommand::refuseGame))
                .then(method_9247("discardgame").requires(source -> source.method_9259(2))
                        .executes(c -> discardGame(c.getSource(), null))
                        .then(method_9244("player", class_2186.method_9305())
                                .executes(c -> discardGame(c.getSource(), class_2186.method_9315(c, "player")))
                        )
                )
                .then(method_9247("viewidentity")
                        .then(method_9244("target", class_2186.method_9305())
                                .executes(c -> viewIdentity(c.getSource(), class_2186.method_9315(c, "target")))
                        )
                )
        );
    }

    private static int skill(class_1657 user, class_2290 stack, class_1309 target, int... value) {
        int val = value.length == 0 ? 0 : value[0];
        class_1799 skill = trinketItem(stack.method_9785(), user);
        if (skill.method_7909() instanceof CSkill s) s.triggerSkill(user, s(skill), target, val);
        return 1;
    }

    public interface CSkill {
        void triggerSkill(class_1309 entity, Skill skill, class_1309 target, int value);
    }

    private static int createGame(class_2168 ctx, int type) throws CommandSyntaxException {
        class_3222 player = ctx.method_9207();
        Game game = getGameManager().createGame(player, type);
        if (game == null) return 0;
        return 1;
    }

    private static int refuseGame(CommandContext<class_2168> ctx) throws CommandSyntaxException {
        class_3222 player = ctx.getSource().method_9207();
        Game game = getGameManager().getGameByPlayer(player);
        if (game == null) return 0;
        if (!game.isWaiting()) return 0;
        game.refuseGame(player);
        return 1;
    }

    private static int discardGame(class_2168 ctx, class_3222 player) throws CommandSyntaxException {
        if (player == null) player = ctx.method_9207();
        Game game = getGameManager().getGameByPlayer(player);
        if (game == null) {
            ctx.method_45068(class_2561.method_43469("dabaosword.game.not_found", player.method_5476()).method_27692(class_124.field_1061));
            return 0;
        }
        game.discardGame();
        ctx.method_9226(() -> class_2561.method_43470("Game discarded!"), false);
        return 1;
    }

    private static int viewIdentity(class_2168 source, class_3222 target) throws CommandSyntaxException {
        var player = source.method_9207();
        Game game = getGameManager().getGameByPlayer(target);
        if (game == null) {
            source.method_45068(class_2561.method_43469("dabaosword.game.not_found", target.method_5476()).method_27692(class_124.field_1061));
            return 0;
        }
        Game.Identity id = game.getIdentity(target);
        if (player == target) {
            feedbackIdentity(source, target, id);
            return 1;
        } else {
            if (player.method_64475(2)) {
                feedbackIdentity(source, target, id);
                return 1;
            } else {
                source.method_45068(class_2561.method_43471("dabaosword.game.view_id.fail").method_27692(class_124.field_1061));
                return 0;
            }
        }
    }
    private static void feedbackIdentity(class_2168 source, class_3222 target, Game.Identity id) {
        source.method_9226(() -> class_2561.method_43469("dabaosword.game.view_id.tip", target.method_5476(), class_2561.method_43471(id.tag)).method_27695(Game.getIdentityColor(id), class_124.field_1067), false);
    }

    private static int help(class_2168 source, int page) throws CommandSyntaxException {
        var player = source.method_9207();
        switch (page) {
            case 0 -> {
                player.method_64398(class_2561.method_43471("dabaosword.welcome"));
                class_5250 text = class_2561.method_43471("dabaosword.mainpage").method_27692(class_124.field_1075).method_27694(style -> style.method_10958(new class_2558(class_2558.class_2559.field_11749, "https://modrinth.com/mod/dabaosword")).method_10949(new class_2568(class_2568.class_5247.field_24342, class_2561.method_43470("Modrinth")))).method_10852(

                class_2561.method_43471("dabaosword.help.menu").method_27692(class_124.field_1075).method_27694(style -> style.method_10958(new class_2558(class_2558.class_2559.field_11750, "/dabaosword 1")).method_10949(new class_2568(class_2568.class_5247.field_24342, class_2561.method_43471("dabaosword.help.menu_hover")))));
                //System.out.println(Text.Serializer.toSortedJsonString(t1.append(t2))); //用于获取json文本
                player.method_64398(text);
            }
            case 1 -> player.method_64398(menu);
            case 2 -> {
                class_5250 text = class_2561.method_43471("dabaosword.rule").method_27692(class_124.field_1075).method_27694(style -> style.method_10958(new class_2558(class_2558.class_2559.field_11750, "/dabaosword 3"))).method_10852(

                class_2561.method_43471("dabaosword.newgame0").method_27692(class_124.field_1075).method_27694(style -> style.method_10958(new class_2558(class_2558.class_2559.field_11750, "/dabaosword creategame 0")).method_10949(new class_2568(class_2568.class_5247.field_24342, class_2561.method_43471("dabaosword.newgame0_hover"))))).method_10852(

                class_2561.method_43471("dabaosword.newgame1").method_27692(class_124.field_1075).method_27694(style -> style.method_10958(new class_2558(class_2558.class_2559.field_11750, "/dabaosword creategame 1")).method_10949(new class_2568(class_2568.class_5247.field_24342, class_2561.method_43471("dabaosword.newgame1_hover"))))
                );
                player.method_64398(text);
            }
            case 3 -> {
                player.method_64398(class_2561.method_43471("dabaosword.rule1"));
                player.method_64398(class_2561.method_43471("dabaosword.rule2"));
                player.method_64398(class_2561.method_43471("dabaosword.rule3"));
                player.method_64398(class_2561.method_43471("dabaosword.rule4"));
                player.method_64398(class_2561.method_43471("dabaosword.rule5"));
            }
        }
        return 1;
    }

    private static final class_5250 info = class_2561.method_43471("dabaosword.help.info").method_27692(class_124.field_1075).method_27694(style -> style.method_10958(new class_2558(class_2558.class_2559.field_11745, "/info ")).method_10949(new class_2568(class_2568.class_5247.field_24342, class_2561.method_43471("dabaosword.help.info_hover")))),
    newGame = class_2561.method_43471("dabaosword.newgame").method_27692(class_124.field_1075).method_27694(style -> style.method_10958(new class_2558(class_2558.class_2559.field_11750, "/dabaosword 2")).method_10949(new class_2568(class_2568.class_5247.field_24342, class_2561.method_43471("dabaosword.newgame_hover")))),
    viewId = class_2561.method_43471("dabaosword.viewid").method_27692(class_124.field_1075).method_27694(style -> style.method_10958(new class_2558(class_2558.class_2559.field_11745, "/dabaosword viewidentity @s")).method_10949(new class_2568(class_2568.class_5247.field_24342, class_2561.method_43471("dabaosword.viewid_hover")))),
    disGame = class_2561.method_43471("dabaosword.disgame").method_27692(class_124.field_1076).method_27694(style -> style.method_10958(new class_2558(class_2558.class_2559.field_11745, "/dabaosword discardgame ")).method_10949(new class_2568(class_2568.class_5247.field_24342, class_2561.method_43471("dabaosword.disgame_hover"))));
    public static final class_5250 menu = info.method_10852(newGame).method_10852(viewId).method_10852(disGame);
}
