package com.amotassic.dabaosword.datagen;

import com.amotassic.dabaosword.item.ModItems;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricAdvancementProvider;
import net.minecraft.class_161;
import net.minecraft.class_170;
import net.minecraft.class_189;
import net.minecraft.class_2066;
import net.minecraft.class_2135;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_7225;
import net.minecraft.class_8779;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;

public class AdvancementsProvider extends FabricAdvancementProvider {
    public AdvancementsProvider(FabricDataOutput output, CompletableFuture<class_7225.class_7874> r) {
        super(output, r);
    }

    @Override
    public void generateAdvancement(class_7225.class_7874 wrapperLookup, Consumer<class_8779> consumer) {
        ADVANCEMENTS.keySet().forEach(name -> consumer.accept(get(name)));
    }

    private static final Map<String, class_161.class_162> ADVANCEMENTS = new HashMap<>();

    private static class_8779 add(String name, class_161.class_162 builder) {
        ADVANCEMENTS.put(name, builder);
        class_2960 id = class_2960.method_60655("dabaosword", name);
        return builder.method_695(id);
    }

    public static class_8779 get(String name) {
        class_2960 id = class_2960.method_60655("dabaosword", name);
        return ADVANCEMENTS.get(name).method_695(id);
    }

    private static final class_8779 root = add("root", class_161.class_162.method_707()
            .method_706(class_170.class_171.method_34901(class_2960.method_60655("dabaosword", "root")).method_751())
            .method_697(ModItems.BBJI,
                    class_2561.method_43471("advancement.dabaosword.root.title"),
                    class_2561.method_43471("advancement.dabaosword.root.tip"),
                    class_2960.method_60654("textures/gui/advancements/backgrounds/adventure.png"),
                    class_189.field_1254, true, false, false
            ).method_705("root", class_2135.class_2137.method_49195()));

    static {
        add("card_pile", class_161.class_162.method_707().method_701(root)
                .method_697(ModItems.CARD_PILE,
                        class_2561.method_43471("advancement.dabaosword.card_pile.title"),
                        class_2561.method_43471("advancement.dabaosword.card_pile.tip"),
                        null,
                        class_189.field_1254, true, true, false
                ).method_705("card_pile", class_2066.class_2068.method_8959(ModItems.CARD_PILE)));

        add("gift_box", class_161.class_162.method_707().method_701(root)
                .method_697(ModItems.GIFTBOX,
                        class_2561.method_43471("advancement.dabaosword.gift_box.title"),
                        class_2561.method_43471("advancement.dabaosword.gift_box.tip"),
                        null,
                        class_189.field_1254, true, true, false
                ).method_705("gift_box", class_2066.class_2068.method_8959(ModItems.GIFTBOX)));
    }
}
