package com.amotassic.dabaosword.event;

import com.amotassic.dabaosword.api.CardEvents;
import com.amotassic.dabaosword.api.event.PlayerDeathCallback;
import com.amotassic.dabaosword.api.event.PlayerRespawnCallback;
import com.amotassic.dabaosword.api.skill.ExData;
import com.amotassic.dabaosword.item.ModItems;
import com.amotassic.dabaosword.pvpgame.Game;
import com.amotassic.dabaosword.util.Gamerule;
import com.amotassic.dabaosword.util.ModConfig;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_124;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_1934;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;

import static com.amotassic.dabaosword.event.PVPGameEvents.getGameManager;
import static com.amotassic.dabaosword.util.ModTools.*;

public class PlayerEvents implements PlayerDeathCallback, PlayerRespawnCallback {
    private static final Map<UUID, KillStreakData> playerKillData = new HashMap<>();
    private record KillStreakData(int streak, long lastKillTime) {}
    private static String getKillSound(int streak) {
        return switch (streak) {
            case 1, 2, 3, 4, 5, 6, 7 -> "kill" + streak;
            default -> "diankuang";
        };
    }

    @Override
    public void onDeath(class_3222 player, class_1282 source) {
        if (player.method_37908() instanceof class_3218 world) {
            class_1297 attacker = source.method_5529();
            if (!(attacker instanceof class_1657)) attacker = player.method_6124();

            if (ModConfig.KillStreak && attacker instanceof class_3222 killer) { //紫砂也算连上了
                UUID id = killer.method_5667(); long time = world.method_8510();

                var data = playerKillData.getOrDefault(id, new KillStreakData(0, 0));
                long timeDiff = time - data.lastKillTime();
                int newStreak = (0 <= timeDiff && timeDiff <= 1200) ? data.streak() + 1 : 1;
                data = new KillStreakData(newStreak, time);
                playerKillData.put(id, data);

                if (data.streak() >= 2) voice(killer, getKillSound(data.streak()));
            }

            if (attacker instanceof class_3222 killer && killer != player) {
                Game game = getGameManager().getGameByPlayer(killer);
                if (game != null && game.isOn() && game.isPlayerInThisGame(player)) {
                    var primaryData = game.getPrimaryData();
                    if (ModConfig.KillStreak && game.zhongLives + game.fanLives + game.neiLives == primaryData.get(Game.ZHONGLIVES) + primaryData.get(Game.FANLIVES) + primaryData.get(Game.NEILIVES)) voice(killer, getKillSound(1));

                    var killerTeam = game.getIdentity(killer); var deadTeam = game.getIdentity(player);
                    if (deadTeam != Game.Identity.NEI && killerTeam != deadTeam) game.increaseScore(killer);
                }
            }

            //玩家死亡时，若处于对战中，减少该玩家所在队伍的剩余生命数
            Game game = getGameManager().getGameByPlayer(player);
            if (game != null && game.isOn()) {
                game.decreaseLives(player);
                var identity = game.getIdentity(player);
                int re = game.getRespawnChances(identity);
                if (re <= 0) { //如果玩家所在阵营剩余复活次数为0，公布玩家身份
                    player.method_7336(class_1934.field_9219);
                    game.forEachPlayer(p -> p.method_64398(class_2561.method_43469("dabaosword.game.view_id.tip", player.method_5476(), class_2561.method_43471(identity.tag)).method_27695(Game.getIdentityColor(identity), class_124.field_1067)));
                }
            }

            if (world.method_64395().method_8355(Gamerule.CLEAR_CARDS_AFTER_DEATH)) {
                CardEvents.cardDiscard(player, cardsToDrop(player));
            }

            if (hasItem(player, p(ModItems.BBJI))) voice(player, "xuyou");
            player.method_5752().remove("duanchang");
        }
    }

    public static ExData cardsToDrop(class_1657 player) {
        var data = d();
        var inventory = getCardPack(player);
        for (var stack : inventory.cards) data.cards(stack, stack.method_7947());

        class_1661 inv = player.method_31548();
        for (int i = 0; i < inv.method_5439(); ++i) {
            class_1799 stack = inv.method_5438(i);
            if (isCard(stack)) data.cards(stack, stack.method_7947());
        }

        for (var stack : allTrinkets(player)) {
            if(isCard(stack)) data.cards(stack, stack.method_7947(), true);
        }
        return data;
    }

    @Override
    public void onPlayerRespawn(class_3222 oldPlayer, class_3222 player) {
        if (player.method_37908() instanceof class_3218 world) {

            boolean card = world.method_64395().method_8355(Gamerule.CLEAR_CARDS_AFTER_DEATH);
            if (card && hasTrinket(ModItems.CARD_PILE, player)) {
                give(player, newCard(ModItems.SHA));
                give(player, newCard(ModItems.SHAN));
                give(player, newCard(ModItems.PEACH));
                draw(player);
            }

        }
    }
}
