package com.amotassic.dabaosword.item;

import com.amotassic.dabaosword.api.event.*;
import com.amotassic.dabaosword.effect.*;
import com.amotassic.dabaosword.entity.ModEntity;
import com.amotassic.dabaosword.event.*;
import com.amotassic.dabaosword.item.card.*;
import com.amotassic.dabaosword.item.card.equipment.Armor;
import com.amotassic.dabaosword.item.card.equipment.Mount;
import com.amotassic.dabaosword.item.card.equipment.Weapon;
import com.amotassic.dabaosword.item.skillcard.SkillCards;
import com.amotassic.dabaosword.item.skillcard.SkillItem;
import com.amotassic.dabaosword.item.tool.*;
import com.amotassic.dabaosword.network.ActiveSkillPayload;
import com.amotassic.dabaosword.network.OpenScreenPayload;
import com.amotassic.dabaosword.ui.FullInvScreenHandler;
import com.amotassic.dabaosword.ui.PileScreenHandler;
import com.amotassic.dabaosword.ui.PlayerInvScreenHandler;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerWorldEvents;
import net.fabricmc.fabric.api.event.player.AttackEntityCallback;
import net.fabricmc.fabric.api.itemgroup.v1.FabricItemGroup;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerType;
import net.minecraft.class_1291;
import net.minecraft.class_1304;
import net.minecraft.class_1322;
import net.minecraft.class_1747;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1814;
import net.minecraft.class_1826;
import net.minecraft.class_1887;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3917;
import net.minecraft.class_4081;
import net.minecraft.class_5134;
import net.minecraft.class_5321;
import net.minecraft.class_5699;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_9135;
import net.minecraft.class_9300;
import net.minecraft.class_9331;
import net.minecraft.class_9334;
import net.minecraft.item.*;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.UnaryOperator;

@SuppressWarnings("unused")
public class ModItems {
    public static final List<CardItem> CARDS = new ArrayList<>();
    //杀
    public static final CardItem
    SHA = registerCard("sha", Sha::new),
    FIRE_SHA = registerCard("fire_sha", Sha.Fire::new),
    THUNDER_SHA = registerCard("thunder_sha", Sha.Thunder::new),
    //闪
    SHAN = registerCard("shan", ShanItem::new),
    //桃
    PEACH = registerCard("peach", PeachItem::new),
    //酒
    JIU = registerCard("jiu", JiuItem::new),

    //兵粮寸断
    BINGLIANG_ITEM = registerCard("bingliang", BingliangItem::new),
    //乐不思蜀
    TOO_HAPPY_ITEM = registerCard("too_happy", TooHappyItem::new),
    //闪电
    SHANDIAN_ITEM = registerCard("shandian", ShandianItem::new),
    //过河拆桥
    DISCARD = registerCard("discard", DiscardItem::new),
    //火攻
    FIRE_ATTACK = registerCard("huogong", FireAttackItem::new),
    //借刀杀人
    JIEDAO = registerCard("jiedao", JiedaoItem::new),
    //决斗
    JUEDOU = registerCard("juedou", JuedouItem::new),
    //南蛮入侵
    NANMAN = registerCard("nanman", NanmanItem::new),
    //顺手牵羊
    STEAL = registerCard("steal", StealItem::new),
    //桃园结义
    TAOYUAN = registerCard("taoyuan", TaoyuanItem::new),
    //铁锁连环
    TIESUO = registerCard("tiesuo", TiesuoItem::new),
    //万箭齐发
    WANJIAN = registerCard("wanjian", WanjianItem::new),
    //五谷丰登
    WUGU = registerCard("wugu", WuguItem::new),
    //无懈可击
    WUXIE = registerCard("wuxie", CardItem.Armoury::new),
    //无中生有
    WUZHONG = registerCard("wuzhong", WuzhongItem::new),

    //雌雄双股剑
    CIXIONG = registerCard("cixiong", Weapon.Cixiong::new, 1),
    //方天画戟
    FANGTIAN = registerCard("fangtian", Weapon.Fangtian::new, 1),
    //贯石斧
    GUANSHI = registerCard("guanshi", Weapon.Guanshi::new, 1),
    // 古锭刀
    GUDING_WEAPON = registerCard("guding_dao", Weapon.Guding::new, 1),
    //寒冰剑
    HANBING = registerCard("hanbing", Weapon.Hanbing::new, 1),
    //麒麟弓
    QILIN = registerCard("qilin", Weapon.Qilin::new, 1),
    //青釭剑
    QINGGANG = registerCard("qinggang", Weapon.Qinggang::new, 1),
    //青龙偃月刀
    QINGLONG = registerCard("qinglong", Weapon.Qinglong::new, 1),
    //丈八蛇矛
    ZHANGBA = registerCard("zhangba", Weapon.Zhangba::new, 1),
    //诸葛连弩
    LIANNU = registerCard("liannu", Weapon.Liannu::new, 1),
    //朱雀羽扇
    ZHUQUE = registerCard("zhuque", Weapon.Zhuque::new, 1),
    //八卦阵
    BAGUA = registerCard("bagua", Armor.Bagua::new, 1),
    //白银狮子
    BAIYIN = registerCard("baiyin", Armor.Baiyin::new, 1),
    //仁王盾
    RENWANG = registerCard("renwang", Armor.Renwang::new, 1),
    //寿衣
    RATTAN_ARMOR = registerCard("rattan_armor", Armor.Rattan::new, 1),
    //-1马
    CHITU = registerCard("chitu", Mount.Attack::new, 1),
    //+1马
    DILU = registerCard("dilu", Mount.Defend::new, 1);

    public static final class_1792
    //摸牌
    GAIN_CARD = register("gain_card", GainCardItem::new),
    //牌堆
    CARD_PILE = register("card_pile", CardPile::new, 1),
    //礼盒
    GIFTBOX = register("gift_box", GiftBoxItem::new, new class_1792.class_1793().method_7894(class_1814.field_8907)),
    GUDINGDAO = register("gudingdao", GudingdaoItem::new, new class_1792.class_1793().method_7895(999).method_7894(class_1814.field_8904)),
    ARROW_RAIN = register("arrow_rain", ArrowRainItem::new, new class_1792.class_1793().method_7895(50).method_7894(class_1814.field_8907)),
    //BB机
    BBJI = register("bbji", BBjiItem::new, new class_1792.class_1793().method_7895(250).method_7894(class_1814.field_8907)),
    //让我康康
    LET_ME_CC = register("let_me_cc", LetMeCCItem::new, 1),
    //阳光开朗的笑容
    SUNSHINE_SMILE = register("sunshine_smile", SunshineSmile::new, new class_1792.class_1793().method_7895(999).method_7894(class_1814.field_8907).method_63682(class_1304.field_6169).method_61649(25).method_57349(class_9334.field_49630, new class_9300(true))),
    XUYOU_SPAWN_EGG = register("xuyou_spawn_egg", s -> new class_1826(ModEntity.XUYOU, s)),
    GUDING_ITEM = register("guding", class_1792::new),
    INCOMPLETE_GUDINGDAO = register("incomplete_gdd", class_1792::new, 1);
    public static final CardItem EMPTY_CARD = register("empty_card", CardItem.Empty::new);
    public static final SkillItem EMPTY_SKILL = register("empty_skill", SkillItem::new);

    public static <T extends class_1792> T register(String id, Function<class_1792.class_1793, T> factory, int... maxCount) {
        class_1792.class_1793 settings = new class_1792.class_1793();
        if (maxCount.length > 0) settings = settings.method_7889(maxCount[0]);
        return register(id, factory, settings);
    }
    /**将注册的卡牌添加到卡牌列表中，便于自动将物品添加到物品组*/
    public static CardItem registerCard(String name, Function<class_1792.class_1793, CardItem> factory, int... maxCount) {
        CardItem card = register(name, factory, maxCount);
        CARDS.add(card);
        return card;
    }

    public static <T extends class_1792> T register(String id, Function<class_1792.class_1793, T> factory, class_1792.class_1793 settings) {
        var key = class_5321.method_29179(class_7924.field_41197, class_2960.method_60655("dabaosword", id));
        T item = factory.apply(settings.method_63686(key));
        if (item instanceof class_1747 blockItem) blockItem.method_7713(class_1792.field_8003, item);
        return class_2378.method_39197(class_7923.field_41178, key, item);
    }

    public static final class_5321<class_1761> ZZRS = class_5321.method_29179(class_7924.field_44688, class_2960.method_60655("dabaosword", "zzrs"));

    private static void addToGroup(class_1761.class_8128 context, class_1761.class_7704 entries) {
        var wrapper = context.comp_1253().method_46762(class_7924.field_41265);
        var entry = wrapper.method_46747(CRIT);
        class_1799 smile = new class_1799(SUNSHINE_SMILE);
        smile.method_7978(entry, 1);
        //添加所有卡牌
        CARDS.forEach(entries::method_45421);
        entries.method_45421(GAIN_CARD);
        entries.method_45421(CARD_PILE);
        //添加所有技能
        SkillCards.SKILLS.forEach(entries::method_45421);

        entries.method_45421(GIFTBOX);
        entries.method_45421(BBJI);
        entries.method_45421(LET_ME_CC);
        entries.method_45420(smile);
        entries.method_45421(XUYOU_SPAWN_EGG);
    }

    //注册部分
    public static void register() {
        class_2378.method_39197(class_7923.field_44687, ZZRS,
                FabricItemGroup.builder().method_47320(() -> new class_1799(SUNSHINE_SMILE))
                        .method_47321(class_2561.method_43471("itemGroup.dabaosword.zzrs"))
                        .method_47317(ModItems::addToGroup).method_47324());

        ServerWorldEvents.LOAD.register(new PVPGameEvents());
        ServerTickEvents.START_SERVER_TICK.register(new PVPGameEvents());
        ServerTickEvents.START_WORLD_TICK.register(new PVPGameEvents());
        PVPGameTickCallback.EVENT.register(new PVPGameEvents());
        AttackEntityCallback.EVENT.register(new AttackEntityHandler());
        EntityHurtCallback.EVENT.register(new EntityHurtHandler());
        PlayerDeathCallback.EVENT.register(new PlayerEvents());
        PlayerRespawnCallback.EVENT.register(new PlayerEvents());
        EndEntityTick.LIVING_EVENT.register(new EntityTickEvents());
        EndEntityTick.PLAYER_EVENT.register(new EntityTickEvents());
    }

    private static class_6880<class_1291> register(String id, class_1291 statusEffect) {
        return class_2378.method_47985(class_7923.field_41174, class_2960.method_60655("dabaosword", id), statusEffect);
    }//状态效果注册
    //兵粮寸断效果
    public static final class_6880<class_1291> BINGLIANG = register("bingliang",
            new CommonEffect(class_4081.field_18272, 0x46F732).method_5566(class_5134.field_23721, class_2960.method_60654("bingliang"),-4, class_1322.class_1323.field_6328)),
    //乐不思蜀效果
    TOO_HAPPY = register("too_happy", new TooHappyEffect().method_5566(class_5134.field_23719, class_2960.method_60654("too_happy"),-10, class_1322.class_1323.field_6331)),
    //触及距离增加
    REACH = register("reach", new CommonEffect(class_4081.field_18271, 0xFFFFFF)
            .method_5566(class_5134.field_47758, class_2960.method_60654("reach_block"), 1.0, class_1322.class_1323.field_6328)
            .method_5566(class_5134.field_47759, class_2960.method_60654("attack_range"), 1.0, class_1322.class_1323.field_6328)),
    //近战防御范围增加
    DEFEND = register("defend", new CommonEffect(class_4081.field_18271, 0xFFFFFF)),
    DEFENDED = register("defended", new CommonEffect(class_4081.field_18272, 0xFFFFFF).method_5566(class_5134.field_47759, class_2960.method_60654("attack_range_lower"), -1.0, class_1322.class_1323.field_6328)),
    //冷却状态效果
    COOLDOWN = register("cooldown", new CooldownEffect()),
    COOLDOWN2 = register("cooldown2", new Cooldown2Effect()),
    //无敌效果
    INVULNERABLE = register("invulnerable", new CommonEffect(class_4081.field_18271,0x35F5DF)),
    //下落攻击效果
    FALLING_ATTACK = register("falling_attack", new FallingEffect()),
    //翻面效果
    TURNOVER = register("turn_over", new TurnOverEffect()),
    //铁骑效果
    TIEJI = register("tieji", new CommonEffect(class_4081.field_18272, 0x07050F)),
    //闪电效果
    SHANDIAN = register("shandian", new ShandianEffect());

    //物品组件注册
    public static final class_9331<Integer> TAGS = component("tags", builder -> builder.method_57881(class_5699.field_33441).method_57882(class_9135.field_48550));
    public static final class_9331<Integer> CD = component("cd", builder -> builder.method_57881(class_5699.field_33441).method_57882(class_9135.field_48550));

    private static <T> class_9331<T> component(String id, UnaryOperator<class_9331.class_9332<T>> builderOperator) {
        return class_2378.method_10230(class_7923.field_49658, class_2960.method_60655("dabaosword",id), (builderOperator.apply(class_9331.method_57873())).method_57880());
    }

    public static final class_3917<PlayerInvScreenHandler> PLAYER_INV_SCREEN_HANDLER = class_2378.method_10226(class_7923.field_41187, "player_inv", new ExtendedScreenHandlerType<>(PlayerInvScreenHandler::new, OpenScreenPayload.CODEC));

    public static final class_3917<FullInvScreenHandler> FULL_INV_SCREEN_HANDLER = class_2378.method_10226(class_7923.field_41187, "full_inv", new ExtendedScreenHandlerType<>(FullInvScreenHandler::new, OpenScreenPayload.CODEC));

    public static final class_3917<PileScreenHandler> PILE_SCREEN_HANDLER = class_2378.method_10226(class_7923.field_41187, "card_pile", new ExtendedScreenHandlerType<>(PileScreenHandler::new, ActiveSkillPayload.CODEC));

    public static final class_5321<class_1887> CRIT = class_5321.method_29179(class_7924.field_41265, class_2960.method_60654("dabaosword:crit"));
}
