package com.amotassic.dabaosword.item.card;

import com.amotassic.dabaosword.api.CardEvents;
import com.amotassic.dabaosword.api.card.Card;
import com.amotassic.dabaosword.api.card.Rank;
import com.amotassic.dabaosword.api.card.Suit;
import com.amotassic.dabaosword.api.skill.Trigger;
import com.amotassic.dabaosword.item.ModItems;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_9280;
import net.minecraft.class_9334;

import static com.amotassic.dabaosword.util.ModTools.*;
import static net.minecraft.class_124.*;

public abstract class CardItem extends class_1792 {
    public CardItem(class_1793 settings) {super(settings);}

    public abstract int getType();

    public void effect(class_1309 user, class_1799 card, class_1309 target) {}

    @Override
    public void method_7851(class_1799 stack, class_9635 context, List<class_2561> tooltip, class_1836 type) {
        addSRTip(c(stack), tooltip); addTip(stack, tooltip);
    }

    public void addTip(class_1799 stack, List<class_2561> tooltip) {

        if (stack.method_31574(ModItems.SHAN)) {
            tooltip.add(class_2561.method_43471("item.dabaosword.shan.tip").method_27692(field_1067));
            tooltip.add(getTip());
        }

        if (stack.method_31574(ModItems.PEACH)) {
            tooltip.add(getTip("1", field_1076));
            tooltip.add(getTip("2", field_1076));
            tooltip.add(class_2561.method_43471("item.dabaosword.recover.tip").method_27692(field_1067));
        }

        if (stack.method_31574(ModItems.JIU)) {
            tooltip.add(getTip());
            tooltip.add(class_2561.method_43471("item.dabaosword.recover.tip").method_27692(field_1067));
        }

        if (stack.method_31574(ModItems.FIRE_ATTACK) || stack.method_31574(ModItems.JIEDAO) || stack.method_31574(ModItems.NANMAN) || stack.method_31574(ModItems.TAOYUAN) || stack.method_31574(ModItems.TIESUO) || stack.method_31574(ModItems.JUEDOU)) tooltip.add(getTip());

        if (stack.method_31574(ModItems.SHANDIAN_ITEM) || stack.method_31574(ModItems.WUGU) || stack.method_31574(ModItems.WUXIE) || stack.method_31574(ModItems.STEAL) || stack.method_31574(ModItems.WUZHONG) || stack.method_31574(ModItems.DISCARD)) {
            tooltip.add(getTip("1"));
            tooltip.add(getTip("2"));
        }

        if (stack.method_31574(ModItems.DISCARD) || stack.method_31574(ModItems.JUEDOU)) {
            tooltip.add(class_2561.method_43471("item.dabaosword.long_hand").method_27692(field_1067));
        }

        if (stack.method_31574(ModItems.BINGLIANG_ITEM)) {
            if (class_437.method_25442()) {
                tooltip.add(getTip("1"));
                tooltip.add(getTip("2"));
            } else {
                tooltip.add(getTip(field_1078));
                tooltip.add(class_2561.method_43469("dabaosword.shift_tip", class_2561.method_43472("key.sneak")));
            }
        }

        if (stack.method_31574(ModItems.TOO_HAPPY_ITEM)) {
            if (class_437.method_25442()) {
                tooltip.add(getTip("1"));
                tooltip.add(getTip("2"));
            } else {
                tooltip.add(getTip(field_1061));
                tooltip.add(class_2561.method_43469("dabaosword.shift_tip", class_2561.method_43472("key.sneak")));
            }
        }

        if (stack.method_31574(ModItems.WANJIAN)) { //有大病的工具提示
            if (class_437.method_25442()) {
                int i = (int) (System.currentTimeMillis() / 1000) % 7;
                switch (i) {
                    case 1 -> tooltip.add(getTip("1", field_1075));
                    case 2 -> tooltip.add(getTip("2", field_1061));
                    case 3 -> tooltip.add(getTip("3", field_1065));
                    case 4 -> tooltip.add(getTip("4", field_1060));
                    case 5 -> tooltip.add(getTip("5", field_1064));
                    case 6 -> tooltip.add(getTip("6", field_1054));
                    case 0 -> tooltip.add(getTip("7", field_1078));
                }
            } else {
                tooltip.add(getTip());
                tooltip.add(class_2561.method_43469("item.dabaosword.wanjian.shift", class_2561.method_43472("key.sneak")).method_27692(field_1056));
            }
        }
    }
    public class_5250 getTip(class_124... format) {return getTip("", format);}
    public class_5250 getTip(String suffix, class_124... format) {
        return class_2561.method_43471(method_7876() + ".tooltip" + suffix).method_27695(format);
    }

    public final void addSRTip(Card card, List<class_2561> tooltip) {
        if (card.suit == Suit.None || card.rank == Rank.None) return;
        tooltip.add(class_2561.method_43469("card.suit_and_rank", card.suit.suit, card.rank.rank).method_27692(card.suit.color));
    }

    public static void onUse(class_1309 user, class_1799 stack, class_1309... targets) {
        onUse(user, stack, false, targets);
    }
    public static void onUse(class_1309 user, class_1799 stack, boolean noTarget, class_1309... targets) {
        onUse(user, stack, noTarget, true, targets);
    }
    /**
     * @param noTarget 表示卡牌完全没有使用目标，类似于三国杀的“打出”。
     * @param consume 是否消耗卡牌。用于虚拟牌，如八卦阵视为使用的闪。
     * @param targets 卡牌的目标。对于我的mod中不便于选择目标的卡牌（比如火攻、万箭齐发等），需要将使用者填到目标中，否则卡牌不会执行任何效果。
     */
    public static void onUse(class_1309 user, class_1799 stack, boolean noTarget, boolean consume, class_1309... targets) {
        var card = c(stack); var cardData = d().cards(card, card.count);
        if (consume) CardEvents.cardUseAndDecrement(user, stack);
        if (card.type != 2) voice(user, card.item());
        List<class_1309> owners = getSkillOwners(user);
        //触发卡牌使用事件
        owners.forEach(player -> getResult(Trigger.LOSE_CARD_USE, player, user, cardData));

        if (noTarget) return;
        var data = cardData.withTargets(targets);
        //触发修改卡牌目标的技能
        owners.forEach(player -> getResult(Trigger.ADD_TARGET, player, user, data));
        owners.forEach(player -> getResult(Trigger.DROP_TARGET, player, user, data));
        for (class_1309 target : data.targets) {
            //当卡牌指定目标后，触发使用者的技能
            getResult(Trigger.SELECT_TARGET, user, target, cardData);
            //当有玩家成为卡牌目标后，触发玩家的技能
            owners.forEach(player -> getResult(Trigger.BECOME_TARGET, player, target, cardData));

            if (card.askForWuxie() && hasCard(target, p(ModItems.WUXIE))) { //如果目标有无懈可击，则使用无懈可击
                onUse(target, new class_1799(ModItems.WUXIE), true);
                continue;
            }
            card.effect(user, card.toStack(), target);
        }
    }

    @Override
    public void method_7888(class_1799 stack, class_1937 world, class_1297 entity, int slot, boolean selected) {
        addModel(stack, world);
    }

    public static void addModel(class_1799 stack, class_1937 world) {
        if (world.field_9236) return;
        if (stack.method_57824(class_9334.field_49637) != null) return;
        var card = c(stack);
        if (card.suit == Suit.None || card.rank == Rank.None) return;
        int s = card.suit.ordinal();
        int r = card.rank.ordinal() + 1;
        float f = 13 * s + r;
        stack.method_57379(class_9334.field_49637, new class_9280(List.of(f), List.of(), List.of(), List.of()));
    }

    public static class Basic extends CardItem {
        public Basic(class_1793 settings) {super(settings);}

        public final int getType() {return Card.BASIC;}
    }

    public static class Armoury extends CardItem {
        public Armoury(class_1793 settings) {super(settings);}

        public final int getType() {return Card.ARMOURY;}

        public boolean askForWuxie() {return false;}
    }

    public static class Empty extends CardItem {
        public Empty(class_1793 settings) {super(settings);}

        public int getType() {return 114;}
    }
}
