package com.amotassic.dabaosword.item.card;

import com.amotassic.dabaosword.item.ModItems;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1584;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_3218;

import static com.amotassic.dabaosword.api.CardEvents.hurtByCard;
import static com.amotassic.dabaosword.util.ModTools.world;

public class NanmanItem extends CardItem.Armoury {
    public NanmanItem(class_1793 settings) {super(settings);}

    @Override
    public class_1269 method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        if (world instanceof class_3218 sw && hand == class_1268.field_5808) {

            Set<class_1309> targets = new HashSet<>(sw.method_18456());
            class_238 box = new class_238(user.method_24515()).method_1014(10);
            Predicate<class_1309> p = e -> e.method_5805() && !e.method_5752().contains("b");
            targets.addAll(world.method_8390(class_1309.class, box, p));
            targets.remove(user);

            user.method_5780("nanman"); //防止触发杀
            onUse(user, user.method_6047(), targets.toArray(new class_1309[0]));
            return class_1269.field_52422;
        }
        return super.method_7836(world, user, hand);
    }

    @Override
    public void effect(class_1309 user, class_1799 card, class_1309 entity) {
        class_1282 source = user.method_48923().method_48812(user);
        //防止触发闪
        entity.method_6092(new class_1293(ModItems.COOLDOWN2, 2, 0, false, false));
        if (entity.method_64397(world(user), source, 6)) hurtByCard(entity, card);
        summonRavager(entity);
    }

    private void summonRavager(class_1309 entity) {
        class_1937 world = entity.method_37908();
        class_1584 ravager = new class_1584(class_1299.field_6134, world);
        ravager.method_5665(class_2561.method_30163(String.valueOf(entity.method_5628())));
        world.method_8649(ravager);
        ravager.method_5684(true);
        ravager.method_5780("a"); ravager.method_5780("b");
        ravager.method_29495(getBlockInFront(entity, 3));
    }

    public class_243 getBlockInFront(class_1309 entity, int distance) {
        class_243 pos = entity.method_19538();
        class_243 playerDirection = entity.method_5828(1.0F);
        double x = pos.field_1352 + playerDirection.field_1352 * distance;
        double z = pos.field_1350 + playerDirection.field_1350 * distance;
        return new class_243(x, pos.field_1351, z);
    }

    @Override public boolean askForWuxie() {return true;}
}
