package com.amotassic.dabaosword.item.card;

import com.amotassic.dabaosword.api.CardEvents;
import com.amotassic.dabaosword.api.skill.Trigger;
import com.amotassic.dabaosword.effect.ShandianEffect;
import com.amotassic.dabaosword.item.ModItems;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1282;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_8111;

import static com.amotassic.dabaosword.api.CardEvents.hurtByCard;
import static com.amotassic.dabaosword.util.ModTools.*;

public class Sha extends CardItem.Basic {
    public Sha(class_1793 settings) {super(settings);}

    @Override
    public void addTip(class_1799 stack, List<class_2561> tooltip) {
        tooltip.add(class_2561.method_43471("item.dabaosword.sha.tip").method_27692(class_124.field_1067));

        if (stack.method_31574(ModItems.SHA)) tooltip.add(getTip());
        if (stack.method_31574(ModItems.FIRE_SHA)) tooltip.add(getTip(class_124.field_1061));
        if (stack.method_31574(ModItems.THUNDER_SHA)) tooltip.add(getTip(class_124.field_1078));
    }

    public static void shaUse(class_1309 user, class_1799 stack, float amount, class_1309... targets) {
        shaUse(user, stack, amount, true, targets);
    }
    public static void shaUse(class_1309 user, class_1799 stack, float amount, boolean consume, class_1309... targets) {
        var card = c(stack); var cardData = d().cards(card, card.count);
        if (consume) CardEvents.cardUseAndDecrement(user, stack);
        voice(user, card.item());
        List<class_1309> owners = getSkillOwners(user);
        //触发卡牌使用事件
        owners.forEach(player -> getResult(Trigger.LOSE_CARD_USE, player, user, cardData));

        var data = cardData.withTargets(targets);
        //触发修改卡牌目标的技能
        owners.forEach(player -> getResult(Trigger.ADD_TARGET, player, user, data));
        owners.forEach(player -> getResult(Trigger.DROP_TARGET, player, user, data));
        for (class_1309 entity : data.targets) {
            //当卡牌指定目标后，触发使用者的技能
            getResult(Trigger.SELECT_TARGET, user, entity, cardData);
            //当有玩家成为卡牌目标后，触发玩家的技能
            owners.forEach(player -> getResult(Trigger.BECOME_TARGET, player, entity, cardData));

            Sha sha = (Sha) card.toStack().method_7909();
            if (sha.sha(user, entity, amount)) sha.effect(user, card.toStack(), entity);
            else { //如果杀被无效化了，就会尝试触发贯石斧的效果
                var guanshi = s(trinketItem(ModItems.GUANSHI, user));
                if (!guanshi.isEmpty() && guanshi.getCD() == 0 && entity.method_6059(ModItems.INVULNERABLE)) {
                    guanshi.setCD(10); voice(user, guanshi.stack);
                    entity.method_6016(ModItems.INVULNERABLE);
                    if (sha.sha(user, entity, amount)) sha.effect(user, card.toStack(), entity);
                }
            }
        }
    }

    /**原本的伤害处理被取消，改为由杀造成伤害，因此一定要用{@link class_1309#method_64397(class_3218, class_1282, float)}来造成伤害
     * @param amount 原本的伤害值*/
    public boolean sha(class_1309 user, class_1309 target, float amount) {
        return target.method_64397(world(user), user.method_48923().method_48812(user), amount + 5);
    }

    @Override
    public void effect(class_1309 user, class_1799 card, class_1309 target) {
        hurtByCard(target, card);
    }

    public static class Fire extends Sha {
        public Fire(class_1793 settings) {super(settings);}

        @Override
        public boolean sha(class_1309 user, class_1309 target, float amount) {
            target.method_33572(true);
            return target.method_64397(world(user), damageSource(user, class_8111.field_42337), amount);
        }

        @Override
        public void effect(class_1309 user, class_1799 sha, class_1309 target) {
            target.method_5639(6);
            hurtByCard(target, sha);
        }
    }

    public static class Thunder extends Sha {
        public Thunder(class_1793 settings) {super(settings);}

        @Override
        public boolean sha(class_1309 user, class_1309 target, float amount) {
            return target.method_64397(world(user), damageSource(user, class_8111.field_42336), amount + 5);
        }

        @Override
        public void effect(class_1309 user, class_1799 sha, class_1309 target) {
            ShandianEffect.summonLightning(target, true, false);
            hurtByCard(target, sha);
        }
    }
}